/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.extra;

import com.elluminate.extra.ExTRA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class PreviewExTRA
extends JDialog
implements ActionListener {
    private static ResourceBundle i18n = null;
    private JButton ok = null;
    private JButton save = null;
    private JTextPane display = new JTextPane();

    public PreviewExTRA(Frame parent, String title, final ExTRA report) {
        super(parent, title, false);
        try {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        JPanel btnPanel = new JPanel(new BorderLayout());
                        JScrollPane scroller = new JScrollPane(PreviewExTRA.this.display);
                        StyledDocument doc = PreviewExTRA.this.display.getStyledDocument();
                        Style basic = doc.addStyle("Basic", null);
                        Style xml = doc.addStyle("XML", basic);
                        Style meta = doc.addStyle("Meta", basic);
                        PreviewExTRA.this.ok = new JButton(i18n.getString("ExTRA.ok"));
                        PreviewExTRA.this.save = new JButton(i18n.getString("ExTRA.save"));
                        PreviewExTRA.this.display.setMargin(new Insets(1, 4, 1, 4));
                        PreviewExTRA.this.display.setBackground(Color.WHITE);
                        String defaultButtonAction = "default-button";
                        AbstractAction dismissAction = new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PreviewExTRA.this.ok.doClick();
                            }
                        };
                        PreviewExTRA.this.display.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "default-button");
                        PreviewExTRA.this.display.getActionMap().put("default-button", dismissAction);
                        PreviewExTRA.this.display.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "default-button");
                        PreviewExTRA.this.display.getActionMap().put("default-button", dismissAction);
                        scroller.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
                        scroller.setBackground(PreviewExTRA.this.display.getBackground());
                        btnPanel.setBorder(BorderFactory.createEmptyBorder(14, 14, 14, 14));
                        basic.addAttribute(StyleConstants.FontFamily, "Monospaced");
                        basic.addAttribute(StyleConstants.FontSize, new Integer(12));
                        basic.addAttribute(StyleConstants.Foreground, Color.black);
                        xml.addAttribute(StyleConstants.Foreground, Color.red);
                        meta.addAttribute(StyleConstants.Foreground, Color.blue);
                        StringTokenizer parser = new StringTokenizer(report.toString(), "\n");
                        while (parser.hasMoreTokens()) {
                            String line = parser.nextToken();
                            String trim = line.trim();
                            if (trim.startsWith("<?")) {
                                PreviewExTRA.this.display.setCharacterAttributes(meta, true);
                            } else if (trim.startsWith("<")) {
                                PreviewExTRA.this.display.setCharacterAttributes(xml, true);
                            } else {
                                PreviewExTRA.this.display.setCharacterAttributes(basic, true);
                            }
                            PreviewExTRA.this.display.replaceSelection(line);
                            PreviewExTRA.this.display.replaceSelection("\n");
                        }
                        PreviewExTRA.this.display.setCaretPosition(0);
                        PreviewExTRA.this.display.setEditable(false);
                        PreviewExTRA.this.ok.addActionListener(PreviewExTRA.this);
                        btnPanel.add((Component)PreviewExTRA.this.ok, "East");
                        PreviewExTRA.this.save.addActionListener(PreviewExTRA.this);
                        btnPanel.add((Component)PreviewExTRA.this.save, "West");
                        btnPanel.add(Box.createHorizontalGlue(), "Center");
                        PreviewExTRA.this.getContentPane().add((Component)scroller, "Center");
                        PreviewExTRA.this.getContentPane().add((Component)btnPanel, "South");
                        PreviewExTRA.this.getRootPane().setDefaultButton(PreviewExTRA.this.ok);
                    }
                    catch (Throwable t) {
                        ExTRA.reportException(PreviewExTRA.class, "run", t);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (InterruptedException intx) {
            Thread.currentThread().interrupt();
        }
        catch (Throwable t) {
            ExTRA.reportException(PreviewExTRA.class, "<init>", t);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.ok) {
            this.setVisible(false);
        } else if (src == this.save) {
            this.saveReport();
        }
    }

    private boolean approveSaveFile(JFileChooser parent, File f) {
        if (f == null) {
            return false;
        }
        if (!f.exists()) {
            return true;
        }
        if (f.isDirectory()) {
            String title = i18n.getString("ExTRA.badFileTitle");
            String msg = MessageFormat.format(i18n.getString("ExTRA.badFileMsg"), f.getName());
            JOptionPane.showMessageDialog(parent, msg, title, 0);
            return false;
        }
        String title = i18n.getString("ExTRA.overwriteTitle");
        String msg = MessageFormat.format(i18n.getString("ExTRA.overwriteMsg"), f.getName());
        int which = JOptionPane.showConfirmDialog(parent, msg, title, 0);
        return which == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReport() {
        JFileChooser chooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                if (PreviewExTRA.this.approveSaveFile(this, this.getSelectedFile())) {
                    super.approveSelection();
                }
            }
        };
        int which = chooser.showSaveDialog(this);
        if (which != 0) {
            return;
        }
        File f = chooser.getSelectedFile();
        String text = this.display.getText();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(f);
            pw.print(text);
        }
        catch (Throwable t) {
            String title = i18n.getString("ExTRA.saveErrorTitle");
            String msg = MessageFormat.format(i18n.getString("ExTRA.saveErrorMsg"), t.toString());
            JOptionPane.showMessageDialog(this, msg, title, 0);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    static {
        i18n = ResourceBundle.getBundle(PreviewExTRA.class.getPackage().getName() + ".Strings");
    }
}

