/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.extra;

import com.elluminate.extra.QueryExTRA;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.CodeSource;
import java.security.MessageDigest;
import java.security.ProtectionDomain;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.ImageIcon;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ExTRA {
    private static final int POST_LIMIT = 10;
    private static final String EVENT_LOOP = "at java.awt.EventDispatchThread.pumpOneEvent";
    private static final String DFT_MESSAGE = "/com/elluminate/extra/ExTRA.html";
    private static final int DFT_HEIGHT = 320;
    private static final int DFT_WIDTH = 480;
    private static final boolean IS_MAC = System.getProperty("os.name", "").startsWith("Mac");
    public static final String EXTRA_SETTINGS = "ExTRA.properties";
    private static File propFile = null;
    private static String propertyFileName = null;
    private static String propertyFilePath = null;
    private static boolean shuttingDown = false;
    private static Object lock = new Object();
    private static Map<String, String> staticFields = new TreeMap<String, String>();
    private static URL target = null;
    private static String prefix = null;
    private static String messageRsrc = "/com/elluminate/extra/ExTRA.html";
    private static URL messageURL = null;
    private static String messageHtml = null;
    private static ImageIcon icon = null;
    private static Set<ExTRA> history = new HashSet<ExTRA>();
    private static boolean exiting = false;
    private static int exitStatus = 0;
    private static LinkedList<String> heirarchies = new LinkedList();
    private static LinkedList<String> toIgnore = new LinkedList();
    private static String sentList = null;
    private static final AtomicInteger postCount = new AtomicInteger();
    private static volatile Method msgHandler = null;
    private static volatile Method errHandler = null;
    public static final String VERSION = "1.1";
    private static final String INDENT = "    ";
    private Map<String, Elem> elements;
    private BigInteger signature;
    private Throwable throwable;
    private long clock;
    private String serial = null;
    private static final String EXTRA_PREFERENCES_HEADER = "ExTRA Preferences";
    private static boolean deferSave = true;
    private static Properties encachedProps = null;

    public static String getPropertyFileName() {
        return propertyFileName;
    }

    public static void setPropertyFileName(String propertyFileName) {
        ExTRA.propertyFileName = propertyFileName;
    }

    public static String getPropertyFilePath() {
        return propertyFilePath;
    }

    public static void setPropertyFilePath(String propertyFilePath) {
        ExTRA.propertyFilePath = propertyFilePath;
    }

    public static void init(Object context, URL sendTo, String pfx) {
        target = sendTo;
        prefix = pfx;
        ExTRA.initFields(context);
    }

    public static void setApplication(String appName, String version) {
        ExTRA.setField("application", appName);
        ExTRA.setField("version", version);
    }

    public static void setPropertySaveFile(File f) {
        propFile = f;
    }

    public static File getPropertySaveFile() {
        return propFile;
    }

    public static boolean isInitialized() {
        return target != null;
    }

    public static void setMessageResource(String resource) {
        messageRsrc = resource;
        messageURL = null;
        messageHtml = null;
    }

    public static void setMessageURL(URL url) {
        messageURL = url;
        messageRsrc = null;
        messageHtml = null;
    }

    public static void setMessageHtml(String html) {
        messageHtml = html;
        messageURL = null;
        messageRsrc = null;
    }

    public static void setIcon(ImageIcon dlgIcon) {
        icon = dlgIcon;
    }

    public static ImageIcon getIcon() {
        return icon;
    }

    public static void addHeirarchy(String pkg) {
        heirarchies.add(pkg);
    }

    public static void removeHeirarchy(String pkg) {
        heirarchies.remove(pkg);
    }

    public static void addIgnored(String pkg) {
        toIgnore.add(pkg);
    }

    public static void removeIgnored(String pkg) {
        toIgnore.remove(pkg);
    }

    public static void postException(Throwable t) {
        ExTRA.postException(null, t, null, null);
    }

    public static void postException(String src, Throwable t) {
        ExTRA.postException(src, t, null, null);
    }

    public static void postException(String src, Throwable t, String msg) {
        ExTRA.postException(src, t, msg, null);
    }

    public static void postException(String src, Throwable t, String msg, Map<String, String> extraFields) {
        if (target == null) {
            return;
        }
        if (!ExTRA.checkHeirarchy(t)) {
            return;
        }
        ExTRA report = new ExTRA(t);
        if (!ExTRA.checkHistory(report)) {
            return;
        }
        if (exiting || shuttingDown) {
            return;
        }
        int ordinal = postCount.incrementAndGet();
        if (ordinal > 10) {
            return;
        }
        report.addElement("ordinal", "" + ordinal);
        if (src != null) {
            report.addElement("source", src);
        }
        if (msg != null) {
            report.addElement("message", msg);
        }
        if (extraFields != null) {
            report.merge(extraFields);
        }
        SendPolicy policy = ExTRA.getSendPolicy();
        switch (policy) {
            case NEVER: {
                return;
            }
            case ALWAYS: {
                new DeliveryAgent(report).start();
                return;
            }
            case QUERY: 
            case UNDEFINED: {
                SwingUtilities.invokeLater(new QueryAgent(report));
                return;
            }
        }
    }

    public static void setField(String name, String value) {
        if (value == null) {
            staticFields.remove(name);
        } else {
            staticFields.put(name, value);
        }
    }

    public static SendPolicy getSendPolicy() {
        SendPolicy policy;
        Properties props = ExTRA.loadProps();
        String key = prefix + ".sendPolicy";
        String value = props.getProperty(key, SendPolicy.UNDEFINED.name());
        try {
            policy = SendPolicy.valueOf(value);
        }
        catch (Throwable t) {
            policy = SendPolicy.UNDEFINED;
        }
        return policy;
    }

    public static void setSendPolicy(SendPolicy level) {
        Properties props = ExTRA.loadProps();
        String key = prefix + ".sendPolicy";
        props.put(key, level.toString());
        ExTRA.storeProps(props);
    }

    public static String getEmail() {
        Properties props = ExTRA.loadProps();
        return props.getProperty(prefix + ".email");
    }

    public static void setEmail(String address) {
        Properties props = ExTRA.loadProps();
        String key = prefix + ".email";
        if (address == null || address.equals("")) {
            props.remove(key);
        } else {
            props.put(key, address);
        }
        ExTRA.storeProps(props);
    }

    public static List<ExTRA> getHistory() {
        TreeMap<Long, ExTRA> sorted = new TreeMap<Long, ExTRA>();
        for (ExTRA extra : history) {
            sorted.put(extra.getReportTime(), extra);
        }
        return new ArrayList<ExTRA>(sorted.values());
    }

    public static void shuttingDown() {
        shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exit(int status) {
        LinkedList<Frame> closeList = new LinkedList<Frame>();
        Object object = lock;
        synchronized (object) {
            if (exiting) {
                return;
            }
            if (QueryExTRA.getActive().isEmpty()) {
                System.exit(status);
            }
            exiting = true;
            exitStatus = status;
            try {
                Set<QueryExTRA> active = QueryExTRA.getActive();
                Method getFrames = Frame.class.getMethod("getFrames", new Class[0]);
                Frame[] frames = (Frame[])getFrames.invoke(null, new Object[0]);
                for (int i = 0; i < frames.length; ++i) {
                    if (active.contains(frames[i]) || !frames[i].isVisible()) continue;
                    closeList.add(frames[i]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (Frame f : closeList) {
            f.setVisible(false);
        }
    }

    public static void setMessageHandler(Method handler) {
        msgHandler = handler;
    }

    public static void setErrorHandler(Method handler) {
        errHandler = handler;
    }

    protected static void initFields(Object context) {
        ExTRA.setField("codebase", ExTRA.getCodebase(context));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss Z");
        ExTRA.setField("startTime", fmt.format(new Date()));
        String uid = ExTRA.getUID();
        if ((uid == null || uid.length() < 16) && (uid = ExTRA.generateClientID()) != null) {
            ExTRA.setUID(uid);
        }
        ExTRA.setField("uid", uid);
        String sessionID = ExTRA.generateClientID();
        ExTRA.setField("runUID", sessionID);
        RuntimeMXBean rtmxBean = ManagementFactory.getRuntimeMXBean();
        if (rtmxBean != null) {
            StringBuilder argInfo = new StringBuilder();
            Iterator<String> itr = rtmxBean.getInputArguments().iterator();
            while (itr.hasNext()) {
                if (argInfo.length() > 0) {
                    argInfo.append(" ");
                }
                argInfo.append(itr.next());
            }
            ExTRA.setField("jvm.args", argInfo.toString());
        }
        ExTRA.setField("processors", "" + Runtime.getRuntime().availableProcessors());
        Locale locale = Locale.getDefault();
        ExTRA.setField("locale", locale.toString() + "\n" + locale.getDisplayName(Locale.US));
        ExTRA.setField("language", locale.getLanguage() + "\n" + locale.getDisplayLanguage(Locale.US));
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String lafInfo = null;
                try {
                    LookAndFeel laf = UIManager.getLookAndFeel();
                    lafInfo = laf.getName() + " (" + laf.getID() + ") " + laf.getClass().getName() + "\n" + laf.getDescription();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (lafInfo != null) {
                    ExTRA.setField("lookAndFeel", lafInfo);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private static String getCodebase(Object context) {
        ProtectionDomain dom;
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            Object basicService = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            Method get = basicService.getClass().getMethod("getCodeBase", new Class[0]);
            Object cbase = get.invoke(null, new Object[0]);
            if (cbase != null) {
                return "JNLP codebase=" + cbase.toString();
            }
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (context == null) {
            context = ExTRA.class;
        }
        CodeSource src = (dom = context.getClass().getProtectionDomain()) == null ? null : dom.getCodeSource();
        URL loc = src == null ? null : src.getLocation();
        return "ref=" + context.getClass().getName() + (loc != null ? "\nlocation=" + loc.toString() : "");
    }

    private static String getSanitizedProperties() {
        StringBuilder result = new StringBuilder();
        Properties props = System.getProperties();
        ArrayList<String> redactionList = new ArrayList<String>();
        String javaHome = props.getProperty("java.home");
        if (javaHome != null && IS_MAC) {
            javaHome = new File(javaHome).getParent();
        }
        redactionList.add(javaHome);
        redactionList.add(props.getProperty("user.home"));
        String javaUri = new File(javaHome).toURI().toString();
        redactionList.add(javaUri);
        String userName = props.getProperty("user.name");
        if (userName != null && userName.length() > 3) {
            char ch;
            redactionList.add(userName);
            String s = userName.toLowerCase();
            if (!redactionList.contains(s)) {
                redactionList.add(s);
            }
            if (!redactionList.contains(s = userName.toUpperCase())) {
                redactionList.add(s);
            }
            if (!Character.isUpperCase(ch = userName.charAt(0)) && ch != Character.toUpperCase(ch) && !redactionList.contains(s = Character.toUpperCase(ch) + userName.substring(1))) {
                redactionList.add(s);
            }
        }
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        for (Object key : keys) {
            if (key == null) continue;
            try {
                String val = props.getProperty(key.toString());
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(key + " = " + ExTRA.sanitizeProperty(val, redactionList));
            }
            catch (Throwable t) {
                ExTRA.reportMessage(ExTRA.class, "getSanitizedProperties", "ignoring " + key + ": " + ExTRA.getStackTrace(t));
            }
        }
        return result.toString();
    }

    private static String sanitizeProperty(String s, ArrayList<String> redactionList) {
        if (s == null) {
            return null;
        }
        for (String pattern : redactionList) {
            if (pattern == null) continue;
            s = ExTRA.sanitizeProperty(s, pattern);
        }
        return s;
    }

    private static String sanitizeProperty(String s, String pattern) {
        StringBuilder result = new StringBuilder(s.length());
        int pos = 0;
        while (pos < s.length()) {
            int next = s.indexOf(pattern, pos);
            if (next < 0) {
                next = s.length();
            }
            result.append(s.substring(pos, next));
            pos = next;
            if (next >= s.length()) continue;
            if (!(pattern.length() <= 8 && (next != 0 && Character.isLetterOrDigit(s.charAt(next)) || next + pattern.length() < s.length() && Character.isLetterOrDigit(s.charAt(next + pattern.length()))))) {
                result.append("@@@@@");
                pos += pattern.length();
                continue;
            }
            result.append(s.charAt(next));
            ++pos;
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkHistory(ExTRA r) {
        Set<ExTRA> set = history;
        synchronized (set) {
            if (history.contains(r)) {
                return false;
            }
            history.add(r);
            return true;
        }
    }

    private static boolean checkHeirarchy(Throwable t) {
        int causedBy;
        String trace;
        Throwable chained = t.getCause();
        if (chained != null && chained != t && ExTRA.checkHeirarchy(chained)) {
            return true;
        }
        try {
            StringWriter str = new StringWriter();
            PrintWriter prt = new PrintWriter(str);
            t.printStackTrace(prt);
            prt.close();
            trace = str.toString();
        }
        catch (Exception ex) {
            return false;
        }
        int linePos = trace.indexOf(10);
        if (linePos < 0) {
            return true;
        }
        if (trace.indexOf(" at ", linePos) < 0 && trace.indexOf("\tat ", linePos) < 0) {
            return true;
        }
        int cutOff = trace.indexOf(EVENT_LOOP);
        if (cutOff < 0) {
            cutOff = trace.length() + 1;
        }
        if ((causedBy = trace.indexOf("\nCaused by:")) > 0 && causedBy < cutOff) {
            cutOff = causedBy;
        }
        for (String heir : heirarchies) {
            int pos = ExTRA.findPackage(trace, heir);
            if (pos < 0 || pos >= cutOff) continue;
            return true;
        }
        return false;
    }

    private static int findPackage(String trace, String heir) {
        int pos = trace.indexOf(heir);
        block0: while (pos >= 0) {
            for (String ign : toIgnore) {
                if (!trace.substring(pos).startsWith(ign)) continue;
                pos = trace.indexOf(heir, pos + ign.length());
                continue block0;
            }
            return pos;
        }
        return -1;
    }

    static String getStackTrace(Throwable t) {
        StringWriter writer = null;
        PrintWriter printer = null;
        try {
            writer = new StringWriter(2048);
            printer = new PrintWriter(writer);
            String err = ExTRA.getStackTrace(t, printer);
            if (err != null) {
                try {
                    printer.flush();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    writer.flush();
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                return err;
            }
            printer.flush();
            return writer.toString();
        }
        catch (OutOfMemoryError oome) {
            if (t instanceof OutOfMemoryError) {
                return "Out-of-memory";
            }
            return "Out-of-memory: processing " + t;
        }
        catch (Throwable t2) {
            return "Exception (" + t2 + ") encountered while processing: " + t;
        }
    }

    private static String getStackTrace(Throwable t, PrintWriter print) {
        try {
            print.print("Exception Trace - ");
            try {
                t.printStackTrace(print);
            }
            catch (Throwable t2) {
                print.println("Exception (" + t2 + ") encountered while tracing " + t);
            }
            for (Throwable wrapped = t.getCause(); wrapped != null; wrapped = wrapped.getCause()) {
                print.print("Target Exception Trace - ");
                try {
                    wrapped.printStackTrace(print);
                    continue;
                }
                catch (Throwable t2) {
                    print.println("Exception (" + t2 + ") encountered tracing wrapped exception " + wrapped);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            if (t instanceof OutOfMemoryError) {
                return "Out-of-memory(PrintWriter)";
            }
            return "Out-of-memory: printing " + t;
        }
        catch (Throwable t2) {
            return "Exception (" + t2 + ") encountered while printing: " + t;
        }
        return null;
    }

    private static String generateClientID() {
        UUID uuid = UUID.randomUUID();
        StringBuilder s = new StringBuilder(32);
        s.append(Long.toHexString(uuid.getMostSignificantBits()));
        while (s.length() < 16) {
            s.insert(0, '0');
        }
        s.append(Long.toHexString(uuid.getLeastSignificantBits()));
        while (s.length() < 32) {
            s.insert(16, '0');
        }
        return s.toString();
    }

    private static String prepareAttribution(Object source, String method) {
        if (source == null && (method == null || method.length() == 0)) {
            return null;
        }
        StringBuilder attribution = new StringBuilder();
        if (source != null) {
            if (source instanceof String) {
                attribution.append((String)source);
            } else if (source instanceof Class) {
                attribution.append(ExTRA.getClassName((Class)source));
            } else {
                attribution.append(ExTRA.getClassName(source.getClass()));
            }
        }
        if (method != null && method.length() > 0) {
            if (attribution.length() > 0) {
                attribution.append(".");
            }
            attribution.append(method);
        }
        if (attribution.length() == 0) {
            return null;
        }
        return attribution.toString();
    }

    private static String getClassName(Class<?> cls) {
        String name = cls.getName();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            return name.substring(pos + 1);
        }
        return name;
    }

    private static String getUID() {
        Properties props = ExTRA.loadProps();
        return props.getProperty(prefix + ".uid");
    }

    private static void setUID(String uid) {
        Properties props = ExTRA.loadProps();
        String key = prefix + ".uid";
        if (uid == null || uid.equals("")) {
            props.remove(key);
        } else {
            props.put(key, uid);
        }
        ExTRA.storeProps(props);
    }

    private static Properties loadProps() {
        Properties props = new Properties();
        if (propFile != null) {
            try {
                if (propFile.exists()) {
                    FileInputStream propStream = new FileInputStream(propFile);
                    props.load(propStream);
                    propStream.close();
                    deferSave = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProps(Properties props) {
        if (deferSave) {
            ExTRA.cacheExTRAProperties(props);
        } else if (propFile != null) {
            File dir = propFile.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            FileOutputStream str = null;
            try {
                str = new FileOutputStream(propFile);
                ExTRA.storeEncachedExTRAProperties(props, str);
            }
            catch (Exception ex) {
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
    }

    private static boolean isCacheDirty() {
        return encachedProps != null;
    }

    private static void storeEncachedExTRAProperties(Properties props, FileOutputStream str) throws IOException {
        ExTRA.cacheExTRAProperties(props);
        ExTRA.getPropertyCache().store(str, EXTRA_PREFERENCES_HEADER);
        encachedProps = null;
    }

    private static void cacheExTRAProperties(Properties props) {
        Iterator<Map.Entry<Object, Object>> iterator = props.entrySet().iterator();
        Properties propertyCache = ExTRA.getPropertyCache();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (propertyCache.contains(entry.getKey())) {
                propertyCache.remove(entry.getKey());
            }
            propertyCache.put(entry.getKey(), entry.getValue());
        }
    }

    private static Properties getPropertyCache() {
        if (encachedProps == null) {
            encachedProps = new Properties();
        }
        return encachedProps;
    }

    public static void flushExTRAProperties() {
        deferSave = false;
        File dir = new File(ExTRA.getPropertyFilePath());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        ExTRA.setPropertySaveFile(new File(dir, ExTRA.getPropertyFileName()));
        if (ExTRA.isCacheDirty()) {
            ExTRA.storeProps(new Properties());
        }
    }

    public static String getMessageHtml() {
        return messageHtml;
    }

    public static URL getMessageUrl() {
        if (messageURL != null) {
            return messageURL;
        }
        if (messageRsrc != null) {
            URL rsrcUrl = ExTRA.class.getResource(messageRsrc);
            return rsrcUrl;
        }
        return null;
    }

    public static URL getTarget() {
        return target;
    }

    static void addSent(String serial) {
        sentList = sentList == null ? serial : sentList + ", " + serial;
    }

    static void conditionalExit() {
        if (exiting) {
            System.exit(exitStatus);
        }
    }

    static void reportMessage(Object source, String method, String message) {
        String attrib;
        Method handler = msgHandler;
        if (handler != null) {
            try {
                handler.invoke(null, source, method, message);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if ((attrib = ExTRA.prepareAttribution(source, method)) == null) {
            System.err.println(message);
        } else {
            System.err.println(attrib + ": " + message);
        }
    }

    static void reportError(Object source, String method, String message) {
        String attrib;
        Method handler = errHandler;
        if (handler != null) {
            try {
                handler.invoke(null, source, method, message);
                return;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if ((attrib = ExTRA.prepareAttribution(source, method)) == null) {
            System.err.println(message);
        } else {
            System.err.println(attrib + ": " + message);
        }
    }

    static void reportException(Object source, String method, Throwable t) {
        ExTRA.reportError(source, method, ExTRA.getStackTrace(t));
    }

    static void reportException(Object source, String method, Throwable t, String message) {
        if (message != null && message.length() > 0) {
            ExTRA.reportError(source, method, message + "\n" + ExTRA.getStackTrace(t));
        } else {
            ExTRA.reportError(source, method, ExTRA.getStackTrace(t));
        }
    }

    private ExTRA(Throwable t) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss Z");
        this.clock = System.currentTimeMillis();
        this.throwable = t;
        this.elements = new TreeMap<String, Elem>();
        for (Map.Entry<String, String> entry : staticFields.entrySet()) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.addElement(k, v);
        }
        this.computeSignature();
        StringBuilder exInfo = new StringBuilder();
        for (Throwable t2 = this.throwable; t2 != null; t2 = t2.getCause()) {
            if (exInfo.length() > 0) {
                exInfo.append("\n");
            }
            exInfo.append(t2.getClass().getName());
        }
        this.addElement("exception", exInfo.toString());
        this.storeMemoryData();
        this.storeThreadData();
        this.storeSystemData();
        this.storeDisplayData();
        this.storeDiskData();
        this.addElement("properties", ExTRA.getSanitizedProperties());
        this.addElement("previousExtras", sentList);
        this.addElement("thread", Thread.currentThread().getName());
        this.addElement("date", fmt.format(new Date()));
        String stackTrace = this.generateTrace(this.throwable);
        this.addElement("trace", stackTrace);
        int wrapCount = 0;
        for (Throwable w = this.throwable.getCause(); w != null; w = w.getCause()) {
            ++wrapCount;
            if (w == null) continue;
            this.addElement("wrapped" + (wrapCount <= 1 ? "" : "-" + wrapCount), this.generateTrace(w));
        }
        int linePos = stackTrace.indexOf(10);
        if (linePos < 0 || stackTrace.indexOf(" at ", linePos) < 0 && stackTrace.indexOf("\tat ", linePos) < 0) {
            UUID uid = UUID.randomUUID();
            this.addElement("reporter", this.generateTrace(new Throwable("Unknown " + uid)));
        }
    }

    void addElement(String name, String value) {
        this.elements.put(name, new Elem(name, value));
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public long getReportTime() {
        return this.clock;
    }

    public String send(URL target) throws IOException {
        if (this.serial != null) {
            return this.serial;
        }
        OutputStream ostr = null;
        InputStream istr = null;
        HttpURLConnection connection = (HttpURLConnection)target.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        connection.connect();
        ostr = connection.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(ostr);
        BufferedWriter write = new BufferedWriter(out);
        write.write(this.toString());
        write.close();
        int response = connection.getResponseCode();
        if (response < 200 || response >= 300) {
            throw new IOException("Response " + connection.getResponseMessage());
        }
        istr = connection.getInputStream();
        InputStreamReader in = new InputStreamReader(istr);
        BufferedReader read = new BufferedReader(in);
        this.serial = read.readLine();
        connection.disconnect();
        return this.serial;
    }

    public boolean equals(Object o) {
        try {
            ExTRA x = (ExTRA)o;
            return this.signature.equals(x.signature);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public String toString() {
        StringBuilder report = new StringBuilder();
        report.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        report.append("<ExTRA version=\"1.1\">\n");
        for (Elem elem : this.elements.values()) {
            elem.append(report, INDENT);
        }
        report.append("</ExTRA>\n");
        return report.toString();
    }

    private void computeSignature() {
        Closeable str;
        PrintWriter prt = null;
        try {
            MessageDigest md = MessageDigest.getInstance("md5");
            str = new ByteArrayOutputStream();
            prt = new PrintWriter((OutputStream)str);
            this.throwable.printStackTrace(prt);
            prt.close();
            byte[] digest = md.digest(((ByteArrayOutputStream)str).toByteArray());
            this.signature = new BigInteger(digest);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.signature == null) {
            try {
                str = new StringWriter();
                prt = new PrintWriter((Writer)str);
                this.throwable.printStackTrace(prt);
                prt.close();
                this.signature = BigInteger.valueOf(((StringWriter)str).toString().hashCode());
            }
            catch (Exception ex) {
                this.signature = BigInteger.valueOf(0L);
            }
        }
    }

    private void merge(Map<String, String> adds) {
        for (String key : adds.keySet()) {
            String value;
            if (key == null || this.elements.containsKey(key) || (value = adds.get(key)) == null) continue;
            this.elements.put(key, new Elem(key, value));
        }
    }

    private void storeMemoryData() {
        List<MemoryPoolMXBean> pools;
        MemoryMXBean mmxBean = ManagementFactory.getMemoryMXBean();
        if (mmxBean != null) {
            this.addElement("memoryMX.heap", "" + mmxBean.getHeapMemoryUsage());
            this.addElement("memoryMX.non-heap", "" + mmxBean.getNonHeapMemoryUsage());
        }
        if ((pools = ManagementFactory.getMemoryPoolMXBeans()) != null && pools.size() > 0) {
            StringBuilder poolInfo = new StringBuilder();
            for (MemoryPoolMXBean mpmxBean : pools) {
                if (mpmxBean == null || !mpmxBean.isValid()) continue;
                if (poolInfo.length() > 0) {
                    poolInfo.append("\n");
                }
                poolInfo.append(mpmxBean.getName() + " " + (Object)((Object)mpmxBean.getType()) + ": " + mpmxBean.getUsage());
            }
            if (poolInfo.length() > 0) {
                this.addElement("memoryMX.pools", poolInfo.toString());
            }
        }
    }

    private void storeThreadData() {
        ThreadMXBean tBean = ManagementFactory.getThreadMXBean();
        if (tBean == null) {
            return;
        }
        StringBuilder tData = new StringBuilder();
        tData.append(tBean.getThreadCount() + " running, " + tBean.getPeakThreadCount() + " peak, " + tBean.getTotalStartedThreadCount() + " started\n");
        for (ThreadInfo ti : tBean.getThreadInfo(tBean.getAllThreadIds(), 1)) {
            String lockInfo = "";
            if (ti.getLockName() != null) {
                lockInfo = " [lock=" + ti.getLockName() + (ti.getLockOwnerId() < 0L ? "" : " vs=" + ti.getLockOwnerId() + " " + ti.getLockOwnerName()) + "]";
            }
            String frameInfo = "";
            StackTraceElement[] frame = ti.getStackTrace();
            if (frame != null && frame.length > 0 && frame[0] != null) {
                frameInfo = " -- at " + frame[0];
            }
            tData.append(ti.getThreadId() + " '" + ti.getThreadName() + "' state=" + (Object)((Object)ti.getThreadState()) + lockInfo + frameInfo + "\n");
        }
        this.addElement("threadInfo", tData.toString());
    }

    private void storeDisplayData() {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gDev = gEnv.getScreenDevices();
        if (gDev == null || gDev.length < 1) {
            return;
        }
        GraphicsDevice dftDev = gEnv.getDefaultScreenDevice();
        StringBuilder dispInfo = new StringBuilder();
        for (int ix = 0; ix < gDev.length; ++ix) {
            try {
                DisplayMode mode = gDev[ix].getDisplayMode();
                Rectangle bnds = gDev[ix].getDefaultConfiguration().getBounds();
                if (dispInfo.length() > 0) {
                    dispInfo.append("\n");
                }
                dispInfo.append(ix + ": " + gDev[ix].getIDstring() + " " + mode.getWidth() + "x" + mode.getHeight() + "x" + mode.getBitDepth() + " @ " + mode.getRefreshRate() + " pos=" + bnds.x + "," + bnds.y);
                if (gDev[ix] != dftDev) continue;
                dispInfo.append(" (Default)");
                continue;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        this.addElement("displays", dispInfo.toString().trim());
    }

    private void storeSystemData() {
        OperatingSystemMXBean osmxBean = ManagementFactory.getOperatingSystemMXBean();
        if (osmxBean != null) {
            try {
                Method m = osmxBean.getClass().getMethod("getSystemLoadAverage", new Class[0]);
                Object val = m.invoke((Object)osmxBean, new Object[0]);
                if (val != null) {
                    this.addElement("load", val.toString());
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            Class<?> osmxClass = null;
            try {
                osmxClass = Class.forName("com.sun.management.OperatingSystemMXBean");
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            if (osmxClass != null) {
                Method m;
                try {
                    m = osmxClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
                    long totalMem = (Long)m.invoke((Object)osmxBean, new Object[0]);
                    m = osmxClass.getMethod("getFreePhysicalMemorySize", new Class[0]);
                    long freeMem = (Long)m.invoke((Object)osmxBean, new Object[0]);
                    if (totalMem > 0L && freeMem > 0L) {
                        this.addElement("osMemory", totalMem - freeMem + "/" + totalMem + " free=" + freeMem);
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    m = osmxClass.getMethod("getTotalSwapSpaceSize", new Class[0]);
                    long totalSwap = (Long)m.invoke((Object)osmxBean, new Object[0]);
                    m = osmxClass.getMethod("getFreeSwapSpaceSize", new Class[0]);
                    long freeSwap = (Long)m.invoke((Object)osmxBean, new Object[0]);
                    if (totalSwap > 0L && freeSwap > 0L) {
                        this.addElement("swap", totalSwap - freeSwap + "/" + totalSwap + " free=" + freeSwap);
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    m = osmxClass.getMethod("getProcessCpuTime", new Class[0]);
                    long cpu = (Long)m.invoke((Object)osmxBean, new Object[0]);
                    if (cpu > 0L) {
                        this.addElement("processCPU", "" + cpu);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void storeDiskData() {
        File[] roots = File.listRoots();
        Class[] emptySig = new Class[]{};
        Method totalSpace = null;
        Method freeSpace = null;
        Method usableSpace = null;
        try {
            totalSpace = File.class.getMethod("getTotalSpace", emptySig);
            freeSpace = File.class.getMethod("getFreeSpace", emptySig);
            usableSpace = File.class.getMethod("getUsableSpace", emptySig);
            StringBuffer buf = new StringBuffer();
            for (File file : roots) {
                long total = (Long)totalSpace.invoke((Object)file, (Object[])emptySig);
                if (total == 0L) continue;
                long free = (Long)freeSpace.invoke((Object)file, (Object[])emptySig);
                long usable = (Long)usableSpace.invoke((Object)file, (Object[])emptySig);
                buf.append(file);
                buf.append(", Total:  " + total);
                buf.append(", Free:   " + free);
                buf.append(", Usable: " + usable);
                buf.append("\n");
            }
            this.addElement("disk", buf.toString());
        }
        catch (Exception e) {
            return;
        }
    }

    private String generateTrace(Throwable t) {
        StringWriter write = new StringWriter();
        PrintWriter print = new PrintWriter(write);
        t.printStackTrace(print);
        String trace = write.toString();
        StringTokenizer parser = new StringTokenizer(trace, "\n\r");
        StringBuilder buf = new StringBuilder();
        while (parser.hasMoreTokens()) {
            String line = parser.nextToken();
            if (line.equals("")) continue;
            buf.append(line);
            buf.append("\n");
        }
        return buf.toString();
    }

    static class DeliveryAgent
    extends Thread {
        private ExTRA extra;

        public DeliveryAgent(ExTRA report) {
            this.extra = report;
        }

        @Override
        public void run() {
            URL dest = target;
            if (dest != null) {
                try {
                    String serial = this.extra.send(dest);
                    ExTRA.reportMessage(this, null, "ExTRA report " + serial + " sent.");
                    ExTRA.addSent(serial);
                }
                catch (Throwable t) {
                    ExTRA.reportError(ExTRA.class, "send", "Unable to send ExTRA report to " + dest + "\n     " + t);
                }
            }
        }
    }

    static class Elem {
        protected String field;
        protected String value;

        public Elem(String name, String val) {
            this.field = name;
            this.value = val;
        }

        public void append(StringBuilder report, String indent) {
            this.appendTextField(report, indent, this.field, this.value);
        }

        protected void appendTextField(StringBuilder report, String indent, String field, String value) {
            if (value == null) {
                return;
            }
            if (value.trim().equals("")) {
                return;
            }
            this.appendMarker(report, indent, field);
            this.appendText(report, indent + ExTRA.INDENT, value);
            this.appendMarker(report, indent, "/" + field);
        }

        protected void appendMarker(StringBuilder report, String indent, String field) {
            report.append(indent);
            report.append("<");
            report.append(field);
            report.append(">\n");
        }

        protected void appendText(StringBuilder report, String indent, String value) {
            StringTokenizer parser = new StringTokenizer(value, "\n");
            while (parser.hasMoreTokens()) {
                String line = parser.nextToken().trim();
                report.append(indent);
                report.append(line);
                report.append("\n");
            }
        }
    }

    static class QueryAgent
    implements Runnable {
        private ExTRA extra;

        public QueryAgent(ExTRA report) {
            this.extra = report;
        }

        @Override
        public void run() {
            QueryExTRA query = new QueryExTRA(this.extra);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            query.setBounds((screen.width - 480) / 2, (screen.height - 320) / 2, 480, 320);
            query.activate();
        }
    }

    public static enum SendPolicy {
        UNDEFINED,
        NEVER,
        QUERY,
        ALWAYS;

    }
}

