/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.EnumElement;
import com.elluminate.framework.feature.hints.HintDef;
import com.elluminate.framework.feature.hints.HintDefsElement;
import com.elluminate.framework.feature.hints.ListElement;
import com.elluminate.framework.feature.hints.SetElement;
import com.elluminate.framework.feature.hints.TypedElement;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HintDefElement
extends TypedElement {
    public static final String ELEMENT_NAME = "HintDef";
    public static final String NAME_ATTR = "name";
    private HintDefsElement parent;
    private String name;

    public HintDefElement() {
        super(ELEMENT_NAME);
    }

    @Override
    public void validateChild(XmlElement child) throws SAXException {
        if (this.getType() != null) {
            throw new SAXException("The HintDef element may only have a single type definition.");
        }
        if (child instanceof SetElement) {
            return;
        }
        if (child instanceof ListElement) {
            return;
        }
        if (child instanceof EnumElement) {
            return;
        }
        throw new SAXException("Unsupported element '" + child.getName() + "' in the context of " + ELEMENT_NAME);
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        this.parent = (HintDefsElement)outer;
        this.parseType(attrs);
        if (this.name == null) {
            throw new SAXException("Missing name attribute on HintDef element.");
        }
    }

    @Override
    protected void leave() throws SAXException {
        if (this.getType() == null) {
            throw new SAXException("No type defined for HintDef " + this.name);
        }
        this.parent.addHintDef(new HintDef(this.name, this.getType()));
    }

    @Override
    public void reset() {
        this.setType(null);
        this.name = null;
        this.parent = null;
    }

    @Override
    protected void nonTypeAttr(String nm, String val) throws SAXException {
        if (!NAME_ATTR.equals(nm)) {
            throw new SAXException("Unknown attribute '" + nm + "' on " + ELEMENT_NAME + " element");
        }
        this.name = val;
    }
}

