/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature.hints;

import com.elluminate.framework.feature.hints.EnumDefElement;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.feature.hints.XmlElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class EnumValueElement
extends XmlElement {
    public static final String ELEMENT_NAME = "Value";
    public static final String NAME_ATTR = "name";
    public static final String ORDINAL_ATTR = "ordinal";
    private EnumDefElement parent;
    private String name;
    private Integer ordinal;

    public EnumValueElement() {
        super(ELEMENT_NAME, false);
    }

    @Override
    protected void enter(XmlElement outer, Attributes attrs) throws SAXException {
        HintEnum other;
        this.parent = (EnumDefElement)outer;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String nm = attrs.getLocalName(i);
            String val = attrs.getValue(i);
            if (nm.equals(NAME_ATTR)) {
                this.name = val;
                continue;
            }
            if (nm.equals(ORDINAL_ATTR)) {
                try {
                    this.ordinal = Integer.parseInt(val);
                    continue;
                }
                catch (NumberFormatException nfx) {
                    throw new SAXException("Invalid integer ordinal value " + val);
                }
            }
            throw new SAXException("Unknown attribute '" + nm + "' in " + ELEMENT_NAME);
        }
        if (this.name == null) {
            throw new SAXException("Missing name attribute on Value element.");
        }
        if (this.parent.getValue(this.name) != null) {
            throw new SAXException("Duplicate enum values '" + this.name + "'");
        }
        if (this.ordinal != null && (other = this.parent.getValue(this.ordinal)) != null) {
            throw new SAXException("Duplicate enum ordinal values " + this.name + "(" + this.ordinal + ") and " + other + "(" + this.ordinal + ")");
        }
    }

    @Override
    protected void leave() {
        HintEnum value = new HintEnum(this.name);
        if (this.ordinal != null) {
            value.setOrdinal(this.ordinal);
        }
        this.parent.addValue(value);
    }

    @Override
    public void reset() {
        this.name = null;
        this.ordinal = null;
        this.parent = null;
    }
}

