/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.AbstractFeature;
import com.elluminate.framework.feature.ListElementChangeEvent;
import com.elluminate.framework.feature.ListElementChangeListener;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListFeature<T>
extends AbstractFeature {
    private List<T> list = new ArrayList<T>();
    private ListenerRegistry<ListElementChangeListener> elementListeners = new ListenerRegistry(this.throwableProxy);

    public void addListElementListener(ListElementChangeListener listener) {
        this.elementListeners.add((Object)listener);
    }

    public void removeListElementListener(ListElementChangeListener listener) {
        this.elementListeners.remove((Object)listener);
    }

    private void fireListElementAdded(final T element, final int newIndex) {
        if (!this.isPublished()) {
            return;
        }
        FiringFunctor<ListElementChangeListener> ff = new FiringFunctor<ListElementChangeListener>(){
            private ListElementChangeEvent ev = null;

            public void fire(ListElementChangeListener l) {
                if (this.ev == null) {
                    this.ev = new ListElementChangeEvent(ListFeature.this, element, newIndex);
                }
                l.elementAdded(this.ev);
            }
        };
        this.elementListeners.fire((FiringFunctor)ff);
    }

    private void fireListElementRemoved(final T element, final int oldIndex) {
        if (!this.isPublished()) {
            return;
        }
        FiringFunctor<ListElementChangeListener> ff = new FiringFunctor<ListElementChangeListener>(){
            private ListElementChangeEvent ev = null;

            public void fire(ListElementChangeListener l) {
                if (this.ev == null) {
                    this.ev = new ListElementChangeEvent(ListFeature.this, element, oldIndex);
                }
                l.elementRemoved(this.ev);
            }
        };
        this.elementListeners.fire((FiringFunctor)ff);
    }

    private void fireListElementsCleared() {
        if (!this.isPublished()) {
            return;
        }
        FiringFunctor<ListElementChangeListener> ff = new FiringFunctor<ListElementChangeListener>(){
            private ListElementChangeEvent ev = null;

            public void fire(ListElementChangeListener l) {
                if (this.ev == null) {
                    this.ev = new ListElementChangeEvent(ListFeature.this);
                }
                l.allElementsCleared(this.ev);
            }
        };
        this.elementListeners.fire((FiringFunctor)ff);
    }

    private void fireListElementsBatchUpdated() {
        if (!this.isPublished()) {
            return;
        }
        FiringFunctor<ListElementChangeListener> ff = new FiringFunctor<ListElementChangeListener>(){
            private ListElementChangeEvent ev = null;

            public void fire(ListElementChangeListener l) {
                if (this.ev == null) {
                    this.ev = new ListElementChangeEvent(ListFeature.this);
                }
                l.elementsBatchUpdated(this.ev);
            }
        };
        this.elementListeners.fire((FiringFunctor)ff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assign(Collection<? extends T> elements) {
        Object object = this.lock;
        synchronized (object) {
            if (((Object)this.list).equals(elements)) {
                return false;
            }
            this.list.clear();
            this.list.addAll(elements);
        }
        this.fireListElementsBatchUpdated();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIfAbsent(T element) {
        boolean ret = false;
        int newIndex = -1;
        Object object = this.lock;
        synchronized (object) {
            if (!this.list.contains(element)) {
                ret = this.list.add(element);
                newIndex = this.list.size() - 1;
            }
        }
        if (ret) {
            this.fireListElementAdded(element, newIndex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T e) {
        boolean ret;
        int newIndex = -1;
        Object object = this.lock;
        synchronized (object) {
            ret = this.list.add(e);
            newIndex = this.list.size() - 1;
        }
        if (ret) {
            this.fireListElementAdded(e, newIndex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, T element) {
        Object object = this.lock;
        synchronized (object) {
            this.list.add(index, element);
        }
        this.fireListElementAdded(element, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            if (this.list.size() == 0) {
                return;
            }
            this.list.clear();
        }
        this.fireListElementsCleared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.list.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> c) {
        Object object = this.lock;
        synchronized (object) {
            return this.list.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int index) {
        Object object = this.lock;
        synchronized (object) {
            return this.list.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        int ret;
        Object object = this.lock;
        synchronized (object) {
            ret = this.list.indexOf(o);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean ret;
        Object object = this.lock;
        synchronized (object) {
            ret = this.list.isEmpty();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        int ret;
        Object object = this.lock;
        synchronized (object) {
            ret = this.list.lastIndexOf(o);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        boolean ret;
        int oldIndex = -1;
        Object object = this.lock;
        synchronized (object) {
            oldIndex = this.list.indexOf(o);
            ret = this.list.remove(o);
        }
        if (ret) {
            Object objAsT = o;
            this.fireListElementRemoved(objAsT, oldIndex);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int index) {
        T ret;
        Object object = this.lock;
        synchronized (object) {
            ret = this.list.remove(index);
        }
        if (ret != null) {
            this.fireListElementRemoved(ret, index);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.list.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.list.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        Object object = this.lock;
        synchronized (object) {
            if (o instanceof ListFeature) {
                return super.equals(o);
            }
            return ((Object)this.list).equals(o);
        }
    }
}

