/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.google.inject.Singleton;
import java.util.regex.Pattern;

@Singleton
public class FeaturePathSupport {
    static final String DELIMITER = "/";
    private static final String DOUBLE_DELIM = "//";
    private static final Pattern invalidPattern = Pattern.compile("[^a-zA-Z0-9_/]");
    private static final Pattern decomposePattern = Pattern.compile(Pattern.quote("/"));
    public static final String ROOT_PATH = "/";

    public boolean isPathValid(String featurePath) {
        try {
            this.validatePath(featurePath);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean isAbsolutePath(String featurePath) {
        this.validatePath(featurePath);
        return featurePath.startsWith("/");
    }

    public boolean isRootPath(String featurePath) {
        this.validatePath(featurePath);
        return "/".equals(featurePath);
    }

    public String composePath(String pre, String post) {
        this.validatePath(pre);
        if (post == null) {
            throw new IllegalArgumentException("Null path component");
        }
        if ("".equals(post)) {
            throw new IllegalArgumentException("Empty path component");
        }
        if (post.startsWith("/")) {
            throw new IllegalArgumentException("Cannot append absolute feature path");
        }
        String result = pre.endsWith("/") ? pre + post : pre + "/" + post;
        this.validatePath(result);
        return result;
    }

    public String composePath(String[] tokens) {
        if (tokens == null) {
            throw new IllegalArgumentException("Null token set");
        }
        if (tokens.length == 0) {
            throw new IllegalArgumentException("Empty token set");
        }
        StringBuilder result = new StringBuilder();
        for (String token : tokens) {
            if (token == null) {
                throw new IllegalArgumentException("Null token in feature path");
            }
            if ("".equals(token)) {
                throw new IllegalArgumentException("Empty token in feature path");
            }
            if (result.length() == 0 && "/".equals(token)) {
                result.append("/");
                continue;
            }
            if (token.indexOf("/") >= 0) {
                throw new IllegalArgumentException("Delimiter found in path token: " + token);
            }
            if (invalidPattern.matcher(token).find()) {
                throw new IllegalArgumentException("Illegal character found in path token: " + token);
            }
            if (result.length() > 0 && !result.toString().endsWith("/")) {
                result.append("/");
            }
            result.append(token);
        }
        return result.toString();
    }

    public String[] decomposePath(String featurePath) {
        String[] tokens;
        this.validatePath(featurePath);
        if ("/".equals(featurePath)) {
            tokens = new String[]{"/"};
        } else {
            tokens = decomposePattern.split(featurePath);
            if (featurePath.startsWith("/")) {
                tokens[0] = "/";
            }
        }
        return tokens;
    }

    void validatePath(String featurePath) {
        if (featurePath == null) {
            throw new IllegalArgumentException("Null feature path");
        }
        if ("".equals(featurePath)) {
            throw new IllegalArgumentException("Empty feature path");
        }
        if (featurePath.indexOf(DOUBLE_DELIM) >= 0) {
            throw new IllegalArgumentException("Doubled delimiter in feature path: " + featurePath);
        }
        if (invalidPattern.matcher(featurePath).find()) {
            throw new IllegalArgumentException("Illegal character in feature path: " + featurePath);
        }
        if (!featurePath.equals("/") && featurePath.endsWith("/")) {
            throw new IllegalArgumentException("Trailing delimiter in feature path: " + featurePath);
        }
    }
}

