/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.framework.feature;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureStatus;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.FeatureEvent;
import com.elluminate.util.I18nMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ActionFeatureEvent
extends FeatureEvent {
    private Object userData;
    private final Map<String, Object> parameterList;
    private final ActionFeatureStatus status = new ActionFeatureStatus();

    public ActionFeatureEvent(ActionFeature source, Map<String, Object> parameterList) {
        this(source, parameterList, null);
    }

    public ActionFeatureEvent(ActionFeature source, Map<String, Object> parameterList, Object userData) {
        super(source);
        this.parameterList = parameterList == null ? Collections.emptyMap() : Collections.unmodifiableMap(parameterList);
        this.userData = userData;
    }

    public ActionFeature getSourceActionFeature() {
        return (ActionFeature)super.getSourceFeature();
    }

    public boolean hasParameters() {
        return this.parameterList.size() > 0;
    }

    public int getParameterCount() {
        return this.parameterList.size();
    }

    public Set<String> getParameterKeys() {
        return Collections.unmodifiableSet(this.parameterList.keySet());
    }

    public boolean hasParameter(String key) {
        return this.parameterList.containsKey(key);
    }

    public int getParameterCardinality(String key) {
        Object val = this.parameterList.get(key);
        if (val == null) {
            return 0;
        }
        if (val instanceof Collection) {
            return ((Collection)val).size();
        }
        return 1;
    }

    public ActionParameterDescriptor getParameterDescriptor(String key) {
        return this.getSourceActionFeature().getParameterDescriptor(key);
    }

    public Class<?> getParameterImplementationType(String key) {
        ActionParameterDescriptor desc = this.getSourceActionFeature().getParameterDescriptor(key);
        if (desc == null) {
            throw new IllegalArgumentException("Unrecognized parameter key: " + key);
        }
        return desc.getImplementationType();
    }

    public Object getParameter(String key) {
        return this.parameterList.get(key);
    }

    public <T> T getParameterAs(Class<T> type, String key) {
        Object val = this.parameterList.get(key);
        if (val == null) {
            return null;
        }
        if (val instanceof Collection) {
            Collection col = (Collection)val;
            if (col.size() < 1) {
                return null;
            }
            if (col.size() > 1) {
                throw new IllegalStateException("Cannot retrieve a multi-value parameter as scalar: " + key);
            }
            val = col.iterator().next();
        }
        if (!type.isAssignableFrom(val.getClass())) {
            throw new IllegalArgumentException("Cannot coerce " + val.getClass().getName() + " value for " + key + " to " + type.getName());
        }
        Object result = val;
        return (T)result;
    }

    public <T> Collection<T> getParameterAsCollectionOf(Class<T> type, String key) {
        Object val = this.parameterList.get(key);
        if (val == null) {
            return Collections.emptyList();
        }
        if (type.isAssignableFrom(val.getClass())) {
            return Arrays.asList(val);
        }
        if (!(val instanceof Collection)) {
            throw new IllegalArgumentException("Cannot coerce " + val.getClass().getName() + " value for " + key + " to Collection<" + type.getName() + ">");
        }
        for (Object o : (Collection)val) {
            if (type.isAssignableFrom(o.getClass())) continue;
            throw new IllegalArgumentException("Cannot coerce " + o.getClass().getName() + " value for " + key + " to " + type.getName());
        }
        Collection result = (Collection)val;
        return result;
    }

    public Object getUserData() {
        return this.userData;
    }

    public <T> T getUserDataAs(Class<T> type) {
        if (this.userData == null) {
            return null;
        }
        if (!type.isAssignableFrom(this.userData.getClass())) {
            throw new IllegalArgumentException("Cannot coerce " + this.userData.getClass().getName() + " user data to " + type.getName());
        }
        Object result = this.userData;
        return (T)result;
    }

    public ActionFeatureStatus getStatus() {
        return this.status;
    }

    public boolean isComplete() {
        return this.status.isComplete();
    }

    public boolean isSuccessful() {
        return this.status.isSuccessful();
    }

    public void setComplete(boolean successful) {
        this.status.setComplete(successful);
    }

    public void addIssue(ActionFeatureStatus.IssueType type, I18nMessage message) {
        this.status.addIssue(type, message);
    }
}

