/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.components.SBadge;
import com.elluminate.classroom.swing.participant.ActivityDisplay;
import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.classroom.swing.participant.ParticipantListModel;
import com.elluminate.classroom.swing.participant.StringsProperties;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class ParticipantRenderer
extends ParticipantList.Renderer
implements Accessible {
    private I18n i18n = I18n.create((Object)this);
    private PictureIcon pictureIcon;
    private JLabel pictureLabel;
    private JLabel nameLabel;
    private JLabel optionsLabel;
    private JLabel deviceLabel;
    private JLabel statusLabel;
    private SBadge statusBadge = new SBadge();
    private ActivityDisplay activityPanel;
    private HashMap<Integer, ReactionAttributes> reactionMap = new HashMap();
    private Font participantFont;
    private Font moderatorFont;
    private Font statusFont;
    private JList list;
    private int index;
    private boolean selected;
    private CRParticipant participant;
    private boolean pressed;
    private Point hoverLocation;
    private boolean inMyRoom;
    private boolean inMainRoom;
    private boolean lastInRoom;
    private boolean topSeparator = false;
    private boolean showProfile = true;
    private GridBagConstraints gbcPictureLabel;
    private Map<Integer, Rectangle> activityBoundsMap = new HashMap<Integer, Rectangle>();
    private Map<Integer, Collection<JLabel>> activityLabelsMap = new HashMap<Integer, Collection<JLabel>>();

    public ParticipantRenderer() {
        this.setLayout(new GridBagLayout());
        this.reactionMap.put(1, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_SMILEYFACE), "React.smilingIcon"));
        this.reactionMap.put(2, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_LAUGHTER), "React.laughterIcon"));
        this.reactionMap.put(3, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_APPLAUSE), "React.applauseIcon"));
        this.reactionMap.put(4, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_CONFUSED), "React.confusionIcon"));
        this.reactionMap.put(5, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_APPROVE), "React.approvalIcon"));
        this.reactionMap.put(6, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_DISAPPROVE), "React.disapprovalIcon"));
        this.reactionMap.put(8, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_FASTER), "React.fasterIcon"));
        this.reactionMap.put(7, new ReactionAttributes(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_SLOWER), "React.slowerIcon"));
        this.participantFont = UIManager.getFont("List.font");
        this.moderatorFont = this.participantFont.deriveFont(1);
        this.statusFont = this.participantFont.deriveFont((float)this.participantFont.getSize() * 11.0f / 12.0f);
        this.gbcPictureLabel = new GridBagConstraints();
        this.gbcPictureLabel.gridy = 0;
        this.gbcPictureLabel.insets.top = 0;
        this.gbcPictureLabel.gridwidth = 1;
        this.gbcPictureLabel.weighty = 1.0;
        this.gbcPictureLabel.gridheight = 2;
        this.gbcPictureLabel.gridx = 0;
        this.gbcPictureLabel.weightx = 0.0;
        this.gbcPictureLabel.anchor = 18;
        this.gbcPictureLabel.insets.left = 2;
        this.pictureIcon = new PictureIcon(this);
        this.pictureLabel = new JLabel(this.pictureIcon);
        GridBagConstraints gbcNameLabel = new GridBagConstraints();
        gbcNameLabel.insets.top = 0;
        gbcNameLabel.gridwidth = 1;
        gbcNameLabel.weighty = 0.0;
        gbcNameLabel.gridheight = 1;
        gbcNameLabel.gridx = 1;
        gbcNameLabel.weightx = 1.0;
        gbcNameLabel.anchor = 18;
        gbcNameLabel.insets.left = 6;
        this.nameLabel = new JLabel();
        this.add((Component)this.nameLabel, gbcNameLabel);
        GridBagConstraints gbcOptionsLabel = new GridBagConstraints();
        gbcOptionsLabel.insets.top = 0;
        gbcOptionsLabel.gridwidth = 1;
        gbcOptionsLabel.weighty = 0.0;
        gbcOptionsLabel.gridheight = 1;
        gbcOptionsLabel.gridx = 2;
        gbcOptionsLabel.weightx = 0.0;
        gbcOptionsLabel.anchor = 12;
        gbcOptionsLabel.insets.left = 6;
        this.optionsLabel = new JLabel();
        this.optionsLabel.setIcon(UIManager.getIcon("SideBar.optionsIcon"));
        this.add((Component)this.optionsLabel, gbcOptionsLabel);
        GridBagConstraints gbcDeviceLabel = new GridBagConstraints();
        gbcDeviceLabel.insets.top = 0;
        gbcDeviceLabel.gridwidth = 1;
        gbcDeviceLabel.weighty = 0.0;
        gbcDeviceLabel.weightx = 0.0;
        gbcDeviceLabel.gridheight = 1;
        gbcDeviceLabel.anchor = 12;
        gbcDeviceLabel.gridx = 3;
        gbcDeviceLabel.insets.left = 0;
        this.deviceLabel = new JLabel();
        this.add((Component)this.deviceLabel, gbcDeviceLabel);
        GridBagConstraints gbcActivityPanel = new GridBagConstraints();
        gbcActivityPanel.gridwidth = 1;
        gbcActivityPanel.weighty = 0.0;
        gbcActivityPanel.gridheight = 1;
        gbcActivityPanel.weightx = 0.0;
        gbcActivityPanel.gridx = 4;
        gbcActivityPanel.weightx = 0.0;
        gbcActivityPanel.anchor = 12;
        gbcActivityPanel.insets.left = 0;
        gbcActivityPanel.insets.top = 2;
        gbcActivityPanel.insets.right = 2;
        this.activityPanel = new ActivityDisplay();
        this.activityPanel.setShowingPoll(true);
        this.add((Component)this.activityPanel, gbcActivityPanel);
        GridBagConstraints gbcStatusLabel = new GridBagConstraints();
        gbcStatusLabel.gridwidth = 1;
        gbcStatusLabel.weighty = 0.0;
        gbcStatusLabel.gridheight = 1;
        gbcStatusLabel.insets.top = 0;
        gbcStatusLabel.insets.right = 0;
        gbcStatusLabel.gridy = 1;
        gbcStatusLabel.insets.top = -1;
        gbcStatusLabel.gridwidth = 3;
        gbcStatusLabel.gridx = 1;
        gbcStatusLabel.weightx = 1.0;
        gbcStatusLabel.anchor = 18;
        gbcStatusLabel.insets.left = 6;
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(this.statusFont);
        this.add((Component)this.statusLabel, gbcStatusLabel);
    }

    protected void showProfile() {
        this.showProfile = true;
        this.add((Component)this.pictureLabel, this.gbcPictureLabel);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Rectangle b = this.optionsLabel.getBounds();
        b = SwingUtilities.convertRectangle(this, b, this.getParent());
        if (this.pressed || this.hoverLocation != null && b.contains(this.hoverLocation)) {
            this.optionsLabel.setIcon(UIManager.getIcon("SideBar.optionsPressedIcon"));
        } else {
            this.optionsLabel.setIcon(UIManager.getIcon("SideBar.optionsIcon"));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.selected && !this.inMainRoom) {
            Dimension s = this.getSize();
            Insets ins = this.getInsets();
            if (this.inMyRoom) {
                g.setColor(UIManager.getColor("Participant.currentRoomBackground"));
            } else {
                g.setColor(UIManager.getColor("Participant.roomBackground"));
            }
            int sideDepth = s.height;
            if (this.lastInRoom) {
                int bot = s.height - ins.bottom;
                g.drawLine(ins.left, bot, s.width - ins.right, bot);
                sideDepth = bot;
            }
            g.drawLine(ins.left, 0, ins.left, sideDepth);
            g.drawLine(s.width - ins.right, 0, s.width - ins.right, sideDepth);
        }
        this.activityBoundsMap.put(this.index, this.activityPanel.getBounds());
        this.activityLabelsMap.put(this.index, this.activityPanel.getActivityLabels());
        if (this.hoverLocation != null) {
            this.setHoveredLabel(this.hoverLocation);
        }
        if (this.topSeparator) {
            int y = 0;
            g.setColor(UIManager.getColor("Participant.separatorColor"));
            g.drawLine(5, y, this.getWidth() - 5, y);
        }
    }

    private void updateAccessibleInformation(boolean selected) {
        String participantName = this.participant.getDisplayName();
        String currentPosition = Integer.toString(this.index);
        String axName = this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_AX_NAME, new Object[]{participantName, this.statusLabel.getText()});
        String axDesc = this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_AX_DESC, new Object[]{currentPosition, participantName});
        AccessibleContext ax = this.getAccessibleContext();
        ax.setAccessibleName(axName);
        ax.setAccessibleDescription(axDesc);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleParticipantRenderer();
        }
        return this.accessibleContext;
    }

    public void drawTopSeparator(boolean value) {
        this.topSeparator = value;
    }

    public void setAsLastInRoom(boolean value) {
        this.lastInRoom = value;
    }

    @Override
    public void prepare(JList list, Object value, int index, boolean selected, boolean focused, boolean hovered, boolean pressed, Point hoverLocation, boolean hasOptions) {
        if (index == 0) {
            this.activityBoundsMap.clear();
            this.activityLabelsMap.clear();
        }
        this.list = list;
        this.index = index;
        this.selected = selected;
        this.participant = (CRParticipant)value;
        this.pressed = pressed;
        this.hoverLocation = hoverLocation;
        CRParticipant me = this.participant.getSession().getMe();
        CRRoom room = this.participant.getRoom();
        this.inMyRoom = me != null && room == me.getRoom();
        this.inMainRoom = room != null ? room.isMain() : false;
        this.setDeviceIcon();
        ComponentOrientation or = list.getComponentOrientation();
        this.setComponentOrientation(or);
        this.pictureLabel.setComponentOrientation(or);
        this.nameLabel.setComponentOrientation(or);
        this.statusLabel.setComponentOrientation(or);
        if (selected) {
            this.setBackground(list.getSelectionBackground());
            Color c = list.getSelectionForeground();
            this.nameLabel.setForeground(c);
            this.statusLabel.setForeground(c);
        } else {
            int indexInRoom = index;
            if (room != null && !room.isMain()) {
                ParticipantListModel m = (ParticipantListModel)list.getModel();
                indexInRoom = m.rowOf(this.participant) - m.rowOf(room) - 1;
            } else if (!this.participant.isChair()) {
                // empty if block
            }
            boolean alt = indexInRoom % 2 == 0;
            this.setBackground(alt ? UIManager.getColor("Participant.alternateBackground") : list.getBackground());
            this.nameLabel.setForeground(UIManager.getColor("Participant.nameForeground"));
            this.statusLabel.setForeground(UIManager.getColor("Participant.statusForeground"));
        }
        Image pic = null;
        int hand = 0;
        Object a2 = this.participant.getAnnotationValue("HandRaiseAnnotation");
        if (a2 instanceof Number) {
            hand = ((Number)a2).intValue();
        }
        if (this.showProfile) {
            Object a = this.participant.getAnnotationValue("ProfilePictureAnnotation");
            if (a instanceof Image) {
                pic = (Image)a;
            }
            this.pictureIcon.setPicture(pic);
            this.pictureIcon.setHandRaised(hand != 0);
        }
        this.nameLabel.setText(this.participant.getDisplayName());
        this.nameLabel.setFont(this.participant.isChair() ? this.moderatorFont : this.participantFont);
        this.optionsLabel.setVisible(hasOptions && (pressed || hovered));
        if (me != null) {
            this.activityPanel.setShowingAllPermissions(me.isChair() && hovered);
        }
        Integer reaction = (Integer)this.participant.getAnnotationValue("EmoticonAnnotation");
        Integer away = (Integer)this.participant.getAnnotationValue("AwayAnnotation");
        if (reaction != null && this.reactionMap.containsKey(reaction)) {
            ReactionAttributes r = this.reactionMap.get(reaction);
            this.statusLabel.setIcon(r.getIcon());
            this.statusLabel.setText(r.getDisplayName());
        } else if (away != null && away == 1) {
            this.statusLabel.setIcon(UIManager.getIcon("Participant.awayIcon"));
            this.statusLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_AWAY));
            if (!selected) {
                this.statusLabel.setForeground(UIManager.getColor("Participant.awayForeground"));
            }
        } else if (hand != 0) {
            this.statusBadge.setText(String.valueOf(hand));
            this.statusLabel.setIcon(this.statusBadge);
            this.statusLabel.setText(" ");
        } else if (this.participant.isChair()) {
            this.statusLabel.setIcon(null);
            if (this.participant.isMe()) {
                this.statusLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_MODERATOR) + " " + this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_ME));
            } else {
                this.statusLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_MODERATOR));
            }
        } else {
            this.statusLabel.setIcon(null);
            if (this.participant.isMe()) {
                this.statusLabel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_STATUS_ME));
            } else {
                this.statusLabel.setText("");
            }
        }
        boolean en = list.isEnabled();
        this.pictureLabel.setEnabled(en);
        this.nameLabel.setEnabled(en);
        this.optionsLabel.setEnabled(en);
        this.statusLabel.setEnabled(en);
        Border b = null;
        if (focused) {
            if (selected) {
                b = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (b == null) {
                b = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        this.setBorder(BorderFactory.createCompoundBorder(b, BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.activityPanel.setParticipant(this.participant);
        this.updateAccessibleInformation(selected);
    }

    @Override
    public Rectangle getOptionsBounds(int row) {
        Rectangle rb = this.list.getCellBounds(row, row);
        Rectangle b = this.optionsLabel.getBounds();
        b.translate(rb.x, rb.y);
        return b;
    }

    @Override
    Rectangle getDeviceBounds(int row) {
        Rectangle rb = this.list.getCellBounds(row, row);
        Rectangle b = this.deviceLabel.getBounds();
        b.translate(rb.x, rb.y);
        return b;
    }

    @Override
    public String getActivityToolTipText(int row, Point point) {
        String tooltip = null;
        if (this.list == null) {
            return tooltip;
        }
        Rectangle b = this.activityBoundsMap.get(row);
        if (b == null) {
            return tooltip;
        }
        Collection<JLabel> labels = this.activityLabelsMap.get(row);
        if (labels != null) {
            for (JLabel label : labels) {
                Rectangle b2 = label.getBounds();
                b2.translate(b.x, b.y);
                if (!b2.contains(point)) continue;
                return label.getToolTipText();
            }
        }
        return tooltip;
    }

    public void setHoveredLabel(Point point) {
        if (this.list == null) {
            return;
        }
        int row = ((ParticipantListModel)this.list.getModel()).rowOf(this.participant);
        Rectangle rb = this.list.getCellBounds(row, row);
        Rectangle b = this.activityBoundsMap.get(row);
        if (b == null) {
            return;
        }
        b.translate(rb.x, rb.y);
        Collection<JLabel> labels = this.activityLabelsMap.get(row);
        if (labels != null) {
            for (JLabel label : labels) {
                Rectangle b2 = label.getBounds();
                b2.translate(b.x, b.y);
                if (!b2.contains(point)) continue;
                this.activityPanel.setPermissionIcons(label);
            }
        }
    }

    @Override
    public Rectangle getExpandBounds(int row) {
        return null;
    }

    @Override
    String getPermissionClicked(int row, Point location) {
        if (location == null) {
            return null;
        }
        if (this.list == null) {
            return null;
        }
        int myRow = ((ParticipantListModel)this.list.getModel()).rowOf(this.participant);
        if (row != myRow) {
            return null;
        }
        Rectangle b = this.activityBoundsMap.get(row);
        if (b == null) {
            return null;
        }
        Collection<JLabel> labels = this.activityLabelsMap.get(row);
        if (labels != null) {
            for (JLabel label : labels) {
                Rectangle b2 = label.getBounds();
                b2.translate(b.x, b.y);
                if (!b2.contains(location)) continue;
                return this.activityPanel.getPermissionName(label);
            }
        }
        return null;
    }

    @Override
    public void clickPermission(String permission, int row) {
        this.activityPanel.togglePermissionValue(permission);
    }

    private void setDeviceIcon() {
        if (this.participant.getRoom() != null) {
            String typeID = this.participant.getDeviceType();
            if (typeID != null && typeID.length() > 0 && typeID.charAt(0) == 'M') {
                if (typeID.charAt(1) == 'i' || typeID.charAt(1) == 'a') {
                    this.deviceLabel.setIcon(UIManager.getIcon("SideBar.deviceIconMobile"));
                } else if (typeID.charAt(1) == 'I' || typeID.charAt(1) == 'A') {
                    this.deviceLabel.setIcon(UIManager.getIcon("SideBar.deviceIconTablet"));
                }
            } else {
                this.deviceLabel.setIcon(null);
            }
        }
    }

    private class AccessibleParticipantRenderer
    extends JComponent.AccessibleJComponent {
        private AccessibleParticipantRenderer() {
            super(ParticipantRenderer.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static class PictureIcon
    implements Icon {
        private static final int PICTURE_WIDTH = 25;
        private static final int PICTURE_HEIGHT = 25;
        private Component observer;
        private MediaTracker tracker;
        private int nextID = 0;
        private Image picture;
        private boolean handRaised;

        public PictureIcon(Component observer) {
            this.observer = observer;
            this.tracker = new MediaTracker(observer);
        }

        public void setPicture(Image picture) {
            this.picture = picture;
        }

        public void setHandRaised(boolean handRaised) {
            this.handRaised = handRaised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Icon scalePicture(Image picture) {
            int w = picture.getWidth(this.observer);
            int h = picture.getHeight(this.observer);
            if (w == 25 && h == 25) {
                return new ImageIcon(picture);
            }
            float xscale = 25.0f / (float)w;
            float yscale = 25.0f / (float)h;
            float scale = Math.max(xscale, yscale);
            BufferedImage bim = new BufferedImage(25, 25, 2);
            Graphics2D og = bim.createGraphics();
            if (og != null) {
                w = (int)((float)w * scale);
                h = (int)((float)h * scale);
                int x = (25 - w) / 2;
                int y = (25 - h) / 2;
                og.drawImage(picture, x, y, w, h, this.observer);
                og.dispose();
            }
            int id = this.nextID++;
            if (this.nextID == Integer.MAX_VALUE) {
                this.nextID = 0;
            }
            try {
                this.tracker.addImage(bim, id);
                this.tracker.waitForID(id);
            }
            catch (InterruptedException ex) {
            }
            finally {
                this.tracker.removeImage(bim, id);
            }
            return new ImageIcon(bim);
        }

        @Override
        public int getIconWidth() {
            return 25;
        }

        @Override
        public int getIconHeight() {
            return 25;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon ic;
            Icon pic = this.picture != null ? this.scalePicture(this.picture) : UIManager.getIcon("Participant.defaultParticipantIcon");
            pic.paintIcon(c, g, x, y);
            if (this.handRaised && (ic = UIManager.getIcon("Participant.handRaisedIcon")) != null) {
                ic.paintIcon(c, g, x += 25 - ic.getIconWidth(), y += 25 - ic.getIconHeight());
            }
        }
    }

    private static class ReactionAttributes {
        private String displayName;
        private String iconName;
        private Icon icon;

        public ReactionAttributes(String displayName, String iconName) {
            this.displayName = displayName;
            this.iconName = iconName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public synchronized Icon getIcon() {
            if (this.icon == null) {
                this.icon = UIManager.getIcon(this.iconName);
            }
            return this.icon;
        }
    }
}

