/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.SwingDebug;
import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.util.I18n;
import com.elluminate.util.log.LogSupport;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

class ActivityDisplay
extends JComponent
implements Accessible {
    private final Object adLock = new Object();
    private static final int ICON_SIZE = 14;
    private static final int LEFT_GAP = 6;
    private static final int ICON_GAP = 3;
    private static final PermissionComparator permissionComparator = new PermissionComparator();
    private Map<String, Field> activityNameMap;
    private Map<String, Field> lagNameMap;
    private Map<String, Field> permissionNameMap;
    private Map<Field, Map<Object, String>> activityToValuesMap;
    private Map<Field, Map<Object, String>> lagToValuesMap;
    private Map<Field, Map<Boolean, String>> permissionToValuesMap;
    private Map<Field, Map<Boolean, String>> permissionToRolloverMap;
    private boolean sortedLogically;
    private boolean showingAllPermissions;
    private CRParticipant participant;
    private List<Field> fields = new ArrayList<Field>();
    private Map<Field, Object> activities = new EnumMap<Field, Object>(Field.class);
    private Map<Field, Object> lags = new EnumMap<Field, Object>(Field.class);
    private Map<Field, Boolean> permissions = new EnumMap<Field, Boolean>(Field.class);
    private Map<Field, Icon> icons = new LinkedHashMap<Field, Icon>();
    private I18n i18n = I18n.create((Object)this);
    private ActivityPanel panel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivityDisplay() {
        Object object = this.adLock;
        synchronized (object) {
            this.activityNameMap = new HashMap<String, Field>();
            this.activityNameMap.put("AudioActivityAnnotation", Field.AUDIO);
            this.activityNameMap.put("VideoActivityAnnotation", Field.VIDEO);
            this.activityNameMap.put("ChatActivityAnnotation", Field.CHAT);
            this.activityNameMap.put("WhiteboardActivityAnnotation", Field.WHITEBOARD);
            this.activityNameMap.put("AppShareActivityAnnotation", Field.SCREEN_SHARING);
            this.activityNameMap.put("WebTourActivityAnnotation", Field.WEB_TOUR);
            this.activityNameMap.put("CaptionActivityAnnotation", Field.CAPTION);
            this.activityNameMap.put("PollingAnnotation", Field.POLL);
            this.activityNameMap.put("AudioSetupAnnotation", Field.SETUP);
            this.lagNameMap = new HashMap<String, Field>();
            this.lagNameMap.put("AudioLagAnnotation", Field.AUDIO);
            this.lagNameMap.put("VideoLagAnnotation", Field.VIDEO);
            this.lagNameMap.put("ChatLagAnnotation", Field.CHAT);
            this.lagNameMap.put("WhiteboardLagAnnotation", Field.WHITEBOARD);
            this.lagNameMap.put("AppShareLagAnnotation", Field.SCREEN_SHARING);
            this.lagNameMap.put("WebTourLagAnnotation", Field.WEB_TOUR);
            this.lagNameMap.put("CaptionLagAnnotation", Field.CAPTION);
            this.permissionNameMap = new HashMap<String, Field>();
            this.permissionNameMap.put("AudioPermission", Field.AUDIO);
            this.permissionNameMap.put("VideoPermission", Field.VIDEO);
            this.permissionNameMap.put("ChatPermission", Field.CHAT);
            this.permissionNameMap.put("WhiteBoardPermission", Field.WHITEBOARD);
            this.permissionNameMap.put("AppSharePermission", Field.SCREEN_SHARING);
            this.permissionNameMap.put("WebTourPermission", Field.WEB_TOUR);
            this.permissionNameMap.put("CaptionPermission", Field.CAPTION);
            this.activityToValuesMap = new EnumMap<Field, Map<Object, String>>(Field.class);
            HashMap<Integer, String> m = new HashMap<Integer, String>();
            m.put(1, "Audio.activityIcon");
            this.activityToValuesMap.put(Field.AUDIO, m);
            m = new HashMap();
            m.put(1, "Video.activityIcon");
            this.activityToValuesMap.put(Field.VIDEO, m);
            m = new HashMap();
            m.put(1, "Chat.activityIcon");
            this.activityToValuesMap.put(Field.CHAT, m);
            m = new HashMap();
            m.put(1, "Whiteboard.activityIcon");
            this.activityToValuesMap.put(Field.WHITEBOARD, m);
            m = new HashMap();
            m.put(1, "ScreenSharing.activityIcon");
            this.activityToValuesMap.put(Field.SCREEN_SHARING, m);
            m = new HashMap();
            m.put(1, "WebTour.activityIcon");
            this.activityToValuesMap.put(Field.WEB_TOUR, m);
            m = new HashMap();
            m.put(1, "Caption.activityIcon");
            this.activityToValuesMap.put(Field.CAPTION, m);
            m = new HashMap();
            m.put(1, "Setup.activityIcon");
            this.activityToValuesMap.put(Field.SETUP, m);
            this.setShowingPoll(true);
            this.lagToValuesMap = new EnumMap<Field, Map<Object, String>>(Field.class);
            m = new HashMap();
            m.put(1, "Audio.lowLagIcon");
            m.put(2, "Audio.highLagIcon");
            this.lagToValuesMap.put(Field.AUDIO, m);
            m = new HashMap();
            m.put(1, "Video.lowLagIcon");
            m.put(2, "Video.highLagIcon");
            this.lagToValuesMap.put(Field.VIDEO, m);
            m = new HashMap();
            m.put(1, "Chat.lowLagIcon");
            m.put(2, "Chat.highLagIcon");
            this.lagToValuesMap.put(Field.CHAT, m);
            m = new HashMap();
            m.put(1, "Whiteboard.lowLagIcon");
            m.put(2, "Whiteboard.highLagIcon");
            this.lagToValuesMap.put(Field.WHITEBOARD, m);
            m = new HashMap();
            m.put(1, "ScreenSharing.lowLagIcon");
            m.put(2, "ScreenSharing.highLagIcon");
            this.lagToValuesMap.put(Field.SCREEN_SHARING, m);
            m = new HashMap();
            m.put(1, "WebTour.lowLagIcon");
            m.put(2, "WebTour.highLagIcon");
            this.lagToValuesMap.put(Field.WEB_TOUR, m);
            m = new HashMap();
            m.put(1, "Caption.lowLagIcon");
            m.put(2, "Caption.highLagIcon");
            this.lagToValuesMap.put(Field.CAPTION, m);
            m = new HashMap();
            m.put(1, "Telephony.lowLagIcon");
            m.put(2, "Telephony.highLagIcon");
            this.permissionToValuesMap = new EnumMap<Field, Map<Boolean, String>>(Field.class);
            HashMap<Boolean, String> bm = new HashMap<Boolean, String>();
            this.putStandardAudioMapping(bm);
            this.permissionToValuesMap.put(Field.AUDIO, bm);
            bm = new HashMap();
            bm.put(true, "Video.permissionGrantedIcon");
            bm.put(false, "Video.permissionRevokedIcon");
            this.permissionToValuesMap.put(Field.VIDEO, bm);
            bm = new HashMap();
            bm.put(true, "Chat.permissionGrantedIcon");
            bm.put(false, "Chat.permissionRevokedIcon");
            this.permissionToValuesMap.put(Field.CHAT, bm);
            bm = new HashMap();
            bm.put(true, "Whiteboard.permissionGrantedIcon");
            bm.put(false, "Whiteboard.permissionRevokedIcon");
            this.permissionToValuesMap.put(Field.WHITEBOARD, bm);
            bm = new HashMap();
            bm.put(true, "ScreenSharing.permissionGrantedIcon");
            bm.put(false, "ScreenSharing.permissionRevokedIcon");
            this.permissionToValuesMap.put(Field.SCREEN_SHARING, bm);
            bm = new HashMap();
            bm.put(true, "WebTour.permissionGrantedIcon");
            bm.put(false, "WebTour.permissionRevokedIcon");
            this.permissionToValuesMap.put(Field.WEB_TOUR, bm);
            bm = new HashMap();
            bm.put(true, "Caption.permissionGrantedIcon");
            bm.put(false, "Caption.permissionRevokedIcon");
            this.permissionToValuesMap.put(Field.CAPTION, bm);
            this.permissionToRolloverMap = new EnumMap<Field, Map<Boolean, String>>(Field.class);
            bm = new HashMap();
            bm.put(true, "Audio.permissionGrantedRolloverIcon");
            bm.put(false, "Audio.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.AUDIO, bm);
            bm = new HashMap();
            bm.put(true, "Video.permissionGrantedRolloverIcon");
            bm.put(false, "Video.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.VIDEO, bm);
            bm = new HashMap();
            bm.put(true, "Chat.permissionGrantedRolloverIcon");
            bm.put(false, "Chat.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.CHAT, bm);
            bm = new HashMap();
            bm.put(true, "Whiteboard.permissionGrantedRolloverIcon");
            bm.put(false, "Whiteboard.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.WHITEBOARD, bm);
            bm = new HashMap();
            bm.put(true, "ScreenSharing.permissionGrantedRolloverIcon");
            bm.put(false, "ScreenSharing.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.SCREEN_SHARING, bm);
            bm = new HashMap();
            bm.put(true, "WebTour.permissionGrantedRolloverIcon");
            bm.put(false, "WebTour.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.WEB_TOUR, bm);
            bm = new HashMap();
            bm.put(true, "Caption.permissionGrantedRolloverIcon");
            bm.put(false, "Caption.permissionRevokedRolloverIcon");
            this.permissionToRolloverMap.put(Field.CAPTION, bm);
        }
        this.panel = new ActivityPanel();
        this.add(this.panel);
    }

    private void putStandardAudioMapping(Map<Boolean, String> bm) {
        bm.put(true, "Audio.permissionGrantedIcon");
        bm.put(false, "Audio.permissionRevokedIcon");
    }

    private void putStandardAudioMappingRollover(Map<Boolean, String> bmr) {
        bmr.put(true, "Audio.permissionGrantedRolloverIcon");
        bmr.put(false, "Audio.permissionRevokedRolloverIcon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAudioPermissionsIcons() {
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null) {
            return;
        }
        Object object = this.adLock;
        synchronized (object) {
            HashMap<Boolean, String> bm = new HashMap<Boolean, String>();
            HashMap<Boolean, String> bmr = new HashMap<Boolean, String>();
            if (this.isTeleconferenced(localParticipant)) {
                if (this.isBridge(localParticipant)) {
                    bm.put(true, "Audio.permissionGrantedBridgeIcon");
                    bm.put(false, "Audio.permissionRevokedBridgeIcon");
                } else if (this.isTeleconferenceMuted()) {
                    bm.put(true, "Audio.permissionRevokedPhoneModeIcon");
                    bm.put(false, "Audio.permissionRevokedPhoneModeIcon");
                    bmr.put(false, "Audio.permissionRevokedPhoneModeIcon");
                    bmr.put(false, "Audio.permissionRevokedPhoneModeIcon");
                } else {
                    bm.put(true, "Audio.permissionGrantedPhoneModeIcon");
                    bm.put(false, "Audio.permissionGrantedPhoneModeIcon");
                    bmr.put(true, "Audio.permissionGrantedPhoneModeIcon");
                    bmr.put(false, "Audio.permissionGrantedPhoneModeIcon");
                }
            } else {
                this.putStandardAudioMapping(bm);
                this.putStandardAudioMappingRollover(bmr);
            }
            this.permissionToValuesMap.put(Field.AUDIO, bm);
            this.permissionToRolloverMap.put(Field.AUDIO, bmr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowingPoll(boolean showingPoll) {
        Object object = this.adLock;
        synchronized (object) {
            if (showingPoll) {
                if (!this.activityToValuesMap.containsKey((Object)Field.POLL)) {
                    HashMap<Character, String> m = new HashMap<Character, String>();
                    m.put(Character.valueOf('n'), "Polling.noIcon");
                    m.put(Character.valueOf('y'), "Polling.yesIcon");
                    m.put(Character.valueOf('a'), "Polling.aIcon");
                    m.put(Character.valueOf('b'), "Polling.bIcon");
                    m.put(Character.valueOf('c'), "Polling.cIcon");
                    m.put(Character.valueOf('d'), "Polling.dIcon");
                    m.put(Character.valueOf('e'), "Polling.eIcon");
                    this.activityToValuesMap.put(Field.POLL, m);
                }
            } else {
                this.activityToValuesMap.remove((Object)Field.POLL);
            }
        }
    }

    public void setSortedLogically(boolean sortedLogically) {
        this.sortedLogically = sortedLogically;
    }

    public void setShowingAllPermissions(boolean showingAllPermissions) {
        this.showingAllPermissions = showingAllPermissions;
        this.setParticipant(this.participant);
    }

    private boolean isTeleconferenced(CRParticipant participant) {
        boolean teleconferenced = false;
        Object telActObj = participant.getAnnotationValue("TelephonyActivityAnnotation");
        if (telActObj != null) {
            int telephonyActivityVal = (Integer)telActObj;
            teleconferenced = telephonyActivityVal != 0;
        }
        return teleconferenced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParticipant(CRParticipant participant) {
        this.participant = participant;
        Object object = this.adLock;
        synchronized (object) {
            this.fields.clear();
            this.activities.clear();
            this.lags.clear();
            this.permissions.clear();
            this.icons.clear();
            if (participant != null) {
                this.updateAudioPermissionsIcons();
                this.collectParticipantState(participant);
                for (Field f : this.fields) {
                    this.updateIcon(f);
                }
            }
        }
        this.setSortedLogically(this.showingAllPermissions);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoom(CRRoom room) {
        Object object = this.adLock;
        synchronized (object) {
            this.fields.clear();
            this.activities.clear();
            this.lags.clear();
            this.permissions.clear();
            this.icons.clear();
            if (room != null) {
                Iterator itr = room.getParticipantIterator();
                while (itr.hasNext()) {
                    CRParticipant p = (CRParticipant)itr.next();
                    this.collectParticipantState(p);
                }
                for (Field f : this.fields) {
                    this.updateIcon(f);
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleActivityNameMap(CRAnnotation annotation) {
        Object object = this.adLock;
        synchronized (object) {
            String name = annotation.getName();
            if (this.activityNameMap.containsKey(name)) {
                Field f = this.activityNameMap.get(name);
                if (this.activityToValuesMap.containsKey((Object)f)) {
                    Object value = annotation.getValue();
                    if (this.activityToValuesMap.get((Object)f).containsKey(value)) {
                        this.activities.put(f, value);
                        if (!this.fields.contains((Object)f)) {
                            this.fields.add(f);
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleLagNameMap(CRAnnotation annotation) {
        Object object = this.adLock;
        synchronized (object) {
            String name = annotation.getName();
            if (this.lagNameMap.containsKey(name)) {
                Field f = this.lagNameMap.get(name);
                if (this.lagToValuesMap.containsKey((Object)f)) {
                    Object value = annotation.getValue();
                    if (this.lagToValuesMap.get((Object)f).containsKey(value)) {
                        this.lags.put(f, value);
                        if (!this.fields.contains((Object)f)) {
                            this.fields.add(f);
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectParticipantState(CRParticipant participant) {
        Object object = this.adLock;
        synchronized (object) {
            Iterator itr = participant.getAnnotationIterator();
            while (itr.hasNext()) {
                CRAnnotation annotation = (CRAnnotation)itr.next();
                if (this.handleActivityNameMap(annotation)) continue;
                this.handleLagNameMap(annotation);
            }
            boolean inTelephonyMode = this.isTeleconferenced(participant);
            short participantID = participant.getID();
            CRSession sess = participant.getSession();
            List names = sess.getPermissionNames(CRPermissionScope.PARTICIPANT);
            if (this.sortedLogically) {
                Collections.sort(names, permissionComparator);
            }
            for (String name : names) {
                this.determinePermissionExceptions(participant, participantID, sess, name, inTelephonyMode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determinePermissionExceptions(CRParticipant participant, short participantID, CRSession sess, String name, boolean inTelMode) {
        Object object = this.adLock;
        synchronized (object) {
            CRPermission perm;
            Field f;
            if (this.permissionNameMap.containsKey(name) && this.permissionToValuesMap.containsKey((Object)(f = this.permissionNameMap.get(name))) && (perm = sess.getPermission(name, participantID)) != null) {
                boolean relevantToTelephony;
                boolean value = perm.getValue();
                boolean globalPermissionSupported = perm.globalPermissionSupported();
                boolean bl = relevantToTelephony = inTelMode && name.equals("AudioPermission");
                if (this.showingAllPermissions && !perm.getName().equals("CaptionPermission") || this.permissionToValuesMap.get((Object)f).containsKey(value) && (value != perm.getDefault() || relevantToTelephony)) {
                    if (this.showingAllPermissions && !perm.getName().equals("CaptionPermission") || !participant.isChair() || !value || !globalPermissionSupported || relevantToTelephony) {
                        this.permissions.put(f, value);
                        if (!this.fields.contains((Object)f)) {
                            this.fields.add(f);
                        }
                    } else {
                        this.permissions.remove((Object)f);
                        if (!this.activities.containsKey((Object)f) && !this.lags.containsKey((Object)f)) {
                            this.fields.remove((Object)f);
                        }
                    }
                }
            }
        }
    }

    private boolean isBridge(CRParticipant part) {
        return part.getName().startsWith("Teleconference#");
    }

    private boolean isTeleconferenceMuted() {
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null || localParticipant.getSession() == null) {
            return false;
        }
        CRSession sess = localParticipant.getSession();
        boolean foundTeleconf = false;
        boolean audioPermitted = true;
        Iterator partItr = sess.getParticipantIterator();
        while (partItr.hasNext() && !foundTeleconf) {
            CRParticipant p = (CRParticipant)partItr.next();
            if (!this.isBridge(p)) continue;
            foundTeleconf = true;
            audioPermitted = sess.getPermissionValue("AudioPermission", p.getID());
        }
        return foundTeleconf && !audioPermitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CRAnnotation annotation) {
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null || localParticipant.getSession() == null || !localParticipant.getSession().isRunning() || annotation.getID() != localParticipant.getID()) {
            return;
        }
        Field f = null;
        Object object = this.adLock;
        synchronized (object) {
            String name;
            CRPermission audioPerm;
            CRSession sess = localParticipant.getSession();
            CRParticipant annotParticipant = sess.getParticipantById(annotation.getID());
            boolean annotIsTelephony = annotation.getName().equals("TelephonyActivityAnnotation");
            boolean annotIsForBridge = annotParticipant == null ? false : this.isBridge(annotParticipant);
            if (annotIsTelephony && annotIsForBridge) {
                this.updateAudioPermissionsIcons();
            }
            if (annotIsTelephony && (audioPerm = sess.getPermission("AudioPermission", annotation.getID())) != null) {
                this.update(audioPerm, true);
            }
            if (this.activityNameMap.containsKey(name = annotation.getName())) {
                f = this.activityNameMap.get(name);
                boolean interested = false;
                if (this.activityToValuesMap.containsKey((Object)f)) {
                    Object value = annotation.getValue();
                    if (this.activityToValuesMap.get((Object)f).containsKey(value)) {
                        interested = true;
                        this.activities.put(f, value);
                        if (!this.fields.contains((Object)f)) {
                            this.fields.add(f);
                        }
                    }
                }
                if (!interested) {
                    this.activities.remove((Object)f);
                    if (!this.lags.containsKey((Object)f) && !this.permissions.containsKey((Object)f)) {
                        this.fields.remove((Object)f);
                    }
                }
            } else if (this.lagNameMap.containsKey(name)) {
                f = this.lagNameMap.get(name);
                boolean interested = false;
                if (this.lagToValuesMap.containsKey((Object)f)) {
                    Object value = annotation.getValue();
                    if (this.lagToValuesMap.get((Object)f).containsKey(value)) {
                        interested = true;
                        this.lags.put(f, value);
                        if (!this.fields.contains((Object)f)) {
                            this.fields.add(f);
                        }
                    }
                }
                if (!interested) {
                    this.lags.remove((Object)f);
                    if (!this.activities.containsKey((Object)f) && !this.permissions.containsKey((Object)f)) {
                        this.fields.remove((Object)f);
                    }
                }
            }
            if (SwingDebug.ACTIVITY.show()) {
                this.info("update", "field " + (Object)((Object)f));
            }
            if (f != null) {
                this.updateIcon(f);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void refreshParticipantIcons(CRParticipant participant) {
        this.fields.clear();
        this.activities.clear();
        this.lags.clear();
        this.permissions.clear();
        this.icons.clear();
        this.collectParticipantState(participant);
        for (Field f : this.fields) {
            this.updateIcon(f);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(CRPermission permission, boolean defaultChanged) {
        boolean teleconfMode;
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null || localParticipant.getSession() == null || !localParticipant.getSession().isRunning()) {
            return;
        }
        boolean permIsAudio = permission.getName().equals("AudioPermission");
        boolean permIsForParticipant = permission.getID() == localParticipant.getID();
        CRSession sess = localParticipant.getSession();
        CRParticipant participant = sess.getParticipantById(permission.getID());
        if (participant == null) {
            return;
        }
        boolean permIsForBridge = this.isBridge(participant);
        if (permIsAudio && (permIsForParticipant || permIsForBridge) && (teleconfMode = this.isTeleconferenced(participant)) && permIsForBridge) {
            this.refreshParticipantIcons(participant);
        }
        if (!(permIsForBridge || defaultChanged || permIsForParticipant)) {
            return;
        }
        Object object = this.adLock;
        synchronized (object) {
            this.updateAudioPermissionsIcons();
            Field f = null;
            String name = permission.getName();
            if (this.permissionNameMap.containsKey(name)) {
                f = this.permissionNameMap.get(name);
                boolean interested = false;
                if (this.permissionToValuesMap.containsKey((Object)f)) {
                    boolean relevantToTelephony;
                    CRPermission perm = sess.getPermission(name, participant.getID());
                    boolean value = perm.getValue();
                    boolean globalPermissionSupported = perm.globalPermissionSupported();
                    boolean inTelephonyMode = this.isTeleconferenced(participant);
                    boolean bl = relevantToTelephony = inTelephonyMode && name.equals("AudioPermission");
                    if (this.permissionToValuesMap.get((Object)f).containsKey(value) && this.showingAllPermissions) {
                        this.permissions.put(f, value);
                        if (!participant.isChair() || !value || !globalPermissionSupported || relevantToTelephony) {
                            interested = true;
                            if (!this.fields.contains((Object)f)) {
                                this.fields.add(f);
                            }
                        }
                    }
                }
                if (!interested && !participant.isChair()) {
                    this.permissions.remove((Object)f);
                    if (!this.activities.containsKey((Object)f) && !this.lags.containsKey((Object)f)) {
                        this.fields.remove((Object)f);
                    }
                }
            }
            if (SwingDebug.ACTIVITY.show()) {
                this.info("update", "field " + (Object)((Object)f));
            }
            if (f != null) {
                this.updateIcon(f);
            }
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIcon(Field field) {
        Object object = this.adLock;
        synchronized (object) {
            Icon ic;
            String key = this.getKey(field);
            boolean displayed = false;
            if (key != null && (ic = UIManager.getIcon(key)) != null) {
                displayed = true;
                this.icons.put(field, ic);
            }
            if (SwingDebug.ACTIVITY.show()) {
                this.info("updateIcon", "update " + (Object)((Object)field) + " " + displayed + " " + key);
            }
            if (!displayed && (ic = this.icons.remove((Object)field)) != null) {
                this.panel.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKey(Field field) {
        String key = null;
        Object object = this.adLock;
        synchronized (object) {
            if (this.lags.containsKey((Object)field)) {
                Object value = this.lags.get((Object)field);
                key = this.lagToValuesMap.get((Object)field).get(value);
            } else if (this.activities.containsKey((Object)field)) {
                Object value = this.activities.get((Object)field);
                key = this.activityToValuesMap.get((Object)field).get(value);
            } else if (this.permissions.containsKey((Object)field)) {
                Boolean value = this.permissions.get((Object)field);
                key = this.permissionToValuesMap.get((Object)field).get(value);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRolloverKey(Field field) {
        String key = null;
        Object object = this.adLock;
        synchronized (object) {
            if (this.permissions.containsKey((Object)field)) {
                Boolean value = this.permissions.get((Object)field);
                key = this.permissionToRolloverMap.get((Object)field).get(value);
            }
        }
        return key;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins = this.getInsets();
        Dimension ps = new Dimension(ins.left + ins.right, ins.top + ins.bottom + 14);
        int n = this.icons.size();
        if (n != 0) {
            ps.width += 6 + n * 14 + Math.max(n - 1, 0) * 3;
        }
        return ps;
    }

    public Collection<JLabel> getActivityLabels() {
        ArrayList<JLabel> list = new ArrayList<JLabel>();
        for (Component comp : this.panel.getComponents()) {
            if (!(comp instanceof JLabel)) continue;
            list.add((JLabel)comp);
        }
        return list;
    }

    @Override
    public void repaint() {
        this.paintComponent(this.getGraphics());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Insets ins = this.getInsets();
        ins.left = 6;
        int x = 6;
        int y = ins.top;
        int wh = 17;
        this.panel.removeAll();
        this.panel.setSize(this.getPreferredSize());
        this.panel.setBackground(this.getBackground());
        for (Map.Entry<Field, Icon> entry : this.icons.entrySet()) {
            Field field = entry.getKey();
            Icon icon = entry.getValue();
            String key = this.getKey(field);
            String toolTip = null;
            try {
                toolTip = this.i18n.getStringLegacy(key);
            }
            catch (Exception error) {
                // empty catch block
            }
            JLabel iconLabel = this.panel.add(key, icon);
            iconLabel.setToolTipText(toolTip);
            iconLabel.setBackground(this.getBackground());
            iconLabel.setBounds(x, y, wh, wh);
            x += 17;
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private void info(String method, String msg) {
        CRParticipant localParticipant = this.participant;
        String id = localParticipant != null ? localParticipant.getName() + "=" + localParticipant.getID() : "N/A";
        LogSupport.message((Object)this, (String)method, (String)("[" + id + "] " + msg));
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleActivityDisplay();
        }
        return this.accessibleContext;
    }

    public void setPermissionIcons(JLabel hovered) {
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null || !localParticipant.getSession().isChair(localParticipant.getSession().getMe())) {
            return;
        }
        if (hovered == null) {
            return;
        }
        for (Map.Entry<Field, Icon> entry : this.icons.entrySet()) {
            if (!this.permissionToValuesMap.containsKey((Object)entry.getKey()) || !entry.getValue().equals(hovered.getIcon())) continue;
            JLabel iconLabel = this.panel.get(this.getKey(entry.getKey()));
            String rolloverKey = this.getRolloverKey(entry.getKey());
            if (iconLabel == null || rolloverKey == null) continue;
            this.icons.put(entry.getKey(), UIManager.getIcon(rolloverKey));
            iconLabel.setIcon(UIManager.getIcon(rolloverKey));
        }
    }

    public String getPermissionName(JLabel permissionLabel) {
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null || !localParticipant.getSession().isRunning() || permissionLabel == null) {
            return null;
        }
        if (this.isTeleconferenced(localParticipant) && !this.isBridge(localParticipant)) {
            return null;
        }
        for (Map.Entry<Field, Icon> entry : this.icons.entrySet()) {
            Field field;
            if (entry.getValue() == null || !entry.getValue().equals(permissionLabel.getIcon()) || !this.permissionNameMap.containsValue((Object)(field = entry.getKey()))) continue;
            for (Map.Entry<String, Field> nameEntry : this.permissionNameMap.entrySet()) {
                if (!nameEntry.getValue().equals((Object)field)) continue;
                return nameEntry.getKey();
            }
        }
        return null;
    }

    public void togglePermissionValue(String name) {
        CRParticipant localParticipant = this.participant;
        if (localParticipant == null || localParticipant.getSession() == null || !localParticipant.getSession().isRunning()) {
            return;
        }
        CRSession sess = localParticipant.getSession();
        ArrayList<CRParticipant> participants = new ArrayList<CRParticipant>();
        participants.add(localParticipant);
        CRPermission perm = sess.getPermission(name, localParticipant.getID());
        boolean value = perm.getValue();
        sess.setPermissionValue(name, participants, !value);
    }

    protected class AccessibleActivityDisplay
    extends JComponent.AccessibleJComponent {
        protected AccessibleActivityDisplay() {
            super(ActivityDisplay.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }
    }

    private class ActivityPanel
    extends JPanel {
        private Map<String, JLabel> iconLabelMap;
        private GridBagConstraints c;
        private Object lock;

        public ActivityPanel() {
            super(new GridBagLayout());
            this.iconLabelMap = new HashMap<String, JLabel>();
            this.c = new GridBagConstraints();
            this.lock = new Object();
            this.c.ipadx = 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JLabel add(String key, Icon icon) {
            JLabel label = null;
            Object object = this.lock;
            synchronized (object) {
                label = this.get(key);
                if (label != null) {
                    return label;
                }
                label = new JLabel(icon);
                this.iconLabelMap.put(key, label);
                this.add((Component)label, this.c);
            }
            return label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JLabel get(String key) {
            Object object = this.lock;
            synchronized (object) {
                JLabel label = this.iconLabelMap.get(key);
                return label;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JLabel remove(String key) {
            Object object = this.lock;
            synchronized (object) {
                JLabel label = this.iconLabelMap.remove(key);
                return label;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<JLabel> getActivityLabels() {
            Object object = this.lock;
            synchronized (object) {
                return this.iconLabelMap.values();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAll() {
            super.removeAll();
            Object object = this.lock;
            synchronized (object) {
                this.iconLabelMap.clear();
            }
        }
    }

    private static enum Field {
        AUDIO,
        VIDEO,
        CHAT,
        WHITEBOARD,
        SCREEN_SHARING,
        WEB_TOUR,
        CAPTION,
        POLL,
        SETUP;

    }

    private static class PermissionComparator
    implements Comparator<String> {
        private Map<String, Integer> sortValues = new HashMap<String, Integer>();

        public PermissionComparator() {
            this.sortValues.put("AudioPermission", 0);
            this.sortValues.put("VideoPermission", 1);
            this.sortValues.put("ChatPermission", 2);
            this.sortValues.put("WhiteBoardPermission", 3);
            this.sortValues.put("AppSharePermission", 4);
            this.sortValues.put("WebTourPermission", 5);
        }

        @Override
        public int compare(String permission1, String permission2) {
            int v1 = Integer.MAX_VALUE;
            if (this.sortValues.containsKey(permission1)) {
                v1 = this.sortValues.get(permission1);
            }
            int v2 = Integer.MAX_VALUE;
            if (this.sortValues.containsKey(permission2)) {
                v2 = this.sortValues.get(permission2);
            }
            if (v1 < v2) {
                return -1;
            }
            if (v1 > v2) {
                return 1;
            }
            return 0;
        }
    }
}

