/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.RectDistance;
import com.elluminate.classroom.swing.Stage;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.Preferences;
import com.google.inject.Inject;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class WindowLocationHandler
extends AbstractSwingLocationHandler {
    public static final String LOCATION = "window";
    public static final String INITIAL_POSITION_HINT = "window.initialPosition";
    public static final String INITIAL_SIZE_HINT = "window.initialSize";
    public static final String CLOSE_FOR_HINT = "window.closeFor";
    public static final String MIN_WIDTH_HINT = "window.minWidth";
    public static final String MIN_HEIGHT_HINT = "window.minHeight";
    public static final String PERSISTENCE_HINT = "window.persistence";
    public static final Integer DFT_MIN_WIDTH = new Integer(50);
    public static final Integer DFT_MIN_HEIGHT = new Integer(75);
    private static final int ON_SCREEN_MIN = 50;
    private static final Dimension ON_SCREEN_AREA = new Dimension(50, 50);
    private static final Set<String> EMPTY_CLOSE_FOR = new HashSet<String>();
    private Preferences prefs;
    private Stage stage;
    private DialogParentProvider parentProv;
    private Map<String, WindowInfo> windows = new HashMap<String, WindowInfo>();
    private Map<String, Set<Feature>> closeFeatures = new HashMap<String, Set<Feature>>();

    @Inject
    public void initParentProvider(DialogParentProvider prov) {
        this.parentProv = prov;
    }

    @Inject
    public void initPreferences(Preferences prefs) {
        this.prefs = prefs;
    }

    @Inject
    public void initStage(Stage stage) {
        this.stage = stage;
    }

    protected void addFeatureSwing(Feature f) {
        String path = f.getPath();
        if (f instanceof ComponentFeature) {
            WindowInfo info = this.windows.get(path);
            if (info == null) {
                info = new WindowInfo(path);
                this.windows.put(path, info);
            }
            info.setFeature((ComponentFeature)f);
        } else if (f instanceof ActionFeature || f instanceof BooleanFeature) {
            Set targets = (Set)f.getHintValue(CLOSE_FOR_HINT, EMPTY_CLOSE_FOR);
            for (String target : targets) {
                Set<Feature> features = this.closeFeatures.get(target);
                if (features == null) {
                    features = new HashSet<Feature>();
                    this.closeFeatures.put(target, features);
                }
                features.add(f);
            }
        } else {
            throw new IllegalArgumentException("Unsupported feature type for Window Location Handler: " + f.getClass());
        }
    }

    protected void removeFeatureSwing(Feature f) {
        String path = f.getPath();
        if (f instanceof ComponentFeature) {
            WindowInfo info = this.windows.get(path);
            if (info != null) {
                info.clearFeature();
            }
        } else if (f instanceof ActionFeature || f instanceof BooleanFeature) {
            Set targets = (Set)f.getHintValue(CLOSE_FOR_HINT, EMPTY_CLOSE_FOR);
            for (String target : targets) {
                Set<Feature> features = this.closeFeatures.get(target);
                if (features == null) continue;
                features.remove(target);
            }
        }
    }

    static enum Persistence {
        BOUNDS(1),
        POSITION(2),
        SIZE(3),
        NONE(4);

        int hintOrdinal;

        private Persistence(int mapping) {
            this.hintOrdinal = mapping;
        }

        public static Persistence fromHint(Feature f) {
            HintEnum value = (HintEnum)f.getHintValue(WindowLocationHandler.PERSISTENCE_HINT, HintEnum.class);
            if (value == null) {
                return BOUNDS;
            }
            int ordinal = value.getOrdinal();
            for (Persistence pos : Persistence.values()) {
                if (pos.hintOrdinal != ordinal) continue;
                return pos;
            }
            return BOUNDS;
        }
    }

    static enum Position {
        CENTERED(1),
        BELOW(2),
        ON_RIGHT(3),
        STAGE(4);

        int hintOrdinal;

        private Position(int mapping) {
            this.hintOrdinal = mapping;
        }

        public static Position fromHint(Feature f) {
            HintEnum value = (HintEnum)f.getHintValue(WindowLocationHandler.INITIAL_POSITION_HINT, HintEnum.class);
            if (value == null) {
                return CENTERED;
            }
            int ordinal = value.getOrdinal();
            for (Position pos : Position.values()) {
                if (pos.hintOrdinal != ordinal) continue;
                return pos;
            }
            return CENTERED;
        }
    }

    static enum Size {
        PACK(1),
        MINIMUM(2),
        STAGE(3);

        int hintOrdinal;

        private Size(int mapping) {
            this.hintOrdinal = mapping;
        }

        public static Size fromHint(Feature f) {
            HintEnum value = (HintEnum)f.getHintValue(WindowLocationHandler.INITIAL_SIZE_HINT, HintEnum.class);
            if (value == null) {
                return PACK;
            }
            int ordinal = value.getOrdinal();
            for (Size pos : Size.values()) {
                if (pos.hintOrdinal != ordinal) continue;
                return pos;
            }
            return PACK;
        }
    }

    class WindowInfo
    extends WindowAdapter
    implements ComponentListener,
    MetaDataListener {
        private boolean useFrame = false;
        private String path;
        private Container container = null;
        private ComponentFeature feature = null;
        private String posnPref;
        private String sizePref;
        private MetaRunner metaRunner = new MetaRunner();

        public WindowInfo(String path) {
            this.path = path;
            if (Platform.getOS() == 202 && Platform.checkJavaVersion((String)"1.7+") && this.path.contains("multimediaPanel")) {
                this.useFrame = true;
            }
        }

        public void setFeature(ComponentFeature f) {
            if (!f.getPath().equals(this.path)) {
                throw new IllegalArgumentException("Feature/Path mismatch!");
            }
            this.feature = f;
            this.setPrefs();
            String title = f.getName();
            if (title == null) {
                title = f.getPath();
            }
            if (this.container == null) {
                this.setupContainer();
            }
            this.container.add(this.feature.getComponent());
            this.pack(this.container);
            this.feature.addMetaDataListener("Feature.enabled", (MetaDataListener)this);
            this.updateBounds();
            this.setTitle(this.container, title);
            this.container.setVisible(this.feature.isEnabled());
        }

        private void setupContainer() {
            if (this.useFrame) {
                this.container = new JFrame();
                JFrame frm = (JFrame)this.container;
                frm.setAlwaysOnTop(true);
                frm.addWindowListener(this);
                frm.addComponentListener(this);
                frm.setDefaultCloseOperation(0);
                String actionName = "close-window";
                InputMap im = frm.getRootPane().getInputMap(2);
                im.put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), actionName);
                frm.getRootPane().getActionMap().put(actionName, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WindowInfo.this.closeFeatures();
                    }
                });
            } else {
                this.container = new JDialog(WindowLocationHandler.this.parentProv.getDialogParent(), false);
                JDialog dlg = (JDialog)this.container;
                dlg.addWindowListener(this);
                dlg.addComponentListener(this);
                dlg.setDefaultCloseOperation(0);
                String actionName = "close-window";
                InputMap im = dlg.getRootPane().getInputMap(2);
                im.put(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), actionName);
                dlg.getRootPane().getActionMap().put(actionName, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        WindowInfo.this.closeFeatures();
                    }
                });
            }
        }

        private void setTitle(Container container, String title) {
            if (container instanceof JFrame) {
                ((JFrame)container).setTitle(title);
            } else {
                ((JDialog)container).setTitle(title);
            }
        }

        private void pack(Container container) {
            if (container instanceof JDialog) {
                ((JDialog)container).pack();
            } else {
                ((JFrame)container).pack();
            }
        }

        public void clearFeature() {
            this.feature.removeMetaDataListener("Feature.enabled", (MetaDataListener)this);
            this.container.setVisible(false);
            this.container.remove(this.feature.getComponent());
        }

        @Override
        public void windowClosing(WindowEvent e) {
            super.windowClosing(e);
            this.closeFeatures();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.closeFeatures();
        }

        private void closeFeatures() {
            Set close = (Set)WindowLocationHandler.this.closeFeatures.get(this.path);
            if (close == null) {
                return;
            }
            for (Feature closeFeature : close) {
                if (closeFeature instanceof ActionFeature) {
                    ActionFeature action = (ActionFeature)closeFeature;
                    action.fireActionFeatureListeners();
                    continue;
                }
                if (!(closeFeature instanceof BooleanFeature)) continue;
                BooleanFeature toggle = (BooleanFeature)closeFeature;
                toggle.setValue((Object)false);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (this.sizePref != null) {
                WindowLocationHandler.this.prefs.setSetting(this.sizePref, this.container.getSize());
            }
            if (this.posnPref != null) {
                WindowLocationHandler.this.prefs.setSetting(this.posnPref, this.container.getLocation());
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.sizePref != null) {
                WindowLocationHandler.this.prefs.setSetting(this.sizePref, this.container.getSize());
            }
            if (this.posnPref != null) {
                WindowLocationHandler.this.prefs.setSetting(this.posnPref, this.container.getLocation());
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        private void setPrefs() {
            Persistence save = Persistence.fromHint((Feature)this.feature);
            boolean posn = false;
            boolean size = false;
            switch (save) {
                case BOUNDS: {
                    size = true;
                    posn = true;
                    break;
                }
                case POSITION: {
                    posn = true;
                    break;
                }
                case SIZE: {
                    size = true;
                    break;
                }
            }
            this.posnPref = posn ? WindowLocationHandler.LOCATION + this.path.replace('/', '.') + ".posn" : null;
            this.sizePref = size ? WindowLocationHandler.LOCATION + this.path.replace('/', '.') + ".size" : null;
        }

        private void updateBounds() {
            Dimension size = this.getSize();
            Point posn = this.getPosition(size);
            Rectangle rect = new Rectangle(posn, size);
            this.ensureOnScreen(rect);
            this.container.setBounds(rect);
        }

        private Point getPosition(Dimension size) {
            Position pos = Position.fromHint((Feature)this.feature);
            Rectangle main = WindowLocationHandler.this.parentProv.getDialogParent().getBounds();
            Point point = null;
            if (this.posnPref != null && (point = WindowLocationHandler.this.prefs.getPointSetting(this.posnPref, null)) != null) {
                return point;
            }
            switch (pos) {
                case BELOW: {
                    point = new Point(main.x, main.y + main.height);
                    break;
                }
                case ON_RIGHT: {
                    point = new Point(main.x + main.width, main.y);
                    break;
                }
                case STAGE: {
                    point = new Point(0, 0);
                    SwingUtilities.convertPointToScreen(point, WindowLocationHandler.this.stage);
                    break;
                }
                case CENTERED: {
                    point = new Point(main.x + (main.width - size.width) / 2, main.y + (main.height - size.height) / 2);
                }
            }
            return point;
        }

        private Dimension getSize() {
            Size size = Size.fromHint((Feature)this.feature);
            Integer minW = (Integer)this.feature.getHintValue(WindowLocationHandler.MIN_WIDTH_HINT, (Object)DFT_MIN_WIDTH);
            Integer minH = (Integer)this.feature.getHintValue(WindowLocationHandler.MIN_HEIGHT_HINT, (Object)DFT_MIN_HEIGHT);
            Dimension dimension = null;
            this.pack(this.container);
            if (this.sizePref != null && (dimension = WindowLocationHandler.this.prefs.getDimensionSetting(this.sizePref, null)) != null) {
                return dimension;
            }
            switch (size) {
                case PACK: {
                    dimension = this.container.getSize();
                    break;
                }
                case MINIMUM: {
                    dimension = new Dimension(minW, minH);
                    break;
                }
                case STAGE: {
                    dimension = WindowLocationHandler.this.stage.getSize();
                }
            }
            if (dimension.height < minH) {
                dimension.height = minH;
            }
            if (dimension.width < minW) {
                dimension.width = minW;
            }
            return dimension;
        }

        public void metaDataChanged(MetaDataEvent ev) {
            WindowLocationHandler.this.runner.invokeLater((Runnable)this.metaRunner);
        }

        private void ensureOnScreen(Rectangle rect) {
            GraphicsDevice[] gds;
            ArrayList<Rectangle> screens = new ArrayList<Rectangle>();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (GraphicsDevice gd : gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                GraphicsConfiguration config = gd.getDefaultConfiguration();
                Rectangle screenRect = config.getBounds();
                Insets insets = toolkit.getScreenInsets(config);
                screenRect.x += insets.left;
                screenRect.y += insets.top;
                screenRect.width -= insets.left + insets.right;
                screenRect.height -= insets.top + insets.bottom;
                screens.add(screenRect);
            }
            Point tl = rect.getLocation();
            Point tr = new Point(tl.x + rect.width - 50, tl.y);
            Rectangle rl = new Rectangle(tl, ON_SCREEN_AREA);
            Rectangle rr = new Rectangle(tr, ON_SCREEN_AREA);
            if (this.isOnScreen(rl, screens) || this.isOnScreen(rr, screens)) {
                return;
            }
            RectDistance best = null;
            for (Rectangle screen : screens) {
                RectDistance d = new RectDistance(rl, screen);
                best = d.nearer(best);
                d = new RectDistance(rr, screen);
                best = d.nearer(best);
            }
            best.apply(rect);
        }

        private boolean isOnScreen(Rectangle r, List<Rectangle> screens) {
            for (Rectangle screen : screens) {
                if (!screen.contains(r)) continue;
                return true;
            }
            return false;
        }

        class MetaRunner
        implements Runnable {
            MetaRunner() {
            }

            @Override
            public void run() {
                ComponentFeature f = WindowInfo.this.feature;
                if (f == null) {
                    return;
                }
                if (f.isEnabled()) {
                    String title = f.getName();
                    WindowInfo.this.updateBounds();
                    WindowInfo.this.setTitle(WindowInfo.this.container, title);
                    WindowInfo.this.container.setVisible(true);
                } else {
                    WindowInfo.this.container.setVisible(false);
                }
            }
        }
    }
}

