/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.LoadingSplashContentPane;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.google.inject.Inject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SplashLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "splashWindow";
    private static final String AREA = "splashWindowArea";
    private LoadingSplashContentPane splashContentPane;
    private final Object QUEUE_LOCK = new Object();
    private List<ComponentFeature> featureQueue = new ArrayList<ComponentFeature>();
    private boolean featureInstalled = false;

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    public void setSplashContentPane(LoadingSplashContentPane splashContentPane) {
        this.splashContentPane = splashContentPane;
    }

    protected void addFeatureSwing(Feature f) {
        this.addDisplay(f);
    }

    protected void removeFeatureSwing(Feature f) {
        this.removeDisplay(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Object object = this.QUEUE_LOCK;
            synchronized (object) {
                this.featureQueue.add(cf);
                if (this.featureInstalled) {
                    return;
                }
                this.installNextFeature();
                this.splashContentPane.setReadyToClose(!this.featureInstalled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisplay(Feature f) {
        if (f instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)f;
            Object object = this.QUEUE_LOCK;
            synchronized (object) {
                if (this.featureQueue.remove(cf)) {
                    return;
                }
                Component c = cf.getComponent();
                if (c == null) {
                    return;
                }
                this.splashContentPane.removeDisplayComponent(c);
                this.featureInstalled = false;
                this.installNextFeature();
                this.splashContentPane.setReadyToClose(!this.featureInstalled);
            }
        }
    }

    private void installNextFeature() {
        while (!this.featureQueue.isEmpty()) {
            ComponentFeature cf = this.featureQueue.remove(0);
            Component c = cf.getComponent();
            if (c == null) continue;
            this.featureInstalled = true;
            this.splashContentPane.addDisplayComponent(c);
        }
        if (!this.featureInstalled) {
            this.splashContentPane.restoreOriginalDisplayComponent();
        }
    }
}

