/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.AudioVideoPanel;
import com.elluminate.classroom.swing.NullableActionSButton;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.SLevelIndicator;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.classroom.swing.location.ModeHints;
import com.elluminate.classroom.swing.location.NotificationHints;
import com.elluminate.classroom.swing.location.NotificationSupport;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.NumericFeatureAdapter;
import com.elluminate.framework.location.NumericFeatureAdapterProvider;
import com.elluminate.framework.location.StringFeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapterProvider;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;

public class AudioVideoLocationHandler
extends AbstractSwingLocationHandler
implements NotificationHints,
ModeHints {
    private static final String LOCATION = "audioVideo";
    private static final String AREA = "audioVideoArea";
    private static final String TITLE_BAR_AREA = "titleBar";
    private static final String OPTIONS_MENU_AREA = "optionsMenu";
    private static final String VIDEO_DISPLAY_AREA = "videoDisplay";
    private static final String SPEAKER_INDICATOR_AREA = "speakerIndicator";
    private static final String SPEAKER_SLIDER_AREA = "speakerSlider";
    private static final String MICROPHONE_INDICATOR_AREA = "microphoneIndicator";
    private static final String MICROPHONE_SLIDER_AREA = "microphoneSlider";
    private static final String AUDIO_TOGGLE_AREA = "audioToggle";
    private static final String VIDEO_TOGGLE_AREA = "videoToggle";
    private static final String PREVIEW_TOGGLE_AREA = "previewToggle";
    private static final String TELEPHONY_PANEL_AREA = "telephonyPanel";
    private static final String MENU_SECTION = "audioVideoMenuSection";
    private static final String AUDIO_SECTION = "audioSection";
    private static final String TELEPHONY_SECTION = "telephonySection";
    private static final String VIDEO_SECTION = "videoSection";
    private static final String PANEL_SECTION = "panelSection";
    private static final String ORDER = "order";
    private I18n i18n;
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private NotificationSupport notificationSupport = new NotificationSupport();
    private MenuSectionSupport menuSupport = new MenuSectionSupport();
    private MetaDataListener contentEnabledListener = new MetaDataListener(){

        public void metaDataChanged(MetaDataEvent e) {
            if (e.getID().equals("Feature.enabled")) {
                ComponentFeature cf = (ComponentFeature)e.getSourceFeature();
                AudioVideoLocationHandler.this.audioVideoPanel.setExpanded(cf.isEnabled());
            }
        }
    };
    private AudioVideoPanel audioVideoPanel;
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private NumericFeatureAdapterProvider numericAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private StringFeatureAdapterProvider stringAdapterProvider;

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initMenuSupport(MenuSectionSupport menuSupport) {
        this.menuSupport = menuSupport;
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider, NumericFeatureAdapterProvider numericAdapterProvider, StringFeatureAdapterProvider stringAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
        this.numericAdapterProvider = numericAdapterProvider;
        this.stringAdapterProvider = stringAdapterProvider;
    }

    public void setAudioVideoPanel(AudioVideoPanel audioVideoPanel) {
        this.audioVideoPanel = audioVideoPanel;
        this.menuSupport.setMenu(audioVideoPanel.getOptionsMenu());
        this.menuSupport.addSection(AUDIO_SECTION);
        this.menuSupport.addSection(TELEPHONY_SECTION);
        this.menuSupport.addSection(VIDEO_SECTION);
        this.menuSupport.addSection(PANEL_SECTION);
        audioVideoPanel.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                AudioVideoLocationHandler.this.notificationSupport.notifyInterestedFeatures("displayed", e.getNewValue());
            }
        });
    }

    protected void addFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            this.notificationSupport.addInterestedFeature(feature, String.valueOf(notification));
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(TITLE_BAR_AREA)) {
                this.addTitleBarItem(feature);
            } else if (area.equals(OPTIONS_MENU_AREA)) {
                this.addOption(feature);
            } else if (area.equals(VIDEO_DISPLAY_AREA)) {
                this.addVideoDisplay(feature);
            } else if (area.equals(SPEAKER_INDICATOR_AREA)) {
                this.addSpeakerIndicator(feature);
            } else if (area.equals(SPEAKER_SLIDER_AREA)) {
                this.addSpeakerSlider(feature);
            } else if (area.equals(MICROPHONE_INDICATOR_AREA)) {
                this.addMicrophoneIndicator(feature);
            } else if (area.equals(MICROPHONE_SLIDER_AREA)) {
                this.addMicrophoneSlider(feature);
            } else if (area.equals(AUDIO_TOGGLE_AREA)) {
                this.addAudioToggle(feature);
            } else if (area.equals(VIDEO_TOGGLE_AREA)) {
                this.addVideoToggle(feature);
            } else if (area.equals(PREVIEW_TOGGLE_AREA)) {
                this.addPreviewToggle(feature);
            } else if (area.equals(TELEPHONY_PANEL_AREA)) {
                this.addTelephonyItem(feature);
            }
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            this.notificationSupport.removeInterestedFeature(feature, String.valueOf(notification));
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(TITLE_BAR_AREA)) {
                this.removeTitleBarItem(feature);
            } else if (area.equals(OPTIONS_MENU_AREA)) {
                this.removeOption(feature);
            } else if (area.equals(VIDEO_DISPLAY_AREA)) {
                this.removeVideoDisplay(feature);
            } else if (area.equals(SPEAKER_INDICATOR_AREA)) {
                this.removeSpeakerIndicator(feature);
            } else if (area.equals(SPEAKER_SLIDER_AREA)) {
                this.removeSpeakerSlider(feature);
            } else if (area.equals(MICROPHONE_INDICATOR_AREA)) {
                this.removeMicrophoneIndicator(feature);
            } else if (area.equals(MICROPHONE_SLIDER_AREA)) {
                this.removeMicrophoneSlider(feature);
            } else if (area.equals(AUDIO_TOGGLE_AREA)) {
                this.removeAudioToggle(feature);
            } else if (area.equals(VIDEO_TOGGLE_AREA)) {
                this.removeVideoToggle(feature);
            } else if (area.equals(PREVIEW_TOGGLE_AREA)) {
                this.removePreviewToggle(feature);
            } else if (area.equals(TELEPHONY_PANEL_AREA)) {
                this.removeTelephonyItem(feature);
            }
        }
    }

    private void addTitleBarItem(Feature feature) {
        JComponent c = null;
        StringFeatureAdapter a = null;
        if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            JLabel l = new JLabel();
            StringFeatureAdapter sa = this.stringAdapterProvider.get(LOCATION, sf, l, null);
            sa.setHasText(true);
            c = l;
            a = sa;
        } else if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            SButton b = new SButton();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
            aa.setHasIcon(true);
            aa.setHasToolTip(true);
            c = b;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            SButton b = new SButton();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)b, null);
            ba.setHasIcon(true);
            ba.setHasToolTip(true);
            c = b;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            this.audioVideoPanel.addTitleBarItem(c);
        }
    }

    private void removeTitleBarItem(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeTitleBarItem((AbstractButton)a.getComponent());
            a.dispose();
        }
    }

    private void addOption(Feature feature) {
        CCheckBoxMenuItem c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            CMenuItem mi = new CMenuItem();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)mi, null);
            aa.setInteractiveSubstitution(this.i18n.getString((PropertiesEnum)StringsProperties.MENUHANDLER_INTERACTIVEITEM));
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            CCheckBoxMenuItem cbmi = new CCheckBoxMenuItem();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)cbmi, null);
            ba.setHasText(true);
            c = cbmi;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            Object section = feature.getHintValue(MENU_SECTION);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.menuSupport.add((JComponent)c, String.valueOf(section), order);
        }
    }

    private void removeOption(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.menuSupport.remove((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private void addVideoDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            cf.addMetaDataListener(this.contentEnabledListener);
            Component c = cf.getComponent();
            this.audioVideoPanel.addVideoDisplay(c);
        }
    }

    private void removeVideoDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            cf.removeMetaDataListener(this.contentEnabledListener);
            this.audioVideoPanel.removeVideoDisplay(cf.getComponent());
        }
    }

    private void addSpeakerIndicator(Feature feature) {
        if (feature instanceof NumericFeature) {
            NumericFeature nf = (NumericFeature)feature;
            SLevelIndicator ind = new SLevelIndicator((int)((Integer)nf.getMinimumValue()), (int)((Integer)nf.getMaximumValue())){

                @Override
                public AccessibleContext getAccessibleContext() {
                    return null;
                }
            };
            NumericFeatureAdapter na = this.numericAdapterProvider.get(LOCATION, nf, (JProgressBar)ind, null);
            this.adapters.put(feature, (FeatureAdapter)na);
            this.audioVideoPanel.addSpeakerIndicator(ind);
        }
    }

    private void removeSpeakerIndicator(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeSpeakerIndicator((SLevelIndicator)a.getComponent());
            a.dispose();
        }
    }

    private void addSpeakerSlider(Feature feature) {
        if (feature instanceof NumericFeature) {
            NumericFeature nf = (NumericFeature)feature;
            JSlider sl = new JSlider();
            NumericFeatureAdapter na = this.numericAdapterProvider.get(LOCATION, nf, sl, null);
            this.adapters.put(feature, (FeatureAdapter)na);
            this.audioVideoPanel.addSpeakerSlider(sl);
        }
    }

    private void removeSpeakerSlider(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeSpeakerSlider((JSlider)a.getComponent());
            a.dispose();
        }
    }

    private void addMicrophoneIndicator(Feature feature) {
        if (feature instanceof NumericFeature) {
            NumericFeature nf = (NumericFeature)feature;
            SLevelIndicator ind = new SLevelIndicator((int)((Integer)nf.getMinimumValue()), (int)((Integer)nf.getMaximumValue())){

                @Override
                public AccessibleContext getAccessibleContext() {
                    return null;
                }
            };
            NumericFeatureAdapter na = this.numericAdapterProvider.get(LOCATION, nf, (JProgressBar)ind, null);
            this.adapters.put(feature, (FeatureAdapter)na);
            this.audioVideoPanel.addMicrophoneIndicator(ind);
        }
    }

    private void removeMicrophoneIndicator(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeMicrophoneIndicator((SLevelIndicator)a.getComponent());
            a.dispose();
        }
    }

    private void addMicrophoneSlider(Feature feature) {
        if (feature instanceof NumericFeature) {
            NumericFeature nf = (NumericFeature)feature;
            JSlider sl = new JSlider();
            NumericFeatureAdapter na = this.numericAdapterProvider.get(LOCATION, nf, sl, null);
            this.adapters.put(feature, (FeatureAdapter)na);
            this.audioVideoPanel.addMicrophoneSlider(sl);
        }
    }

    private void removeMicrophoneSlider(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeMicrophoneSlider((JSlider)a.getComponent());
            a.dispose();
        }
    }

    private void addAudioToggle(Feature feature) {
        if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            NullableActionSButton b = new NullableActionSButton();
            BooleanFeatureAdapter a = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)b, null);
            a.setHasText(true);
            a.setHasIcon(true);
            a.setHasToolTip(true);
            this.adapters.put(feature, (FeatureAdapter)a);
            this.audioVideoPanel.addAudioToggle(b);
        }
    }

    private void removeAudioToggle(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeAudioToggle((SButton)a.getComponent());
            a.dispose();
        }
    }

    private void addVideoToggle(Feature feature) {
        if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            NullableActionSButton b = new NullableActionSButton();
            BooleanFeatureAdapter a = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)b, null);
            a.setHasText(true);
            a.setHasIcon(true);
            a.setHasToolTip(true);
            this.adapters.put(feature, (FeatureAdapter)a);
            this.audioVideoPanel.addVideoToggle(b);
        }
    }

    private void removeVideoToggle(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeVideoToggle((SButton)a.getComponent());
            a.dispose();
        }
    }

    private void addPreviewToggle(Feature feature) {
        if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            NullableActionSButton b = new NullableActionSButton();
            BooleanFeatureAdapter a = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)b, null);
            a.setHasIcon(true);
            a.setHasToolTip(true);
            this.adapters.put(feature, (FeatureAdapter)a);
            this.audioVideoPanel.addPreviewToggle(b);
        }
    }

    private void removePreviewToggle(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removePreviewToggle((SButton)a.getComponent());
            a.dispose();
        }
    }

    private void addTelephonyItem(Feature feature) {
        if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            JLabel l = new JLabel();
            StringFeatureAdapter a = this.stringAdapterProvider.get(LOCATION, sf, l, null);
            a.setHasText(true);
            this.adapters.put(feature, (FeatureAdapter)a);
            this.audioVideoPanel.addTelephonyComponent(l);
        }
    }

    private void removeTelephonyItem(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.audioVideoPanel.removeTelephonyComponent((AbstractButton)a.getComponent());
            a.dispose();
        }
    }
}

