/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.location.AudioAlertClerk;
import com.elluminate.classroom.swing.location.AudioAlertsPrefsPanel;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.Notification;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.groupware.imps.module.AudioAPI;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesDialog;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class AudioNotificationLocationHandler
extends AbstractSwingLocationHandler
implements MetaDataListener {
    public static final String LOCATION = "notify.audio";
    public static final String SUPPRESS_FEATURE = "notify.audio.suppress";
    public static final String SELECT_HINT = "notify.audio.select";
    private AudioAlertClerk clerk;
    private AudioAlertsPrefsPanel panel;
    private PreferencesDialog dialog;
    private Set<BooleanFeature> suppress = new HashSet<BooleanFeature>();
    private boolean hasApi = false;
    private boolean isPanelPublished = false;

    @Inject
    public AudioNotificationLocationHandler(AudioAlertClerk clerk, AudioAlertsPrefsPanel panel) {
        this.clerk = clerk;
        this.panel = panel;
    }

    @Inject
    public void initPrefsDialog(PreferencesDialog prefsDlg) {
        this.dialog = prefsDlg;
    }

    @Inject
    public void initImps(Imps imps) {
        imps.addImpsAvailableListener((ImpsAvailableListener)new ImpsAvailableListener<AudioAPI>(){

            public void available(AudioAPI instance) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AudioNotificationLocationHandler.this.hasApi = true;
                        AudioNotificationLocationHandler.this.checkPublishPanel();
                    }
                });
            }

            public void removed(AudioAPI instance) {
            }
        }, AudioAPI.class);
        this.hasApi = imps.findBest(AudioAPI.class) != null;
    }

    protected void addFeatureSwing(Feature f) {
        if (f instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)f;
            if (((Boolean)f.getHintValue(SUPPRESS_FEATURE, (Object)Boolean.FALSE)).booleanValue() && this.suppress.add(bf)) {
                bf.addValueChangeListener((MetaDataListener)this);
            }
            this.updateSuppressed();
        } else if (f instanceof EnumeratedFeature) {
            EnumeratedFeature ef = (EnumeratedFeature)f;
            if (ef.getValueType() == Integer.class) {
                EnumeratedFeature ief = ef;
                Object[] values = (Integer[])ief.getAllowedValues();
                if (values.length != 3) {
                    this.logger.error((Object)this, "addFeatureSwing", "Integer enumerated feature " + f.getPath() + " must have enumeration values of 0..2");
                    return;
                }
                Arrays.sort(values);
                for (int i = 0; i < values.length; ++i) {
                    if ((Integer)values[i] == i) continue;
                    this.logger.error((Object)this, "addFeatureSwing", "Integer enumerated feature " + f.getPath() + " must have enumeration values of 0..2");
                    return;
                }
                this.clerk.addSubsetListener((EnumeratedFeature<Integer>)ief);
            } else {
                this.logger.error((Object)this, "addFeatureSwing", "Enumerated feature " + f.getPath() + " is not an integer type.");
            }
        }
    }

    protected void removeFeatureSwing(Feature f) {
        EnumeratedFeature ef;
        if (f instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)f;
            if (((Boolean)bf.getHintValue(SUPPRESS_FEATURE, (Object)Boolean.FALSE)).booleanValue() && this.suppress.remove(bf)) {
                bf.removeValueChangeListener((MetaDataListener)this);
            }
        } else if (f instanceof EnumeratedFeature && (ef = (EnumeratedFeature)f).getValueType() == Integer.class) {
            EnumeratedFeature ief = ef;
            this.clerk.removeSubsetListener((EnumeratedFeature<Integer>)ief);
        }
    }

    private void updateSuppressed() {
        boolean suppressed = false;
        for (BooleanFeature bf : this.suppress) {
            if (!((Boolean)bf.getValue()).booleanValue()) continue;
            suppressed = true;
            break;
        }
        this.clerk.setSuppressed(suppressed);
    }

    protected void deliverNotificationSwing(Notification n) {
        if (n.hasHint(SELECT_HINT)) {
            HintEnum selection = (HintEnum)n.getHintValue(SELECT_HINT, HintEnum.class);
            this.clerk.setSubset(selection.getOrdinal());
        } else {
            this.clerk.fireAlert(n);
        }
    }

    protected void announceNotificationSwing(Notification n) {
        if (this.clerk.addAlert(n)) {
            this.checkPublishPanel();
        }
    }

    public void metaDataChanged(MetaDataEvent ev) {
        this.updateSuppressed();
    }

    private void checkPublishPanel() {
        if (this.isPanelPublished) {
            return;
        }
        if (this.hasApi && this.clerk.getAlerts().size() > 0) {
            this.isPanelPublished = true;
            this.dialog.addPanel((AbstractPreferencesPanel)this.panel);
        }
    }
}

