/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.location.AudioAlert;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Notification;
import com.elluminate.util.Preferences;
import com.elluminate.util.Resource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Singleton
public class AudioAlertClerk {
    public static final int SUBSET_CUSTOM = 0;
    public static final int SUBSET_BASIC = 1;
    public static final int SUBSET_ALL = 2;
    public static final String NAME_HINT = "notify.audio.name";
    public static final String DESC_HINT = "notify.audio.desc";
    public static final String RSRC_HINT = "notify.audio.sound";
    public static final String DEFAULT_HINT = "notify.audio.default";
    public static final String BASIC_HINT = "notify.audio.basic";
    public static final String REQD_HINT = "notify.audio.required";
    public static final String PREFIX = "notify.audio";
    private Map<String, AudioAlert> byPath = new HashMap<String, AudioAlert>();
    private Map<String, AudioAlert> byName = new TreeMap<String, AudioAlert>();
    private boolean suppress = false;
    private Provider<AudioAlert> alertProvider;
    private Preferences prefs;
    private int subset = 2;
    private Object listenerLock = new Object();
    private List<EnumeratedFeature<Integer>> listeners = new ArrayList<EnumeratedFeature<Integer>>();
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            AudioAlertClerk.this.computeSubset();
        }
    };

    @Inject
    public AudioAlertClerk(Provider<AudioAlert> prov, Preferences prefs) {
        this.alertProvider = prov;
        this.prefs = prefs;
    }

    public Collection<AudioAlert> getAlerts() {
        return this.byName.values();
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    public void setSuppressed(boolean suppressed) {
        this.suppress = suppressed;
    }

    public void setSubset(int subset) {
        for (AudioAlert alert : this.byName.values()) {
            boolean newValue;
            if (alert.isMandatory()) continue;
            switch (subset) {
                case 2: {
                    newValue = true;
                    break;
                }
                case 1: {
                    newValue = alert.isLegacy();
                    break;
                }
                default: {
                    return;
                }
            }
            this.prefs.setSetting(alert.getEnabledKey(), newValue);
        }
        this.computeSubset();
    }

    public int getSubset() {
        return this.subset;
    }

    private void computeSubset() {
        boolean all = true;
        boolean basic = true;
        for (AudioAlert alert : this.byName.values()) {
            if (alert.isMandatory()) continue;
            boolean enabled = alert.isEnabled();
            if (!enabled) {
                all = false;
            }
            if (enabled == alert.isLegacy()) continue;
            basic = false;
        }
        int newSubset = all ? 2 : (basic ? 1 : 0);
        if (this.subset != newSubset) {
            this.subset = newSubset;
            for (EnumeratedFeature<Integer> f : this.listeners) {
                f.setValue((Object)this.subset);
            }
        }
    }

    public boolean addAlert(Notification n) {
        if (this.byPath.containsKey(n.getPath())) {
            return false;
        }
        String name = (String)n.getHintValue(NAME_HINT, String.class);
        String desc = (String)n.getHintValue(DESC_HINT, (Object)"");
        Resource rsrc = (Resource)n.getHintValue(RSRC_HINT, Resource.class);
        boolean dft = (Boolean)n.getHintValue(DEFAULT_HINT, (Object)Boolean.FALSE);
        boolean basic = (Boolean)n.getHintValue(BASIC_HINT, (Object)Boolean.FALSE);
        boolean reqd = (Boolean)n.getHintValue(REQD_HINT, (Object)Boolean.FALSE);
        String key = (PREFIX + n.getPath()).replace('/', '.');
        if (name == null) {
            throw new IllegalArgumentException("Notification " + n.getPath() + " is missing the required " + NAME_HINT + " hint.");
        }
        AudioAlert alert = (AudioAlert)this.alertProvider.get();
        alert.initialize(key, name, desc, rsrc);
        alert.setDefaultEnabled(dft);
        alert.setMandatory(reqd);
        alert.setLegacy(basic);
        alert.loadPreferences(this.prefs);
        this.byPath.put(n.getPath(), alert);
        this.byName.put(name, alert);
        this.computeSubset();
        this.prefs.addSettingChangeListener(alert.getEnabledKey(), this.listener);
        return true;
    }

    public void fireAlert(Notification n) {
        if (this.suppress) {
            return;
        }
        AudioAlert alert = this.byPath.get(n.getPath());
        if (alert == null && this.addAlert(n)) {
            alert = this.byPath.get(n.getPath());
        }
        if (alert != null) {
            alert.playCustomSound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubsetListener(EnumeratedFeature<Integer> listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<EnumeratedFeature<Integer>> newList = new ArrayList<EnumeratedFeature<Integer>>(this.listeners);
            newList.add(listener);
            this.listeners = newList;
            if ((Integer)listener.getValue() != this.subset) {
                listener.setValue((Object)this.subset);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubsetListener(EnumeratedFeature<Integer> listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ArrayList<EnumeratedFeature<Integer>> newList = new ArrayList<EnumeratedFeature<Integer>>(this.listeners);
            if (newList.remove(listener)) {
                this.listeners = newList;
            }
        }
    }
}

