/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SStage;
import com.elluminate.classroom.swing.components.skin.SStageUI;
import com.elluminate.classroom.swing.components.skin.shade.ShadeStageBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ShadeStageUI
extends SStageUI {
    private static final Image BACKGROUND_TILE = new ImageIcon(ShadeStageUI.class.getResource("resources/bckgrnd_tile_01.jpg")).getImage();
    private static final Color TOP_SHADOW_COLOR;
    private static final Color LEFT_SHADOW_COLOR;
    private SStage st;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeStageUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.st = (SStage)c;
        this.st.setBorder(new ShadeStageBorder());
    }

    @Override
    public void uninstallUI(JComponent c) {
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Dimension s = this.st.getSize();
        Insets ins = this.st.getInsets();
        int tileWidth = BACKGROUND_TILE.getWidth(this.st);
        int tileHeight = BACKGROUND_TILE.getHeight(this.st);
        if (tileWidth > 0 && tileHeight > 0) {
            for (int y = 0; y < s.height; y += tileHeight) {
                for (int x = 0; x < s.width; x += tileWidth) {
                    g.drawImage(BACKGROUND_TILE, x, y, this.st);
                }
            }
        }
        g.setColor(LEFT_SHADOW_COLOR);
        g.drawLine(ins.left, ins.top, ins.left, s.height - ins.bottom - 1);
        g.setColor(TOP_SHADOW_COLOR);
        g.drawLine(ins.left, ins.top, s.width - ins.right - 1, ins.top);
        g.drawLine(ins.left, s.height - ins.bottom - 1, s.width - ins.right - 1, s.height - ins.bottom - 1);
    }

    static {
        Color c = UIManager.getColor("Shade.outlineColor");
        TOP_SHADOW_COLOR = new Color(c.getRed(), c.getGreen(), c.getBlue(), 70);
        LEFT_SHADOW_COLOR = new Color(c.getRed() * 1 / 4, c.getGreen() * 1 / 4, c.getBlue() * 1 / 4, 192);
    }
}

