/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SSideBarTab;
import com.elluminate.classroom.swing.components.SSideBarTabBar;
import com.elluminate.classroom.swing.components.skin.SSideBarTabUI;
import com.elluminate.classroom.swing.components.skin.shade.Shade;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ShadeSideBarTabUI
extends SSideBarTabUI {
    private SSideBarTab t;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeSideBarTabUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.t = (SSideBarTab)c;
        this.t.getComponent(1).setFont(Shade.deriveFont(UIManager.getFont("Label.font"), 0, 0.9166667f));
        this.t.setMinimumSize(new Dimension(65, 0));
        this.t.setMaximumSize(new Dimension(105, 0));
        this.t.setBackground(UIManager.getColor("SideBarPanel.background"));
        this.t.setBorder(BorderFactory.createEmptyBorder(3, 8, 6, 8));
    }

    @Override
    public void uninstallUI(JComponent c) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Container p = this.t.getParent();
        boolean selected = false;
        boolean fauxFocused = false;
        if (p instanceof SSideBarTabBar) {
            SSideBarTabBar tb = (SSideBarTabBar)p;
            selected = tb.getTabComponent(tb.getSelectedTab()) == this.t;
            fauxFocused = tb.getTabComponent(tb.getFauxFocusTab()) == this.t;
        }
        Dimension s = this.t.getSize();
        if (selected) {
            g2.setPaint(new GradientPaint(0.0f, 0.0f, this.t.getBackground(), 0.0f, s.height, Shade.lightenColor(this.t.getBackground(), 0.588)));
            g2.fillRoundRect(1, -3, s.width - 3, s.height + 4 - 3, 6, 6);
            g2.setColor(Shade.lightenColor(this.t.getBackground(), 0.35));
            g2.drawRoundRect(1, -3, s.width - 3, s.height + 4 - 3, 6, 6);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, UIManager.getColor("SideBar.tabBorderColor"), 0.0f, s.height, Shade.lightenColor(UIManager.getColor("SideBar.tabBorderColor"), 0.2)));
            g2.drawRoundRect(0, -4, s.width - 1, s.height + 4 - 1, 8, 8);
        } else {
            g2.setColor(Shade.darkenColor(this.t.getBackground(), 0.093));
            g2.fillRoundRect(0, -4, s.width - 1, s.height + 4 - 3, 8, 8);
            g2.setColor(Shade.lightenColor(UIManager.getColor("SideBar.tabBorderColor"), 0.3));
            g2.drawRoundRect(0, -4, s.width - 1, s.height + 4 - 3, 8, 8);
        }
        if (!selected) {
            g2.setColor(UIManager.getColor("SideBar.tabBorderColor"));
            g2.drawLine(0, 0, s.width, 0);
        }
        if (fauxFocused) {
            Shade.paintFocusBorder(c, g2);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }
}

