/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;

public class ShadeLevelIndicatorUI
extends ProgressBarUI {
    private JProgressBar l;
    private ChangeListener changeListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            ShadeLevelIndicatorUI.this.l.repaint();
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new ShadeLevelIndicatorUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.l = (JProgressBar)c;
        this.l.addChangeListener(this.changeListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.l.removeChangeListener(this.changeListener);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(100, 5);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension s = this.l.getSize();
        Color c1 = new Color(102, 100, 95);
        Color c2 = new Color(205, 200, 189);
        g2.setPaint(new GradientPaint(0.0f, 0.0f, c1, 0.0f, s.height - 1, c2));
        g2.fillRoundRect(0, 0, s.width, s.height, s.height, s.height);
        int value = this.l.getValue();
        int min = this.l.getMinimum();
        int max = this.l.getMaximum();
        if (value > min) {
            int len = (int)((double)s.width * (double)(value - min) / (double)(max - min));
            g2.setColor(new Color(84, 72, 56));
            g2.fillRoundRect(0, 0, len, s.height, s.height, s.height);
        }
    }
}

