/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SBadge;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.skin.delegate.DelegateButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ShadeButtonUI
extends DelegateButtonUI {
    private static final int BADGE_SIZE = 13;
    private SButton b;
    private SBadge badge;
    private boolean custom;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("badgeText")) {
                if (ShadeButtonUI.this.badge == null) {
                    ShadeButtonUI.this.badge = new SBadge();
                }
                ShadeButtonUI.this.b.repaint();
            } else if (prop.equals("badgeFont") || prop.equals("badgeColor")) {
                if (ShadeButtonUI.this.badge != null) {
                    ShadeButtonUI.this.b.repaint();
                }
            } else if (prop.equals("resources")) {
                ShadeButtonUI.this.custom = e.getNewValue() != null;
                if (ShadeButtonUI.this.custom) {
                    ShadeButtonUI.this.b.setBorder(BorderFactory.createEmptyBorder());
                    ShadeButtonUI.this.b.setContentAreaFilled(false);
                }
                ShadeButtonUI.this.b.revalidate();
                ShadeButtonUI.this.b.repaint();
            } else if (prop.equals("selectedResources")) {
                ShadeButtonUI.this.b.revalidate();
                ShadeButtonUI.this.b.repaint();
            } else if (prop.equals("rolloverResources")) {
                ShadeButtonUI.this.b.revalidate();
                ShadeButtonUI.this.b.repaint();
            } else if (prop.equals("JButton.buttonType")) {
                ShadeButtonUI.this.updateMacForeground();
            }
        }
    };
    private ItemListener itemListener;
    private Color normalMacForeground;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeButtonUI();
    }

    public ShadeButtonUI() {
        super("ButtonUI");
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.b = (SButton)c;
        this.b.setBadgeFont(UIManager.getFont("Badge.font"));
        this.b.setBadgeColor(UIManager.getColor("Badge.color"));
        boolean bl = this.custom = this.b.getResources() != null;
        if (this.custom) {
            this.b.setBorder(BorderFactory.createEmptyBorder());
            this.b.setContentAreaFilled(false);
        }
        this.b.addPropertyChangeListener("badgeText", this.propertyListener);
        this.b.addPropertyChangeListener("badgeFont", this.propertyListener);
        this.b.addPropertyChangeListener("badgeColor", this.propertyListener);
        this.b.addPropertyChangeListener("resources", this.propertyListener);
        this.b.addPropertyChangeListener("selectedResources", this.propertyListener);
        this.b.addPropertyChangeListener("rolloverResources", this.propertyListener);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ShadeButtonUI.this.updateMacForeground();
                }
            };
            this.b.addItemListener(this.itemListener);
            this.b.addPropertyChangeListener("JButton.buttonType", this.propertyListener);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.b.removePropertyChangeListener("badgeText", this.propertyListener);
        this.b.removePropertyChangeListener("badgeFont", this.propertyListener);
        this.b.removePropertyChangeListener("badgeColor", this.propertyListener);
        this.b.removePropertyChangeListener("resources", this.propertyListener);
        this.b.removePropertyChangeListener("selectedResources", this.propertyListener);
        this.b.removePropertyChangeListener("rolloverResources", this.propertyListener);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.b.removeItemListener(this.itemListener);
            this.b.removePropertyChangeListener("JButton.buttonType", this.propertyListener);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (this.custom) {
            int rightWidth;
            Icon[] rsrcs = null;
            ButtonModel m = this.b.getModel();
            if (m.isSelected()) {
                rsrcs = this.b.getSelectedResources();
            } else if (m.isRollover()) {
                rsrcs = this.b.getRolloverResources();
            }
            if (rsrcs == null) {
                rsrcs = this.b.getResources();
            }
            Icon left = rsrcs != null ? rsrcs[0] : null;
            Icon center = rsrcs != null ? rsrcs[1] : null;
            Icon right = rsrcs != null ? rsrcs[2] : null;
            Dimension s = c.getSize();
            int x = 0;
            if (left != null) {
                left.paintIcon(c, g, x, 0);
                x += left.getIconWidth();
            }
            int n = rightWidth = right != null ? right.getIconWidth() : 0;
            if (center != null) {
                Shape oldClip = g.getClip();
                int x1 = x;
                int x2 = s.width - rightWidth;
                g.clipRect(x1, 0, x2 - x1, s.height);
                while (x < x2) {
                    center.paintIcon(c, g, x, 0);
                    x += center.getIconWidth();
                }
                g.setClip(oldClip);
            }
            if (right != null) {
                right.paintIcon(c, g, s.width - rightWidth, 0);
            }
        }
        super.update(g, c);
        String txt = this.b.getBadgeText();
        if (txt != null) {
            this.badge.setText(txt);
            this.badge.setFont(this.b.getBadgeFont());
            this.badge.setColor(this.b.getBadgeColor());
            Dimension s = this.b.getSize();
            int x = s.width - this.badge.getIconWidth();
            int y = s.height - this.badge.getIconHeight();
            this.badge.paintIcon(this.b, g, x, y);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int h;
        Dimension ps = super.getPreferredSize(c);
        if (this.custom && ps != null && (h = this.getResourcesHeight()) != -1) {
            ps.height = h;
        }
        return ps;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        int h;
        Dimension ms = super.getMinimumSize(c);
        if (this.custom && ms != null && (h = this.getResourcesHeight()) != -1) {
            ms.height = h;
        }
        return ms;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        int h;
        Dimension ms = super.getMaximumSize(c);
        if (this.custom && ms != null && (h = this.getResourcesHeight()) != -1) {
            ms.height = h;
        }
        return ms;
    }

    private int getResourcesHeight() {
        int h = -1;
        Icon[] rsrcs = this.b.getResources();
        if (rsrcs != null) {
            if (rsrcs[0] != null) {
                h = rsrcs[0].getIconHeight();
            } else if (rsrcs[1] != null) {
                h = rsrcs[1].getIconHeight();
            } else if (rsrcs[2] != null) {
                h = rsrcs[2].getIconHeight();
            }
        }
        return h;
    }

    private void updateMacForeground() {
        Object buttonType = this.b.getClientProperty("JButton.buttonType");
        if (buttonType != null && buttonType.equals("textured")) {
            if (this.b.isSelected()) {
                if (this.normalMacForeground == null) {
                    this.normalMacForeground = this.b.getForeground();
                }
                this.b.setForeground(Color.WHITE);
            } else {
                this.b.setForeground(this.normalMacForeground);
            }
        }
    }
}

