/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

class Shade {
    private static Map<Dimension, Icon> blankIcons = new HashMap<Dimension, Icon>();
    private static final Color focusColor = UIManager.getColor("Focus.color");

    private Shade() {
    }

    public static Icon getIcon(String resourceName) {
        URL url = Shade.class.getResource("resources/" + resourceName);
        if (url == null) {
            throw new IllegalArgumentException("No icon in Shade L&F named resources/" + resourceName);
        }
        return new ImageIcon(url);
    }

    public static String getFullResourcePath(String resourceName) {
        return Shade.class.getResource("resources/" + resourceName).toString();
    }

    public static Image getImage(String resourceName) {
        return ((ImageIcon)Shade.getIcon(resourceName)).getImage();
    }

    public static Icon getBlankIcon(int width, int height) {
        Dimension s = new Dimension(width, height);
        Icon ic = blankIcons.get(s);
        if (ic == null) {
            ic = new BlankIcon(width, height);
            blankIcons.put(s, ic);
        }
        return ic;
    }

    public static Color contrastColor(Color color) {
        int b;
        int g;
        if (color == null) {
            return Color.BLACK;
        }
        int r = (int)((double)color.getRed() * 0.299);
        if (r + (g = (int)((double)color.getGreen() * 0.587)) + (b = (int)((double)color.getBlue() * 0.114)) > 128) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static Color midColor(Color color1, Color color2) {
        return new Color((color2.getRed() + color1.getRed()) / 2, (color2.getGreen() + color1.getGreen()) / 2, (color2.getBlue() + color1.getBlue()) / 2);
    }

    public static Color lightenColor(Color color, double factor) {
        return new Color(color.getRed() + (int)((double)(255 - color.getRed()) * factor), color.getGreen() + (int)((double)(255 - color.getGreen()) * factor), color.getBlue() + (int)((double)(255 - color.getBlue()) * factor));
    }

    public static Color darkenColor(Color color, double factor) {
        return new Color((int)((double)color.getRed() * (1.0 - factor)), (int)((double)color.getGreen() * (1.0 - factor)), (int)((double)color.getBlue() * (1.0 - factor)));
    }

    public static Font deriveFont(Font font, int style, float sizeFactor) {
        return font.deriveFont(style, (int)((float)font.getSize() * sizeFactor));
    }

    public static void paintFocusBorder(Component c, Graphics g) {
        g.setColor(focusColor);
        g.drawRoundRect(2, 0, c.getWidth() - 5, c.getHeight() - 4, 3, 3);
    }

    private static class BlankIcon
    implements Icon {
        private int width;
        private int height;

        public BlankIcon(int width, int height) {
            this.width = width;
            this.height = height;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component comp, Graphics g, int x, int y) {
        }
    }
}

