/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.delegate;

import com.elluminate.classroom.swing.components.skin.delegate.DelegateConstants;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DelegateTextUI
extends TextUI
implements DelegateConstants {
    private String delegateUIClassID;
    private TextUI delegate;

    protected DelegateTextUI(String delegateUIClassID) {
        this.delegateUIClassID = delegateUIClassID;
    }

    @Override
    public void installUI(JComponent c) {
        c.putClientProperty("Delegate.bypassGetUIClassID", true);
        this.delegate = DelegateTextUI.loadDelegate(c, this.delegateUIClassID);
        this.delegate.installUI(c);
        c.putClientProperty("Delegate.bypassGetUIClassID", null);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.putClientProperty("Delegate.bypassGetUIClassID", true);
        this.delegate.uninstallUI(c);
        c.putClientProperty("Delegate.bypassGetUIClassID", null);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.delegate.paint(g, c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        c.putClientProperty("Delegate.bypassGetUIClassID", true);
        this.delegate.update(g, c);
        c.putClientProperty("Delegate.bypassGetUIClassID", null);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.delegate.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.delegate.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.delegate.getMaximumSize(c);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this.delegate.contains(c, x, y);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this.delegate.getAccessibleChildrenCount(c);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this.delegate.getAccessibleChild(c, i);
    }

    @Override
    public Rectangle modelToView(JTextComponent t, int pos) throws BadLocationException {
        return this.delegate.modelToView(t, pos);
    }

    @Override
    public Rectangle modelToView(JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        return this.delegate.modelToView(t, pos, bias);
    }

    @Override
    public int viewToModel(JTextComponent t, Point pt) {
        return this.delegate.viewToModel(t, pt);
    }

    @Override
    public int viewToModel(JTextComponent t, Point pt, Position.Bias[] biasReturn) {
        return this.delegate.viewToModel(t, pt, biasReturn);
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return this.delegate.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1) {
        this.delegate.damageRange(t, p0, p1);
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias firstBias, Position.Bias secondBias) {
        this.delegate.damageRange(t, p0, p1, firstBias, secondBias);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent t) {
        return this.delegate.getEditorKit(t);
    }

    @Override
    public View getRootView(JTextComponent t) {
        return this.delegate.getRootView(t);
    }

    private static TextUI loadDelegate(JComponent c, String delegateUIClassID) {
        UIDefaults def = UIManager.getDefaults();
        ClassLoader cl = (ClassLoader)def.get("ClassLoader");
        if (cl == null) {
            cl = c.getClass().getClassLoader();
        }
        Class<? extends ComponentUI> clss = def.getUIClass(delegateUIClassID, cl);
        try {
            Method m = (Method)def.get(clss);
            if (m == null) {
                m = clss.getMethod("createUI", JComponent.class);
                def.put(clss, m);
            }
            return (TextUI)m.invoke(null, c);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

