/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public class WeightLayout
implements LayoutManager2 {
    private Map<Component, Number> constraints = new HashMap<Component, Number>();
    private Map<Component, Integer> fixedHeights = new HashMap<Component, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object constraint) {
        Object object = component.getTreeLock();
        synchronized (object) {
            if (constraint == null) {
                constraint = 1.0;
            }
            if (!(constraint instanceof Number)) {
                throw new IllegalArgumentException("Cannot add to layout: constraint is not a number (" + constraint.getClass().getName() + ")");
            }
            this.constraints.put(component, (Number)constraint);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new UnsupportedOperationException("Use addLayoutComponent(Component, Object)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            this.constraints.remove(component);
        }
    }

    public Object getConstraints(Component component) {
        return this.constraints.get(component);
    }

    public void setConstraints(Component component, Object constraint) {
        if (this.constraints.containsKey(component) && constraint instanceof Number) {
            this.constraints.put(component, (Number)constraint);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return parent.getSize();
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container parent) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container parent) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension s = parent.getSize();
            if (s.getHeight() <= 0.0) {
                return;
            }
            Insets ins = parent.getInsets();
            Component[] cs = parent.getComponents();
            double totalWeight = 0.0;
            for (Component c : cs) {
                if (!c.isVisible()) continue;
                double weight = this.constraints.get(c).doubleValue();
                totalWeight += weight;
            }
            int totalHeight = s.height - ins.top - ins.bottom;
            this.fixedHeights.clear();
            boolean fixedMaxDone = false;
            boolean fixedMinDone = false;
            while (!fixedMaxDone || !fixedMinDone) {
                boolean maxEncountered = false;
                boolean minEncountered = false;
                for (Component c : cs) {
                    int minh;
                    if (!c.isVisible() || this.fixedHeights.containsKey(c)) continue;
                    double weight = this.constraints.get(c).doubleValue();
                    int h = (int)(0.5 + (double)totalHeight * weight / totalWeight);
                    if (c instanceof JComponent) {
                        ((JComponent)c).putClientProperty("weightedHeight", h);
                    }
                    if (!fixedMaxDone) {
                        int maxh = c.getMaximumSize().height;
                        if (h <= maxh) continue;
                        this.fixedHeights.put(c, maxh);
                        totalHeight -= maxh;
                        totalWeight -= weight;
                        maxEncountered = true;
                        continue;
                    }
                    if (fixedMinDone || h >= (minh = c.getMinimumSize().height)) continue;
                    this.fixedHeights.put(c, minh);
                    totalHeight -= minh;
                    totalWeight -= weight;
                    minEncountered = true;
                }
                if (!fixedMaxDone && !maxEncountered) {
                    fixedMaxDone = true;
                    continue;
                }
                if (!fixedMaxDone || fixedMinDone || minEncountered) continue;
                fixedMinDone = true;
            }
            int x = ins.left;
            int y = ins.top;
            int w = s.width - ins.left - ins.right;
            for (Component c : cs) {
                int h;
                if (!c.isVisible()) continue;
                if (this.fixedHeights.containsKey(c)) {
                    h = this.fixedHeights.get(c);
                } else {
                    double weight = this.constraints.get(c).doubleValue();
                    h = (int)(0.5 + (double)totalHeight * weight / totalWeight);
                }
                c.setBounds(x, y, w, h);
                y += h;
            }
        }
    }
}

