/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextPane;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class WatermarkTextPane
extends JTextPane
implements FocusListener {
    private static final Color WATERMARK_COLOR = new Color(204, 204, 204);
    private String watermarkText = "";
    private boolean displayWatermark = false;
    private boolean refreshRequired = true;

    public WatermarkTextPane() {
        this.addFocusListener(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.setDisplayWatermark(false);
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.getText().length() <= 0) {
            this.setDisplayWatermark(true);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.refreshRequired) {
            this.refreshRequired = false;
            if (this.displayWatermark && this.getText().length() <= 0) {
                this.setForeground(Color.gray);
                g.drawString(this.watermarkText, 5, 15);
            } else {
                WatermarkTextPane.setJTextPaneForegroundColor(this, Color.black);
            }
        }
    }

    public static void setJTextPaneForegroundColor(JTextPane jtp, Color c) {
        MutableAttributeSet attrs = jtp.getInputAttributes();
        StyleConstants.setForeground(attrs, c);
        StyledDocument doc = jtp.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
    }

    public void setWatermarkText(String text) {
        this.watermarkText = text;
        if (this.getText().length() <= 0) {
            this.setDisplayWatermark(true);
        }
        this.repaint();
    }

    private void setDisplayWatermark(boolean displayWatermark) {
        this.displayWatermark = displayWatermark;
        this.refreshRequired = true;
    }
}

