/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.SSideBar;
import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.components.WeightLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

class SizingAdapter
implements MouseListener,
MouseMotionListener {
    static final int SIZING_BORDER = 5;
    private Point handle;
    private boolean canResizeTop;
    private boolean canResizeLeft;
    private boolean canResizeBottom;
    private boolean canResizeRight;

    SizingAdapter() {
    }

    private void attemptResizeDockedRight(SSideBarPanel panel, int delta) {
        if (delta == 0) {
            return;
        }
        JSplitPane sp = SizingAdapter.getSplitPane(panel);
        if (sp != null) {
            int x;
            int x2 = x = sp.getDividerLocation();
            int min = sp.getMinimumDividerLocation();
            x2 = x + delta < min / 2 ? 3 : (x + delta < min ? min : Math.min(sp.getMaximumDividerLocation(), x + delta));
            if (x != x2) {
                sp.setDividerLocation(x2);
                this.handle.x += x2 - x;
            }
        }
    }

    private void attemptResizeDockedTop(SSideBarPanel panel, int delta) {
        SSideBarPanel[] ps;
        LayoutManager l;
        if (delta == 0) {
            return;
        }
        SSideBar sb = SizingAdapter.getSideBar(panel);
        if (sb != null && (l = sb.getLayout()) instanceof WeightLayout && (ps = sb.getResizablePanels(panel)) != null && SizingAdapter.adjustLayoutWeights((WeightLayout)l, ps[0], ps[1], delta)) {
            this.handle.y += delta;
        }
    }

    private static boolean adjustLayoutWeights(WeightLayout layout, SSideBarPanel top, SSideBarPanel bottom, int delta) {
        int topHeight = top.getHeight();
        int bottomHeight = bottom.getHeight();
        double topWeight = ((Number)layout.getConstraints(top)).doubleValue();
        double bottomWeight = ((Number)layout.getConstraints(bottom)).doubleValue();
        int totalHeight = topHeight + bottomHeight;
        double totalWeight = topWeight + bottomWeight;
        int desiredTopHeight = topHeight + delta;
        int desiredBottomHeight = bottomHeight - delta;
        if (desiredTopHeight < top.getMinimumSize().height || desiredTopHeight > top.getMaximumSize().height || desiredBottomHeight < bottom.getMinimumSize().height || desiredBottomHeight > bottom.getMaximumSize().height) {
            return false;
        }
        double newTopWeight = (double)(topHeight + delta) * totalWeight / (double)totalHeight;
        double newBottomWeight = totalWeight - newTopWeight;
        layout.setConstraints(top, newTopWeight);
        layout.setConstraints(bottom, newBottomWeight);
        top.revalidate();
        bottom.revalidate();
        return true;
    }

    private static void adjustTop(Rectangle bounds, int delta) {
        bounds.y += delta;
        bounds.height -= delta;
    }

    private static void adjustLeft(Rectangle bounds, int delta) {
        bounds.x += delta;
        bounds.width -= delta;
    }

    private static void adjustBottom(Rectangle bounds, int delta) {
        bounds.height += delta;
    }

    private static void adjustRight(Rectangle bounds, int delta) {
        bounds.width += delta;
    }

    private static SSideBar getSideBar(SSideBarPanel sideBarPanel) {
        Container c;
        for (c = sideBarPanel.getParent(); c != null && !(c instanceof SSideBar); c = c.getParent()) {
        }
        return (SSideBar)c;
    }

    private static JSplitPane getSplitPane(SSideBarPanel sideBarPanel) {
        Container c;
        for (c = sideBarPanel.getParent(); c != null && !(c instanceof JSplitPane); c = c.getParent()) {
        }
        return (JSplitPane)c;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.canResizeTop || this.canResizeLeft || this.canResizeBottom || this.canResizeRight) {
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            this.handle = new Point(pt);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.handle = null;
    }

    @Override
    public void mouseExited(MouseEvent e) {
        e.getComponent().setCursor(null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        SSideBarPanel p = (SSideBarPanel)e.getComponent();
        this.canResizeTop = false;
        this.canResizeLeft = false;
        this.canResizeBottom = false;
        this.canResizeRight = false;
        if (p.isDocked()) {
            SSideBar sb;
            if (e.getX() >= p.getWidth() - 5) {
                this.canResizeRight = true;
            } else if (e.getY() < 5 && (sb = SizingAdapter.getSideBar(p)) != null) {
                SSideBarPanel[] ps = sb.getResizablePanels(p);
                this.canResizeTop = ps != null;
            }
        } else {
            int x = e.getX();
            if (x < 5) {
                this.canResizeLeft = true;
            } else if (x >= p.getWidth() - 5) {
                this.canResizeRight = true;
            }
            if (p.isExpanded()) {
                int y = e.getY();
                if (y < 5) {
                    this.canResizeTop = true;
                } else if (y >= p.getHeight() - 5) {
                    this.canResizeBottom = true;
                }
            }
        }
        Cursor crsr = null;
        if (this.canResizeTop && this.canResizeLeft) {
            crsr = Cursor.getPredefinedCursor(6);
        } else if (this.canResizeLeft && this.canResizeBottom) {
            crsr = Cursor.getPredefinedCursor(4);
        } else if (this.canResizeBottom && this.canResizeRight) {
            crsr = Cursor.getPredefinedCursor(5);
        } else if (this.canResizeRight && this.canResizeTop) {
            crsr = Cursor.getPredefinedCursor(7);
        } else if (this.canResizeTop) {
            crsr = Cursor.getPredefinedCursor(8);
        } else if (this.canResizeLeft) {
            crsr = Cursor.getPredefinedCursor(10);
        } else if (this.canResizeBottom) {
            crsr = Cursor.getPredefinedCursor(9);
        } else if (this.canResizeRight) {
            crsr = Cursor.getPredefinedCursor(11);
        }
        p.setCursor(crsr);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.handle != null) {
            SSideBarPanel p = (SSideBarPanel)e.getComponent();
            Point pt = e.getPoint();
            SwingUtilities.convertPointToScreen(pt, e.getComponent());
            int xDelta = pt.x - this.handle.x;
            int yDelta = pt.y - this.handle.y;
            if (p.isDocked()) {
                if (this.canResizeRight) {
                    this.attemptResizeDockedRight(p, xDelta);
                } else if (this.canResizeTop) {
                    this.attemptResizeDockedTop(p, yDelta);
                }
            } else {
                Window w = SwingUtilities.getWindowAncestor(p);
                if (w != null) {
                    Rectangle b = w.getBounds();
                    Dimension ms = w.getMinimumSize();
                    if (this.canResizeLeft) {
                        xDelta = Math.min(xDelta, b.width - ms.width);
                    } else if (this.canResizeRight) {
                        xDelta = Math.max(xDelta, ms.width - b.width);
                    }
                    if (this.canResizeTop) {
                        yDelta = Math.min(yDelta, b.height - ms.height);
                    } else if (this.canResizeBottom) {
                        yDelta = Math.max(yDelta, ms.height - b.height);
                    }
                    if (this.canResizeTop && this.canResizeLeft) {
                        SizingAdapter.adjustTop(b, yDelta);
                        SizingAdapter.adjustLeft(b, xDelta);
                    } else if (this.canResizeLeft && this.canResizeBottom) {
                        SizingAdapter.adjustBottom(b, yDelta);
                        SizingAdapter.adjustLeft(b, xDelta);
                    } else if (this.canResizeBottom && this.canResizeRight) {
                        SizingAdapter.adjustBottom(b, yDelta);
                        SizingAdapter.adjustRight(b, xDelta);
                    } else if (this.canResizeRight && this.canResizeTop) {
                        SizingAdapter.adjustTop(b, yDelta);
                        SizingAdapter.adjustRight(b, xDelta);
                    } else if (this.canResizeTop) {
                        SizingAdapter.adjustTop(b, yDelta);
                    } else if (this.canResizeLeft) {
                        SizingAdapter.adjustLeft(b, xDelta);
                    } else if (this.canResizeBottom) {
                        SizingAdapter.adjustBottom(b, yDelta);
                    } else if (this.canResizeRight) {
                        SizingAdapter.adjustRight(b, xDelta);
                    }
                    w.setBounds(b);
                    this.handle.setLocation(pt);
                }
            }
        }
    }
}

