/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.ButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.MenuButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.components.SToggleButton;
import com.elluminate.classroom.swing.components.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class SSideBarTitleBar
extends JComponent
implements Accessible {
    private static final String uiClassID = "SSideBarTitleBarUI";
    private static final I18n i18n = I18n.create(SSideBarTitleBar.class);
    private SSideBarPanel sideBarPanel;
    private String title;
    private JToggleButton expandButton;
    private JPanel titlePanel;
    private GridBagConstraints titleConstraints;
    private JLabel titleLabel;
    private JPanel buttonBar;
    private SMenuButton optionsButton;
    private SButton closeButton;
    private Font optionsFont;

    public SSideBarTitleBar(SSideBarPanel sideBarPanel) {
        this(sideBarPanel, null);
    }

    public SSideBarTitleBar(SSideBarPanel sideBarPanel, String title) {
        this.sideBarPanel = sideBarPanel;
        this.title = title;
        this.setLayout(new BorderLayout());
        this.expandButton = new SToggleButton();
        this.expandButton.setIcon(UIManager.getIcon("SideBar.collapsedIcon"));
        this.expandButton.setRolloverIcon(UIManager.getIcon("SideBar.collapsedRolloverIcon"));
        this.expandButton.setSelectedIcon(UIManager.getIcon("SideBar.expandedIcon"));
        this.expandButton.setRolloverIcon(UIManager.getIcon("SideBar.collapsedRolloverIcon"));
        this.expandButton.setRolloverSelectedIcon(UIManager.getIcon("SideBar.expandedRolloverIcon"));
        this.expandButton.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.expandButton.setCursor(Cursor.getPredefinedCursor(0));
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.addFocusListener(new ButtonFocusDisplayer());
        this.expandButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSideBarTitleBar.this.sideBarPanel.setExpanded(SSideBarTitleBar.this.expandButton.isSelected());
            }
        });
        this.add((Component)this.expandButton, "West");
        this.titlePanel = new JPanel(new GridBagLayout());
        this.titlePanel.setOpaque(false);
        this.add((Component)this.titlePanel, "Center");
        this.titleConstraints = new GridBagConstraints();
        this.titleConstraints.anchor = 17;
        this.titleConstraints.weightx = 1.0;
        this.titleLabel = new JLabel(title != null ? title.toUpperCase() : null);
        this.titleLabel.setFont(UIManager.getFont("SideBar.titleFont"));
        this.titleLabel.setForeground(UIManager.getColor("SideBar.titleForeground"));
        this.titlePanel.add((Component)this.titleLabel, this.titleConstraints);
        this.buttonBar = new JPanel(new FlowLayout(2, 0, 0));
        this.buttonBar.setOpaque(false);
        this.add((Component)this.buttonBar, "East");
        this.optionsButton = new SMenuButton();
        this.optionsButton.setVisible(false);
        this.optionsButton.setIcon(UIManager.getIcon("SideBar.optionsIcon"));
        this.optionsButton.setSelectedIcon(UIManager.getIcon("SideBar.optionsPressedIcon"));
        this.optionsButton.setPressedIcon(UIManager.getIcon("SideBar.optionsPressedIcon"));
        this.optionsButton.setRolloverIcon(UIManager.getIcon("SideBar.optionsPressedIcon"));
        this.optionsButton.setRolloverSelectedIcon(UIManager.getIcon("SideBar.optionsPressedIcon"));
        this.optionsButton.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.optionsButton.setCursor(Cursor.getPredefinedCursor(0));
        this.optionsButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_OPTIONSMENUTIP));
        this.optionsButton.setContentAreaFilled(false);
        this.optionsButton.setArrowPainted(false);
        this.optionsButton.setFocusPainted(false);
        MenuButtonFocusDisplayer fd = new MenuButtonFocusDisplayer();
        this.optionsButton.addFocusListener(fd);
        this.optionsButton.getMenu().addPopupMenuListener(fd);
        this.optionsButton.getMenu().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                SSideBarTitleBar.this.applyOptionsFont(e.getChild());
                SSideBarTitleBar.this.optionsButton.setVisible(true);
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (SSideBarTitleBar.this.optionsButton.getItemCount() == 0) {
                    SSideBarTitleBar.this.optionsButton.setVisible(false);
                }
            }
        });
        this.buttonBar.add(this.optionsButton);
        this.closeButton = new SButton();
        this.closeButton.setVisible(false);
        this.closeButton.setIcon(UIManager.getIcon("SideBar.closeIcon"));
        this.closeButton.setPressedIcon(UIManager.getIcon("SideBar.closeRolloverIcon"));
        this.closeButton.setRolloverIcon(UIManager.getIcon("SideBar.closeRolloverIcon"));
        this.closeButton.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 3));
        this.closeButton.setCursor(Cursor.getPredefinedCursor(0));
        this.closeButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_CLOSETIP, new Object[]{title}));
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setFocusPainted(false);
        this.closeButton.addFocusListener(new ButtonFocusDisplayer());
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSideBarTitleBar.this.sideBarPanel.setDocked(!SSideBarTitleBar.this.sideBarPanel.isDocked());
            }
        });
        this.buttonBar.add(this.closeButton);
        Font f = UIManager.getFont("PopupMenu.font");
        this.optionsFont = f.deriveFont((float)(f.getSize() * 11 / 12));
        sideBarPanel.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SSideBarTitleBar.this.updateExpanded((Boolean)e.getNewValue());
            }
        });
        sideBarPanel.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                SSideBarTitleBar.this.updateDocked((Boolean)e.getNewValue());
            }
        });
        this.updateAXInfo();
        this.updateExpanded(sideBarPanel.isExpanded());
        this.updateUI();
    }

    protected void removeExpandButton() {
        this.remove(this.expandButton);
    }

    protected void addExpandButton() {
        this.add((Component)this.expandButton, "West");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.titleLabel.setText(title != null ? title.toUpperCase() : null);
        this.updateToolTips();
        this.updateAXInfo();
    }

    private void updateToolTips() {
        String title = this.getTitle();
        if (this.expandButton.isSelected()) {
            this.expandButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_COLLAPSEBUTTONTIP, new Object[]{title}));
        } else {
            this.expandButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_EXPANDBUTTONTIP, new Object[]{title}));
        }
        this.closeButton.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_CLOSETIP, new Object[]{title}));
    }

    private void updateAXInfo() {
        String title = this.getTitle();
        this.expandButton.getAccessibleContext().setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_EXPAND_PANEL_AXNAME, new Object[]{title}));
        this.optionsButton.getAccessibleContext().setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_OPTIONSMENU_NAME, new Object[]{title}));
        this.optionsButton.getAccessibleContext().setAccessibleDescription(i18n.getString((PropertiesEnum)StringsProperties.SSIDEBARTITLEBAR_OPTIONSMENU_DESCRIPTION, new Object[]{title}));
    }

    public void addLabel(JLabel label) {
        label.setFont(UIManager.getFont("SideBar.titleFont"));
        label.setForeground(UIManager.getColor("SideBar.titleForeground"));
        this.titlePanel.add((Component)label, this.titleConstraints);
        this.updateLabelConstraints();
        this.titlePanel.revalidate();
    }

    public void removeLabel(JLabel label) {
        this.titlePanel.remove(label);
        this.updateLabelConstraints();
        this.titlePanel.revalidate();
    }

    private void updateLabelConstraints() {
        GridBagLayout l = (GridBagLayout)this.titlePanel.getLayout();
        Component[] cs = this.titlePanel.getComponents();
        Component last = null;
        if (cs != null && cs.length != 0) {
            last = cs[cs.length - 1];
        }
        for (Component c : cs) {
            GridBagConstraints gbc = l.getConstraints(c);
            gbc.weightx = c == last ? 1.0 : 0.0;
            l.setConstraints(c, gbc);
        }
    }

    private void updateExpanded(boolean expanded) {
        this.expandButton.setSelected(expanded);
        this.updateToolTips();
    }

    private void updateDocked(boolean docked) {
        this.closeButton.setVisible(!docked);
    }

    SMenuButton getOptionsButton() {
        return this.optionsButton;
    }

    public void addButton(AbstractButton button) {
        button.setBorder(BorderFactory.createEmptyBorder(2, 3, 2, 0));
        button.setContentAreaFilled(false);
        this.buttonBar.add((Component)button, 0);
        this.buttonBar.revalidate();
    }

    public void removeButton(AbstractButton button) {
        this.buttonBar.remove(button);
        this.buttonBar.revalidate();
    }

    private void applyOptionsFont(Component component) {
        component.setFont(this.optionsFont);
        if (component instanceof JMenu) {
            for (Component c : ((JMenu)component).getMenuComponents()) {
                this.applyOptionsFont(c);
            }
        }
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSSideBarTitleBar();
        }
        return this.accessibleContext;
    }

    private class AccessibleSSideBarTitleBar
    extends JComponent.AccessibleJComponent {
        private AccessibleSSideBarTitleBar() {
            super(SSideBarTitleBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

