/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;

public class SMenuButton
extends JButton {
    private static final String uiClassID = "SMenuButtonUI";
    protected JPopupMenu menu;
    private boolean menuVisible;
    private boolean arrowPainted = true;
    private boolean showMenuOnHover = false;
    private boolean hovered;
    private boolean mouseEntered;

    public SMenuButton() {
        this(null, null);
    }

    public SMenuButton(Icon icon) {
        this(null, icon);
    }

    public SMenuButton(String text) {
        this(text, null);
    }

    public SMenuButton(String text, Icon icon) {
        super(text, icon);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SMenuButton.this.menuVisible) {
                    SMenuButton.this.setMenuVisible(true);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SMenuButton.this.showMenuOnHover) {
                    if (!SMenuButton.this.menuVisible) {
                        SMenuButton.this.setMenuVisible(true);
                    }
                    SMenuButton.this.hovered = Boolean.TRUE;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SMenuButton.this.showMenuOnHover && SMenuButton.this.menuVisible) {
                    Timer t = new Timer(100, new HideMenuListener());
                    t.setRepeats(false);
                    t.start();
                }
            }
        });
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SMenuButton.this.menuVisible = true;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SMenuButton.this.menuVisible = false;
                SMenuButton.this.setSelected(false);
            }
        });
        this.menu.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SMenuButton.this.showMenuOnHover) {
                    SMenuButton.this.hovered = false;
                    SMenuButton.this.mouseEntered = true;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (SMenuButton.this.showMenuOnHover) {
                    SMenuButton.this.hideMenuOnMouseExit(e.getPoint());
                }
            }
        });
        this.getAccessibleContext().firePropertyChange("AccessibleChild", null, this.menu);
    }

    @Override
    public void setBorder(Border border) {
        Border b = this.getBorder();
        if (b == null || !(border instanceof UIResource) || b instanceof UIResource) {
            super.setBorder(border);
        }
    }

    public boolean isShowMenuOnHover() {
        return this.showMenuOnHover;
    }

    public void setShowMenuOnHover(boolean showMenuOnHover) {
        boolean old = this.showMenuOnHover;
        this.showMenuOnHover = showMenuOnHover;
        this.firePropertyChange("showMenuOnHover", old, showMenuOnHover);
    }

    private void hideMenuOnMouseExit(Point b) {
        Rectangle mb = this.menu.getBounds();
        int x = (int)b.getX();
        int y = (int)b.getY();
        if (this.mouseEntered && !this.menu.contains(x, y)) {
            this.setMenuVisible(false);
            this.mouseEntered = false;
        }
    }

    public void addItem(JComponent item) {
        this.menu.add(item);
    }

    public void addItem(JComponent item, int index) {
        this.menu.add((Component)item, index);
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public void addSeparator(int index) {
        this.menu.add((Component)new JPopupMenu.Separator(), index);
    }

    public void removeItem(JComponent item) {
        if (this.menu != null) {
            this.menu.remove(item);
        }
    }

    public void removeItem(int index) {
        if (this.menu != null && index >= 0 && index < this.menu.getComponentCount()) {
            this.menu.remove(index);
        }
    }

    public int getItemCount() {
        if (this.menu != null) {
            return this.menu.getComponentCount();
        }
        return 0;
    }

    public JComponent getItem(int index) {
        return (JComponent)this.menu.getComponent(index);
    }

    public int getItemIndex(JComponent item) {
        return this.menu.getComponentIndex(item);
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public boolean isMenuVisible() {
        return this.menuVisible;
    }

    public void setMenuVisible(boolean menuVisible) {
        this.setSelected(menuVisible);
        if (menuVisible) {
            this.showMenu();
        } else {
            this.hideMenu();
        }
    }

    protected void showMenu() {
        this.menu.show(this, 0, this.getHeight());
        this.menu.getAccessibleContext().firePropertyChange("AccessibleVisibleData", false, true);
    }

    protected void hideMenu() {
        this.menu.setVisible(false);
        this.menu.getAccessibleContext().firePropertyChange("AccessibleVisibleData", true, false);
    }

    public boolean isArrowPainted() {
        return this.arrowPainted;
    }

    public void setArrowPainted(boolean arrowPainted) {
        boolean old = this.arrowPainted;
        this.arrowPainted = arrowPainted;
        this.firePropertyChange("arrowPainted", old, arrowPainted);
    }

    @Override
    public String getUIClassID() {
        if (this.getClientProperty("Delegate.bypassGetUIClassID") != null) {
            return super.getUIClassID();
        }
        return uiClassID;
    }

    private class HideMenuListener
    implements ActionListener {
        private HideMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SMenuButton.this.hovered && SMenuButton.this.menu.isShowing()) {
                Rectangle mb = SMenuButton.this.menu.getBounds();
                Point mp = SMenuButton.this.menu.getLocationOnScreen();
                int mx = (int)mp.getX();
                int my = (int)mp.getY();
                Point b = MouseInfo.getPointerInfo().getLocation();
                int x = (int)b.getX();
                int y = (int)b.getY();
                if (x < mx || x >= mx + mb.width) {
                    SMenuButton.this.setMenuVisible(false);
                    SMenuButton.this.hovered = false;
                } else if (y < my || y >= my + mb.height) {
                    SMenuButton.this.setMenuVisible(false);
                    SMenuButton.this.hovered = false;
                }
            }
        }
    }
}

