/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.MenuButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.gui.swing.CTextField;
import com.elluminate.platform.Platform;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class SActionBar
extends JComponent
implements Accessible {
    private static final String uiClassID = "SActionBarUI";
    private static final String ORDER_PROPERTY = "__order__";
    private GridBagConstraints defaultConstraints;
    private GridBagConstraints iconButtonConstraints;
    private GridBagConstraints textComponentConstraints;
    private SMenuButton optionsButton;
    private ComponentListener optionListener;
    private Font optionsFont;
    private Font font;
    private Font underlineFont;
    private MouseListener hoverListener;
    private FocusListener focusListener;

    public SMenuButton getOptionsButton() {
        return this.optionsButton;
    }

    public SActionBar() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 10;
        this.optionsButton = new SMenuButton();
        this.optionsButton.setVisible(false);
        this.optionsButton.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.optionsButton.setIcon(UIManager.getIcon("ActionBar.optionsIcon"));
        this.optionsButton.setSelectedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setPressedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setRolloverIcon(UIManager.getIcon("ActionBar.optionsRolloverIcon"));
        this.optionsButton.setRolloverSelectedIcon(UIManager.getIcon("ActionBar.optionsPressedIcon"));
        this.optionsButton.setContentAreaFilled(false);
        this.optionsButton.setArrowPainted(false);
        MenuButtonFocusDisplayer fd = new MenuButtonFocusDisplayer();
        this.optionsButton.addFocusListener(fd);
        this.optionsButton.getMenu().addPopupMenuListener(fd);
        this.optionsButton.getMenu().addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                c.setFont(SActionBar.this.optionsFont);
                c.addComponentListener(SActionBar.this.optionListener);
                if (c.isVisible()) {
                    SActionBar.this.optionsButton.setVisible(true);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                c.removeComponentListener(SActionBar.this.optionListener);
                if (SActionBar.this.hasVisibleOptions()) {
                    SActionBar.this.optionsButton.setVisible(false);
                }
            }
        });
        this.setupOptionsMenuKeyBinding();
        super.addImpl(this.optionsButton, gbc, -1);
        this.optionListener = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SActionBar.this.optionsButton.setVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                if (SActionBar.this.hasVisibleOptions()) {
                    SActionBar.this.optionsButton.setVisible(false);
                }
            }
        };
        this.defaultConstraints = new GridBagConstraints();
        this.defaultConstraints.insets.left = 8;
        this.defaultConstraints.insets.right = 8;
        this.iconButtonConstraints = new GridBagConstraints();
        this.textComponentConstraints = new GridBagConstraints();
        this.textComponentConstraints.insets.top = 4;
        this.textComponentConstraints.insets.left = 8;
        this.textComponentConstraints.insets.bottom = 4;
        this.textComponentConstraints.insets.right = 8;
        Font f = UIManager.getFont("PopupMenu.font");
        this.optionsFont = f.deriveFont((float)(f.getSize() * 11 / 12));
        f = UIManager.getFont("Button.font");
        this.font = f.deriveFont((float)f.getSize() * 11.0f / 12.0f);
        HashMap<TextAttribute, Integer> attrs = new HashMap<TextAttribute, Integer>();
        attrs.put(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        this.underlineFont = this.font.deriveFont(attrs);
        this.hoverListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SActionBar.this.applyUnderline(e.getComponent());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SActionBar.this.removeUnderline(e.getComponent());
            }
        };
        this.focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SActionBar.this.applyUnderline(e.getComponent());
            }

            @Override
            public void focusLost(FocusEvent e) {
                SActionBar.this.removeUnderline(e.getComponent());
            }
        };
        this.setFocusable(false);
        this.updateUI();
    }

    private void setupOptionsMenuKeyBinding() {
        KeyStroke optionsKeystroke = this.getOptionsKeystroke();
        String actionName = "open.options.menu." + this.hashCode();
        this.getInputMap(1).put(optionsKeystroke, actionName);
        this.getActionMap().put(actionName, new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                SActionBar.this.optionsButton.doClick();
            }
        });
    }

    private KeyStroke getOptionsKeystroke() {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(79, mask | 0x40);
    }

    public JPopupMenu getOptionsMenu() {
        return this.optionsButton.getMenu();
    }

    private boolean hasVisibleOptions() {
        for (Component c : this.optionsButton.getMenu().getComponents()) {
            if (!c.isVisible()) continue;
            return true;
        }
        return false;
    }

    public synchronized void add(JComponent component, float order) {
        Component testC;
        float o;
        int index;
        component.putClientProperty(ORDER_PROPERTY, Float.valueOf(order));
        for (index = 0; index < this.getComponentCount() && !((o = this.getItemOrder(testC = this.getComponent(index))) > order); ++index) {
        }
        super.add((Component)component, index);
    }

    private float getItemOrder(Component item) {
        Object prop;
        if (item instanceof JComponent && (prop = ((JComponent)item).getClientProperty(ORDER_PROPERTY)) instanceof Number) {
            return ((Number)prop).floatValue();
        }
        return 1000.0f;
    }

    @Override
    protected void addImpl(Component component, Object constraints, int index) {
        if (Platform.getLAF() == 502 && component instanceof JComponent) {
            ((JComponent)component).putClientProperty("JComponent.sizeVariant", "small");
        }
        component.setFont(this.font);
        if (component instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)component;
            b.setForeground(UIManager.getColor("ActionBar.foreground"));
            if (b.getIcon() == null) {
                b.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
                b.setContentAreaFilled(false);
                b.addMouseListener(this.hoverListener);
                b.addFocusListener(this.focusListener);
                b.setCursor(Cursor.getPredefinedCursor(12));
            } else if (b.getText() == null || b.getText().length() == 0) {
                b.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
                b.setContentAreaFilled(false);
            }
        } else if (component instanceof JTextComponent) {
            JTextComponent tf = (JTextComponent)component;
            boolean customForegroundColor = false;
            boolean customBackgroundColor = false;
            if (tf instanceof CTextField) {
                CTextField ctf = (CTextField)tf;
                customBackgroundColor = ctf.isCustomBackgroundColor();
                customForegroundColor = ctf.isCustomForegroundColor();
            }
            if (!customForegroundColor) {
                tf.setForeground(UIManager.getColor("ActionBar.foreground"));
                tf.setForeground(UIManager.getColor("ActionBar.darkerForeground"));
            }
            if (!customBackgroundColor) {
                tf.setBackground(UIManager.getColor("ActionBar.lighterBackground"));
            }
            tf.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("ActionBar.textFieldOutlineColor"), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        } else if (component instanceof JComboBox) {
            ((JComboBox)component).setMaximumRowCount(35);
        }
        if (!(constraints instanceof GridBagConstraints)) {
            if (component instanceof JTextField) {
                constraints = this.textComponentConstraints;
            } else if (component instanceof JComboBox) {
                constraints = this.textComponentConstraints;
                GridBagConstraints gbc = (GridBagConstraints)this.textComponentConstraints.clone();
                if (Platform.getLAF() == 502) {
                    gbc.insets.top = -1;
                    gbc.insets.bottom = -2;
                } else {
                    gbc.insets.top = 0;
                    gbc.insets.bottom = 0;
                }
                constraints = gbc;
            } else {
                constraints = component instanceof AbstractButton && (((AbstractButton)component).getText() == null || ((AbstractButton)component).getText().length() == 0) && ((AbstractButton)component).getIcon() != null ? this.iconButtonConstraints : this.defaultConstraints;
            }
        }
        if (index == -1) {
            index = this.getComponentCount() - 1;
        }
        super.addImpl(component, constraints, index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Component c;
            if (index < this.getComponentCount() && (c = this.getComponent(index)) instanceof AbstractButton) {
                c.removeMouseListener(this.hoverListener);
                c.removeFocusListener(this.focusListener);
            }
        }
        super.remove(index);
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    private void applyUnderline(Component c) {
        c.setFont(this.underlineFont);
        c.repaint();
    }

    private void removeUnderline(Component c) {
        c.setFont(this.font);
        c.repaint();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSActionBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSActionBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleSActionBar() {
            super(SActionBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

