/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.chat;

import com.elluminate.util.ArraySet;
import com.elluminate.util.StringUtils;
import com.google.inject.Singleton;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

@Singleton
public class EmoticonSupport {
    private static Map<String, String> shortcutToLFNameMap;
    private static Map<String, String> escapedShortcutToLFNameMap;
    private static Set<String> sortedShortcutSet;
    private static Set<String> escapedShortcutSet;
    private static Set<String> locationNameSet;
    private static String shortcutCapturePattern;

    EmoticonSupport() {
        LinkedHashMap<String, String> slfMap = new LinkedHashMap<String, String>();
        slfMap.put(":)", "Chat.smileyEmoticon");
        slfMap.put(":-)", "Chat.smileyEmoticon");
        slfMap.put(";)", "Chat.winkEmoticon");
        slfMap.put(";-)", "Chat.winkEmoticon");
        slfMap.put(":(", "Chat.sadEmoticon");
        slfMap.put(":-(", "Chat.sadEmoticon");
        slfMap.put("(re)", "Chat.eyeRollEmoticon");
        slfMap.put("B)", "Chat.coolEmoticon");
        slfMap.put("B-)", "Chat.coolEmoticon");
        slfMap.put(":p", "Chat.tongueEmoticon");
        slfMap.put(":-p", "Chat.tongueEmoticon");
        slfMap.put(":o", "Chat.surprisedEmoticon");
        slfMap.put(":-o", "Chat.surprisedEmoticon");
        slfMap.put(":'(", "Chat.cryingEmoticon");
        slfMap.put(":/", "Chat.confusedEmoticon");
        slfMap.put(":-/", "Chat.confusedEmoticon");
        slfMap.put(":D", "Chat.grinEmoticon");
        slfMap.put(":-D", "Chat.grinEmoticon");
        slfMap.put(":@", "Chat.angryEmoticon");
        slfMap.put(":-@", "Chat.angryEmoticon");
        slfMap.put("(6)", "Chat.evilEmoticon");
        slfMap.put(":*", "Chat.kissEmoticon");
        slfMap.put(":-*", "Chat.kissEmoticon");
        slfMap.put("<3", "Chat.heartEmoticon");
        slfMap.put("(l)", "Chat.heartEmoticon");
        slfMap.put("</3", "Chat.brokenHeartEmoticon");
        slfMap.put("(u)", "Chat.brokenHeartEmoticon");
        slfMap.put("(shazam)", "Chat.lightningEmoticon");
        slfMap.put("(p)", "Chat.reportEmoticon");
        slfMap.put("(e)", "Chat.emailEmoticon");
        slfMap.put("(s)", "Chat.openBookEmoticon");
        slfMap.put("(ns)", "Chat.bookEmoticon");
        slfMap.put("(#)", "Chat.chartEmoticon");
        slfMap.put("(+)", "Chat.clockEmoticon");
        slfMap.put("(c)", "Chat.coffeeEmoticon");
        slfMap.put("(hb)", "Chat.birthdayEmoticon");
        slfMap.put("(t)", "Chat.telephoneEmoticon");
        slfMap.put("(tv)", "Chat.televisionEmoticon");
        slfMap.put("(m)", "Chat.musicEmoticon");
        slfMap.put("(01)", "Chat.computerEmoticon");
        slfMap.put("(i)", "Chat.iPodEmoticon");
        slfMap.put("(g)", "Chat.gameEmoticon");
        slfMap.put("(w)", "Chat.webcamEmoticon");
        slfMap.put(":[", "Chat.batEmoticon");
        slfMap.put("(z)", "Chat.manEmoticon");
        slfMap.put("(x)", "Chat.womanEmoticon");
        slfMap.put("(f)", "Chat.groupEmoticon");
        slfMap.put("(cc)", "Chat.creditEmoticon");
        slfMap.put("($)", "Chat.moneyEmoticon");
        slfMap.put("(!)", "Chat.alertEmoticon");
        slfMap.put("(eye)", "Chat.eyeEmoticon");
        slfMap.put("(a)", "Chat.carEmoticon");
        slfMap.put("(xy)", "Chat.maleEmoticon");
        slfMap.put("(xx)", "Chat.femaleEmoticon");
        slfMap.put("(1)", "Chat.soccerEmoticon");
        slfMap.put("(2)", "Chat.footballEmoticon");
        slfMap.put("(3)", "Chat.basketballEmoticon");
        slfMap.put("(8)", "Chat.8BallEmoticon");
        slfMap.put("(h)", "Chat.houseEmoticon");
        slfMap.put("(zz)", "Chat.sleepEmoticon");
        slfMap.put("(n)", "Chat.thumbsDownEmoticon");
        slfMap.put("(y)", "Chat.thumbsUpEmoticon");
        slfMap.put("(su)", "Chat.sunEmoticon");
        slfMap.put("(ts)", "Chat.cloudEmoticon");
        slfMap.put("(rn)", "Chat.rainEmoticon");
        slfMap.put("(sn)", "Chat.snowEmoticon");
        slfMap.put("(r)", "Chat.rainbowEmoticon");
        slfMap.put("(*)", "Chat.starEmoticon");
        shortcutToLFNameMap = Collections.unmodifiableMap(slfMap);
        locationNameSet = Collections.unmodifiableSet(new ArraySet(slfMap.values()));
        escapedShortcutToLFNameMap = new LinkedHashMap<String, String>(shortcutToLFNameMap.size());
        for (Map.Entry<String, String> entry : shortcutToLFNameMap.entrySet()) {
            escapedShortcutToLFNameMap.put(StringUtils.htmlEscape((String)entry.getKey()), entry.getValue());
        }
        escapedShortcutSet = Collections.unmodifiableSet(escapedShortcutToLFNameMap.keySet());
        ArrayList<String> shortcutList = new ArrayList<String>(shortcutToLFNameMap.keySet());
        Collections.sort(shortcutList, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s2.length() - s1.length();
            }
        });
        sortedShortcutSet = Collections.unmodifiableSet(new ArraySet(shortcutList));
        String preamble = "(?i)(";
        StringBuilder sb = new StringBuilder("(?i)(");
        for (String sc : sortedShortcutSet) {
            if (sb.length() != "(?i)(".length()) {
                sb.append('|');
            }
            sb.append(Pattern.quote(sc));
        }
        sb.append(')');
        shortcutCapturePattern = sb.toString();
    }

    public String imagePathForShortcut(String shortcut, ShortcutType type) {
        Map<String, String> lfNameMap = type == ShortcutType.HTML_ESCAPED_TEXT ? escapedShortcutToLFNameMap : shortcutToLFNameMap;
        String location = null;
        for (String sc : this.getShortcutSet(type)) {
            if (!sc.equalsIgnoreCase(shortcut)) continue;
            location = UIManager.getString(lfNameMap.get(sc));
            break;
        }
        return location;
    }

    public Icon getIconForShortcut(String shortcut, ShortcutType type) {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(new URL(this.imagePathForShortcut(shortcut, type)));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return icon;
    }

    public Set<String> getShortcutSet(ShortcutType type) {
        return type == ShortcutType.HTML_ESCAPED_TEXT ? escapedShortcutSet : sortedShortcutSet;
    }

    public Pattern getShortcutCapturePattern(ShortcutType type) {
        return Pattern.compile(type == ShortcutType.HTML_ESCAPED_TEXT ? StringUtils.htmlEscape((String)shortcutCapturePattern) : shortcutCapturePattern);
    }

    public String getFirstShortcutForEmoticonName(String name) {
        String shortcut = null;
        Iterator<Map.Entry<String, String>> it = shortcutToLFNameMap.entrySet().iterator();
        while (it.hasNext() && shortcut == null) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getValue().equalsIgnoreCase(name)) continue;
            shortcut = entry.getKey();
        }
        return shortcut;
    }

    public Set<String> getEmoticonNameSet() {
        return locationNameSet;
    }

    public String getDescriptionFromName(String name) {
        if (name == null) {
            return name;
        }
        String sub = name.substring(0, name.indexOf(".") + 1);
        if (sub != null) {
            name = name.replace(sub, "");
        }
        name = name.replace("Emoticon", "");
        return name.replaceAll(String.format(Locale.ENGLISH, "%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ");
    }

    public static enum ShortcutType {
        HTML_ESCAPED_TEXT,
        RAW_TEXT;

    }
}

