/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.components.SPalette;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

class StageContentCard
extends JComponent
implements Accessible {
    private Map<Component, SPalette> palettes = new HashMap<Component, SPalette>();
    private StageContentLayout layout = new StageContentLayout();
    private ComponentListener paletteListener;

    public StageContentCard() {
        this.setLayout(this.layout);
        this.paletteListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                StageContentCard.this.layout.checkGlued((SPalette)e.getComponent(), StageContentCard.this);
            }
        };
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return this.palettes.isEmpty();
    }

    public void addContent(Component content) {
        this.add(content);
        this.revalidate();
    }

    public void removeContent(Component content) {
        this.remove(content);
        this.revalidate();
    }

    public void addPalette(Component palette, int orientation, Component relativeTo) {
        SPalette p2;
        SPalette p = new SPalette(palette, orientation);
        p.addComponentListener(this.paletteListener);
        if (relativeTo != null && relativeTo != palette && (p2 = this.palettes.get(relativeTo)) != null) {
            p.putClientProperty(StageContentLayout.POSITION_RELATIVE_TO, p2);
        }
        this.palettes.put(palette, p);
        this.add((Component)p, 0);
        this.revalidate();
        this.repaint();
    }

    public void removePalette(Component palette) {
        SPalette p = this.palettes.get(palette);
        if (p != null) {
            StageContentLayout l = (StageContentLayout)this.getLayout();
            if (p.getOrientation() == 1) {
                l.setNextVerticalPaletteLocation(p.getLocation());
            } else {
                l.setNextHorizontalPaletteLocation(p.getLocation());
            }
            this.palettes.remove(palette);
            this.remove(p);
            p.removeComponentListener(this.paletteListener);
            this.layout.checkGlued(p, this);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStageContentCard();
        }
        return this.accessibleContext;
    }

    class AccessibleStageContentCard
    extends JComponent.AccessibleJComponent {
        AccessibleStageContentCard() {
            super(StageContentCard.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static class StageContentLayout
    implements LayoutManager {
        private static final Object PALETTE_PLACED = new Object();
        private static final Object POSITION_RELATIVE_TO = new Object();
        private Point nextVerticalPaletteLocation;
        private Point nextHorizontalPaletteLocation;
        private Map<SPalette, Glue> glues = new HashMap<SPalette, Glue>();

        private StageContentLayout() {
        }

        public void setNextVerticalPaletteLocation(Point nextVerticalPaletteLocation) {
            this.nextVerticalPaletteLocation = nextVerticalPaletteLocation;
        }

        public void setNextHorizontalPaletteLocation(Point nextHorizontalPaletteLocation) {
            this.nextHorizontalPaletteLocation = nextHorizontalPaletteLocation;
        }

        public void checkGlued(SPalette palette, Container container) {
            if (!SwingUtilities.isDescendingFrom(palette, container)) {
                this.glues.remove(palette);
            } else {
                boolean right;
                Dimension s = container.getSize();
                Insets ins = container.getInsets();
                Rectangle b = palette.getBounds();
                boolean bottom = b.y + b.height >= s.height - ins.bottom;
                boolean bl = right = b.x + b.width >= s.width - ins.right;
                if (bottom && right) {
                    this.glues.put(palette, Glue.BOTTOM_RIGHT);
                } else if (bottom) {
                    this.glues.put(palette, Glue.BOTTOM);
                } else if (right) {
                    this.glues.put(palette, Glue.RIGHT);
                } else {
                    this.glues.remove(palette);
                }
            }
        }

        @Override
        public void addLayoutComponent(String name, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension ps = new Dimension();
                for (Component c : container.getComponents()) {
                    if (c instanceof SPalette) continue;
                    Dimension s = c.getPreferredSize();
                    ps.width = s.width;
                    ps.height = s.height;
                    break;
                }
                return ps;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension ms = new Dimension();
                for (Component c : container.getComponents()) {
                    if (c instanceof SPalette) continue;
                    Dimension s = c.getMinimumSize();
                    ms.width = s.width;
                    ms.height = s.height;
                    break;
                }
                return ms;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Dimension s = container.getSize();
                Insets ins = container.getInsets();
                boolean contentPlaced = false;
                for (Component c : container.getComponents()) {
                    if (c instanceof SPalette) {
                        SPalette p = (SPalette)c;
                        Dimension ps = p.getPreferredSize();
                        Point pos = p.getLocation();
                        if (p.getClientProperty(PALETTE_PLACED) == null && s.width > 0 && s.height > 0) {
                            Dimension ts;
                            Point loc;
                            p.putClientProperty(PALETTE_PLACED, true);
                            SPalette relTo = (SPalette)p.getClientProperty(POSITION_RELATIVE_TO);
                            if (relTo != null) {
                                p.putClientProperty(POSITION_RELATIVE_TO, null);
                            }
                            if (p.getOrientation() == 1) {
                                loc = this.nextVerticalPaletteLocation;
                                this.nextVerticalPaletteLocation = null;
                                if (loc != null) {
                                    pos.x = loc.x;
                                    pos.y = loc.y;
                                } else if (relTo != null) {
                                    ts = p.getTargetLayoutSize();
                                    this.setPositionRelativeTo(pos, ts, s, ins, relTo);
                                } else {
                                    pos.x = ins.left;
                                    pos.y = (s.height - ins.bottom - ps.height) / 2;
                                }
                            } else {
                                loc = this.nextHorizontalPaletteLocation;
                                this.nextHorizontalPaletteLocation = null;
                                if (loc != null) {
                                    pos.x = loc.x;
                                    pos.y = loc.y;
                                } else if (relTo != null) {
                                    ts = p.getTargetLayoutSize();
                                    this.setPositionRelativeTo(pos, ts, s, ins, relTo);
                                } else {
                                    pos.x = ins.left + 80;
                                    pos.y = s.height - ins.bottom - ps.height;
                                }
                            }
                            this.checkGlued(p, container);
                        } else if (this.glues.containsKey(p)) {
                            switch (this.glues.get(p)) {
                                case BOTTOM: {
                                    pos.y = s.height - ins.bottom - ps.height;
                                    break;
                                }
                                case RIGHT: {
                                    pos.x = s.width - ins.right - ps.width;
                                    break;
                                }
                                case BOTTOM_RIGHT: {
                                    pos.x = s.width - ins.right - ps.width;
                                    pos.y = s.height - ins.bottom - ps.height;
                                }
                            }
                        }
                        Rectangle b = new Rectangle(pos, ps);
                        if (b.x + b.width > s.width - ins.right) {
                            b.x = s.width - ins.right - b.width;
                        }
                        if (b.x < ins.left) {
                            b.x = ins.left;
                        }
                        if (b.y + b.height > s.height - ins.bottom) {
                            b.y = s.height - ins.bottom - b.height;
                        }
                        if (b.y < ins.top) {
                            b.y = ins.top;
                        }
                        p.setBounds(b);
                        continue;
                    }
                    if (!contentPlaced) {
                        c.setBounds(ins.left, ins.top, s.width - ins.left - ins.right, s.height - ins.top - ins.bottom);
                        contentPlaced = true;
                        continue;
                    }
                    c.setBounds(0, -1000, 0, 0);
                }
            }
        }

        private void setPositionRelativeTo(Point pos, Dimension ps, Dimension s, Insets ins, SPalette relTo) {
            Rectangle srcBounds = relTo.getBounds();
            int left = ins.left;
            int top = ins.top;
            int right = s.width - ins.right;
            int bottom = s.height - ins.bottom;
            if (relTo.getOrientation() == 1) {
                if (srcBounds.x + ps.width <= right) {
                    pos.x = srcBounds.x;
                    if (srcBounds.y + srcBounds.height + 3 + ps.height <= bottom) {
                        pos.y = srcBounds.y + srcBounds.height + 3;
                    } else if (srcBounds.x + srcBounds.width + ps.width + 3 <= right) {
                        pos.x = srcBounds.x + srcBounds.width + 3;
                        pos.y = srcBounds.y + srcBounds.height - ps.height;
                    } else {
                        pos.y = srcBounds.y - ps.height - 3;
                    }
                } else if (srcBounds.x + srcBounds.width - ps.width >= left) {
                    pos.x = srcBounds.x + srcBounds.width - ps.width;
                    if (srcBounds.y + srcBounds.height + 3 + ps.height <= bottom) {
                        pos.y = srcBounds.y + srcBounds.height + 3;
                    } else if (srcBounds.x - ps.width - 3 >= left) {
                        pos.x = srcBounds.x - ps.width - 3;
                        pos.y = srcBounds.y + srcBounds.height - ps.height;
                    } else {
                        pos.y = srcBounds.y - ps.height - 3;
                    }
                } else {
                    pos.x = (left + right - ps.width + 1) / 2;
                    pos.y = srcBounds.y + srcBounds.height + 3 + ps.height <= bottom ? srcBounds.y + srcBounds.height + 3 : srcBounds.y - ps.height - 3;
                }
            } else if (srcBounds.y + ps.height <= bottom) {
                pos.y = srcBounds.y;
                if (srcBounds.x - ps.width - 3 >= left) {
                    pos.x = srcBounds.x - ps.width - 3;
                } else if (srcBounds.y + srcBounds.height + ps.height + 3 <= bottom) {
                    pos.y = srcBounds.y + srcBounds.height + 3;
                    pos.x = srcBounds.x;
                } else {
                    pos.x = srcBounds.x + srcBounds.width + 3;
                }
            } else if (srcBounds.y + srcBounds.height - ps.height >= top) {
                pos.y = srcBounds.y + srcBounds.height - ps.height;
                if (srcBounds.x - ps.width - 3 >= left) {
                    pos.x = srcBounds.x - ps.width - 3;
                } else if (srcBounds.y - ps.height - 3 >= top) {
                    pos.y = srcBounds.y - ps.height - 3;
                    pos.x = srcBounds.x;
                } else {
                    pos.x = srcBounds.x + srcBounds.width + 3;
                }
            } else {
                pos.y = (top + bottom - ps.height + 1) / 2;
                pos.x = srcBounds.x - ps.width - 3 >= left ? srcBounds.x - ps.width - 3 : srcBounds.x + srcBounds.width + 3;
            }
        }

        private static enum Glue {
            BOTTOM,
            RIGHT,
            BOTTOM_RIGHT;

        }
    }
}

