/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.components.SActionBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.Timer;

class StageActionCard
extends JComponent
implements ContainerListener,
FocusListener,
MouseListener,
ActionListener,
Accessible {
    private static final long DURATION = 250L;
    private static final int SHOW_BUILD_OUT_DELAY = 4000;
    private static final int MOUSE_BUILD_OUT_DELAY = 2000;
    private boolean hiding = true;
    private State state = State.IN;
    private long startTime;
    private long endTime;
    private final Timer timer = new Timer(0, this);
    private Object timerLock = new Object();

    public StageActionCard(SActionBar actionBar) {
        this.addMouseListener(this);
        this.addContainerListener(this);
        super.add(actionBar);
    }

    public boolean isHiding() {
        return this.hiding;
    }

    public void setHiding(boolean hiding) {
        this.hiding = hiding;
        if (this.isVisible()) {
            if (hiding) {
                this.componentExited();
            } else {
                this.componentEntered();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = new Dimension();
        SActionBar ab = (SActionBar)this.getComponent(0);
        Dimension s = ab.getPreferredSize();
        ps.width = s.width;
        ps.height = s.height;
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        SActionBar ab = (SActionBar)this.getComponent(0);
        Dimension ps = ab.getPreferredSize();
        long now = System.currentTimeMillis();
        Object object = this.timerLock;
        synchronized (object) {
            switch (this.state) {
                case IN: 
                case WAITING_FOR_BUILD_OUT: {
                    ab.setBounds(2, 0, ps.width, ps.height);
                    break;
                }
                case BUILDING_OUT: {
                    float factor = (float)(now - this.startTime) / (float)(this.endTime - this.startTime);
                    if ((double)factor >= 1.0) {
                        this.state = State.OUT;
                        this.timer.stop();
                        ab.setBounds(2, -ps.height, ps.width, ps.height);
                        break;
                    }
                    int y = this.interpolate(0, -ps.height, factor);
                    ab.setBounds(2, y, ps.width, ps.height);
                    break;
                }
                case OUT: {
                    ab.setBounds(2, -ps.height, ps.width, ps.height);
                    break;
                }
                case BUILDING_IN: {
                    float factor = (float)(now - this.startTime) / (float)(this.endTime - this.startTime);
                    if ((double)factor >= 1.0) {
                        this.state = State.IN;
                        this.timer.stop();
                        ab.setBounds(2, 0, ps.width, ps.height);
                        break;
                    }
                    int y = this.interpolate(-ps.height, 0, factor);
                    ab.setBounds(2, y, ps.width, ps.height);
                }
            }
        }
    }

    private int interpolate(int min, int max, float timeFactor) {
        float f = timeFactor < 0.5f ? 2.0f * timeFactor * timeFactor : 1.0f - 2.0f * (1.0f - timeFactor) * (1.0f - timeFactor);
        return Math.round((float)min + f * (float)(max - min));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.hiding && this.isVisible()) {
            this.waitForBuildOut(4000);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.hiding && visible && this.getPeer() != null) {
            this.waitForBuildOut(4000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildIn() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.state == State.BUILDING_OUT) {
                long now = System.currentTimeMillis();
                this.startTime = now - (this.endTime - now);
            } else {
                this.startTime = System.currentTimeMillis();
            }
            this.endTime = this.startTime + 250L;
            this.state = State.BUILDING_IN;
            this.timer.stop();
            this.timer.setInitialDelay(0);
            this.timer.setDelay(33);
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBuildOut(int delay) {
        Object object = this.timerLock;
        synchronized (object) {
            this.state = State.WAITING_FOR_BUILD_OUT;
            this.timer.stop();
            this.timer.setInitialDelay(delay);
            this.timer.setDelay(0);
            this.timer.setRepeats(false);
            this.timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWaitingForBuildOut() {
        Object object = this.timerLock;
        synchronized (object) {
            this.state = State.IN;
            this.timer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildOut() {
        Object object = this.timerLock;
        synchronized (object) {
            if (this.state == State.BUILDING_IN) {
                long now = System.currentTimeMillis();
                this.startTime = now - (this.endTime - now);
            } else {
                this.startTime = System.currentTimeMillis();
            }
            this.endTime = this.startTime + 250L;
            this.state = State.BUILDING_OUT;
            this.timer.stop();
            this.timer.setInitialDelay(0);
            this.timer.setDelay(30);
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    private void componentEntered() {
        switch (this.state) {
            case BUILDING_OUT: 
            case OUT: {
                this.buildIn();
                break;
            }
            case WAITING_FOR_BUILD_OUT: {
                this.stopWaitingForBuildOut();
            }
        }
    }

    private void componentExited() {
        switch (this.state) {
            case IN: {
                this.waitForBuildOut(2000);
                break;
            }
            case BUILDING_IN: {
                this.buildOut();
            }
        }
    }

    private void componentAdded(Component component) {
        component.addMouseListener(this);
        component.addFocusListener(this);
        if (component instanceof Container) {
            Container co = (Container)component;
            co.addContainerListener(this);
            for (Component c : co.getComponents()) {
                this.componentAdded(c);
            }
        }
    }

    private void componentRemoved(Component component) {
        component.removeMouseListener(this);
        component.removeFocusListener(this);
        if (component instanceof Container) {
            Container co = (Container)component;
            co.removeContainerListener(this);
            for (Component c : co.getComponents()) {
                this.componentRemoved(c);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.componentAdded(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.componentRemoved(e.getChild());
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.hiding) {
            this.componentEntered();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.hiding) {
            this.componentExited();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.hiding) {
            this.componentEntered();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hiding) {
            this.componentExited();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.state) {
            case WAITING_FOR_BUILD_OUT: {
                this.buildOut();
                break;
            }
            case BUILDING_OUT: 
            case BUILDING_IN: {
                this.revalidate();
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleStageActionCard();
        }
        return this.accessibleContext;
    }

    class AccessibleStageActionCard
    extends JComponent.AccessibleJComponent {
        AccessibleStageActionCard() {
            super(StageActionCard.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static enum State {
        IN,
        WAITING_FOR_BUILD_OUT,
        BUILDING_OUT,
        OUT,
        BUILDING_IN;

    }
}

