/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.ArrowNavigation;
import com.elluminate.classroom.swing.ModeController;
import com.elluminate.classroom.swing.NavigationPanel;
import com.elluminate.classroom.swing.StageActionCard;
import com.elluminate.classroom.swing.StageContentCard;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.TopFocusReceiver;
import com.elluminate.classroom.swing.components.SActionBar;
import com.elluminate.classroom.swing.components.SStage;
import com.elluminate.classroom.swing.location.StageLocationHandler;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

@Singleton
public class Stage
extends SStage
implements TopFocusReceiver {
    private static final String WHITEBOARD_CARD = "whiteboard";
    private static final String SCREEN_SHARING_CARD = "screenSharing";
    private static final String WEB_TOUR_CARD = "webTour";
    private static final String QUIZ_CARD = "quiz";
    private CardLayout actionLayout;
    private JPanel actionPanel;
    private SActionBar whiteboardActionBar;
    private SActionBar screenSharingActionBar;
    private SActionBar webTourActionBar;
    private SActionBar quizActionBar;
    private JPanel navigationPanel;
    private NavigationPanel navigationBar;
    private StageContentCard whiteboardContentCard;
    private StageContentCard screenSharingContentCard;
    private StageContentCard webTourContentCard;
    private StageContentCard quizContentCard;
    private CardLayout centerLayout;
    private JPanel centerPanel;
    private I18n i18n;

    public Stage() {
        this.setLayout(new BorderLayout(0, 4));
        JPanel northPanel = new JPanel(new BorderLayout(4, 0));
        northPanel.setOpaque(false);
        this.add((Component)northPanel, "North");
        this.actionLayout = new CardLayout();
        this.actionPanel = new JPanel(this.actionLayout);
        this.actionPanel.setOpaque(false);
        northPanel.add((Component)this.actionPanel, "Center");
        this.navigationPanel = new JPanel(new BorderLayout()){
            private final int MAX_WIDTH = 400;
            {
                this.MAX_WIDTH = 400;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension ps = super.getPreferredSize();
                if (ps.width > 400) {
                    ps = new Dimension(400, ps.height);
                }
                return ps;
            }
        };
        this.navigationPanel.setOpaque(false);
        northPanel.add((Component)this.navigationPanel, "East");
        this.centerLayout = new CardLayout();
        this.centerPanel = new JPanel(this.centerLayout);
        this.centerPanel.setOpaque(false);
        this.add((Component)this.centerPanel, "Center");
        this.whiteboardActionBar = new SActionBar();
        StageActionCard c = new StageActionCard(this.whiteboardActionBar);
        c.setHiding(false);
        this.actionPanel.add((Component)c, WHITEBOARD_CARD);
        this.screenSharingActionBar = new SActionBar();
        c = new StageActionCard(this.screenSharingActionBar);
        c.setHiding(false);
        this.actionPanel.add((Component)c, SCREEN_SHARING_CARD);
        this.webTourActionBar = new SActionBar();
        c = new StageActionCard(this.webTourActionBar);
        c.setHiding(false);
        this.actionPanel.add((Component)c, WEB_TOUR_CARD);
        this.quizActionBar = new SActionBar();
        c = new StageActionCard(this.quizActionBar);
        c.setHiding(false);
        this.actionPanel.add((Component)c, QUIZ_CARD);
        ArrowNavigation.install(this.whiteboardActionBar);
        ArrowNavigation.install(this.screenSharingActionBar);
        ArrowNavigation.install(this.webTourActionBar);
        ArrowNavigation.install(this.quizActionBar);
        this.whiteboardContentCard = new StageContentCard();
        this.centerPanel.add((Component)this.whiteboardContentCard, WHITEBOARD_CARD);
        this.screenSharingContentCard = new StageContentCard();
        this.centerPanel.add((Component)this.screenSharingContentCard, SCREEN_SHARING_CARD);
        this.webTourContentCard = new StageContentCard();
        this.centerPanel.add((Component)this.webTourContentCard, WEB_TOUR_CARD);
        this.quizContentCard = new StageContentCard();
        this.centerPanel.add((Component)this.quizContentCard, QUIZ_CARD);
    }

    @Inject
    public void initNavigationBar(NavigationPanel navigationBar) {
        this.navigationBar = navigationBar;
        this.navigationPanel.add((Component)navigationBar, "North");
    }

    @Inject
    public void initModeController(ModeController modeController) {
        modeController.addModeChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent e) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ViewMode mode = (ViewMode)e.getNewValue();
                        Stage.this.updateMode(mode);
                    }
                });
            }
        });
    }

    @Inject
    public void initLocationHandler(StageLocationHandler locationHandler) {
        locationHandler.setStage(this);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
        this.whiteboardActionBar.getOptionsButton().getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_WHITEBOARDOPTIONS));
        this.whiteboardActionBar.getOptionsButton().getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_WHITEBOARDOPTIONS));
        this.whiteboardActionBar.getOptionsButton().setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_WHITEBOARDOPTIONSTIP));
        this.screenSharingActionBar.getOptionsButton().getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_SCREENSHARINGOPTIONS));
        this.screenSharingActionBar.getOptionsButton().getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_SCREENSHARINGOPTIONS));
        this.webTourActionBar.getOptionsButton().getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_WEBTOUROPTIONS));
        this.webTourActionBar.getOptionsButton().getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_WEBTOUROPTIONS));
        this.webTourActionBar.getOptionsButton().setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_WEBTOUROPTIONS_TIP));
        this.quizActionBar.getOptionsButton().getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_QUIZOPTIONS));
        this.quizActionBar.getOptionsButton().getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.ACTIONBAR_QUIZOPTIONS));
    }

    private void updateMode(ViewMode mode) {
        switch (mode) {
            case WHITEBOARD: {
                this.actionLayout.show(this.actionPanel, WHITEBOARD_CARD);
                this.centerLayout.show(this.centerPanel, WHITEBOARD_CARD);
                this.navigationPanel.setVisible(true);
                if (this.navigationBar.isDocked()) break;
                SwingUtilities.getWindowAncestor(this.navigationBar).setVisible(true);
                break;
            }
            case APPSHARE: {
                this.actionLayout.show(this.actionPanel, SCREEN_SHARING_CARD);
                this.centerLayout.show(this.centerPanel, SCREEN_SHARING_CARD);
                this.navigationPanel.setVisible(false);
                if (this.navigationBar.isDocked()) break;
                SwingUtilities.getWindowAncestor(this.navigationBar).setVisible(false);
                break;
            }
            case WEBTOUR: {
                this.actionLayout.show(this.actionPanel, WEB_TOUR_CARD);
                this.centerLayout.show(this.centerPanel, WEB_TOUR_CARD);
                this.navigationPanel.setVisible(false);
                if (this.navigationBar.isDocked()) break;
                SwingUtilities.getWindowAncestor(this.navigationBar).setVisible(false);
            }
        }
    }

    @Override
    public boolean requestTopFocus() {
        for (Component comp : this.actionPanel.getComponents()) {
            if (!comp.isVisible() || !(comp instanceof StageActionCard)) continue;
            for (Component actionBar : ((StageActionCard)comp).getComponents()) {
                if (!actionBar.isVisible() || !actionBar.isEnabled() || !(actionBar instanceof SActionBar)) continue;
                for (Component focusReceiver : ((SActionBar)actionBar).getComponents()) {
                    if (!focusReceiver.isEnabled() || !focusReceiver.isVisible() || !focusReceiver.isFocusable() || !focusReceiver.isEnabled()) continue;
                    focusReceiver.requestFocus();
                    return true;
                }
            }
        }
        return false;
    }

    public void addWhiteboardAction(JComponent component, float order) {
        this.whiteboardActionBar.add(component, order);
        this.whiteboardActionBar.revalidate();
    }

    public void removeWhiteboardAction(JComponent component) {
        this.whiteboardActionBar.remove(component);
        this.whiteboardActionBar.revalidate();
    }

    public void addScreenSharingAction(JComponent component, float order) {
        this.screenSharingActionBar.add(component, order);
        this.screenSharingActionBar.revalidate();
    }

    public void removeScreenSharingAction(JComponent component) {
        this.screenSharingActionBar.remove(component);
        this.screenSharingActionBar.revalidate();
    }

    public void addWebTourAction(JComponent component, float order) {
        this.webTourActionBar.add(component, order);
        this.webTourActionBar.revalidate();
    }

    public void removeWebTourAction(JComponent component) {
        this.webTourActionBar.remove(component);
        this.webTourActionBar.revalidate();
    }

    public void addQuizAction(JComponent component, float order) {
        this.quizActionBar.add(component, order);
        this.quizActionBar.revalidate();
    }

    public void removeQuizAction(JComponent component) {
        this.quizActionBar.remove(component);
        this.quizActionBar.revalidate();
    }

    public JPopupMenu getWhiteboardOptionsMenu() {
        return this.whiteboardActionBar.getOptionsMenu();
    }

    public JPopupMenu getScreenSharingOptionsMenu() {
        return this.screenSharingActionBar.getOptionsMenu();
    }

    public JPopupMenu getWebTourOptionsMenu() {
        return this.webTourActionBar.getOptionsMenu();
    }

    public JPopupMenu getQuizOptionsMenu() {
        return this.quizActionBar.getOptionsMenu();
    }

    public void addWhiteboardPalette(Component paletteComponent, int orientation, Component relativeTo) {
        this.whiteboardContentCard.addPalette(paletteComponent, orientation, relativeTo);
    }

    public void removeWhiteboardPalette(Component paletteComponent) {
        this.whiteboardContentCard.removePalette(paletteComponent);
    }

    public void addScreenSharingPalette(Component paletteComponent, int orientation, Component relativeTo) {
        this.screenSharingContentCard.addPalette(paletteComponent, orientation, relativeTo);
    }

    public void removeScreenSharingPalette(Component paletteComponent) {
        this.screenSharingContentCard.removePalette(paletteComponent);
    }

    public void addWebTourPalette(Component paletteComponent, int orientation, Component relativeTo) {
        this.webTourContentCard.addPalette(paletteComponent, orientation, relativeTo);
    }

    public void removeWebTourPalette(Component paletteComponent) {
        this.webTourContentCard.removePalette(paletteComponent);
    }

    public void addQuizPalette(Component paletteComponent, int orientation, Component relativeTo) {
        this.quizContentCard.addPalette(paletteComponent, orientation, relativeTo);
    }

    public void removeQuizPalette(Component paletteComponent) {
        this.quizContentCard.removePalette(paletteComponent);
    }

    public void addWhiteboardContent(Component contentComponent) {
        this.whiteboardContentCard.addContent(contentComponent);
    }

    public void removeWhiteboardContent(Component contentComponent) {
        this.whiteboardContentCard.removeContent(contentComponent);
    }

    public void addScreenSharingContent(Component contentComponent) {
        this.screenSharingContentCard.addContent(contentComponent);
    }

    public void removeScreenSharingContent(Component contentComponent) {
        this.screenSharingContentCard.removeContent(contentComponent);
    }

    public void addWebTourContent(Component contentComponent) {
        this.webTourContentCard.addContent(contentComponent);
    }

    public void removeWebTourContent(Component contentComponent) {
        this.webTourContentCard.removeContent(contentComponent);
    }

    public void addQuizContent(Component contentComponent) {
        this.quizContentCard.addContent(contentComponent);
    }

    public void removeQuizContent(Component contentComponent) {
        this.quizContentCard.removeContent(contentComponent);
    }

    public NavigationPanel getNavigationBar() {
        return this.navigationBar;
    }
}

