/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.AudioVideoPanel;
import com.elluminate.classroom.swing.BottomBar;
import com.elluminate.classroom.swing.ChatPanel;
import com.elluminate.classroom.swing.ContentLoader;
import com.elluminate.classroom.swing.PanelNavigation;
import com.elluminate.classroom.swing.ParticipantsPanel;
import com.elluminate.classroom.swing.PlayerBar;
import com.elluminate.classroom.swing.Stage;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.TopBar;
import com.elluminate.classroom.swing.components.SSideBar;
import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.components.WeightLayout;
import com.elluminate.classroom.swing.location.ContentLoaderLocationHandler;
import com.elluminate.classroom.swing.shortcut.DefaultShortcutRegistry;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.KeyBindingAdapter;
import com.elluminate.gui.MainContentPane;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class SessionContentPane
extends JPanel
implements ContentLoader,
MainContentPane {
    private static final String BASE = "Gemini.sessionContentPane.";
    private static final String SPLIT_POSITION_PREF = "Gemini.sessionContentPane.splitPosition";
    private static final int SPLIT_POSITION_DEFAULT = 250;
    private static final String AUDIO_VIDEO_PANEL_INDEX_PREF = "Gemini.sessionContentPane.audioVideoPanelIndex";
    private static final int AUDIO_VIDEO_PANEL_INDEX_DEFAULT = 0;
    private static final String PARTICIPANTS_PANEL_INDEX_PREF = "Gemini.sessionContentPane.participantsPanelIndex";
    private static final int PARTICIPANTS_PANEL_INDEX_DEFAULT = 1;
    private static final String CHAT_PANEL_INDEX_PREF = "Gemini.sessionContentPane.chatPanelIndex";
    private static final int CHAT_PANEL_INDEX_DEFAULT = 2;
    private static final String AUDIO_VIDEO_PANEL_WEIGHT_PREF = "Gemini.sessionContentPane.audioVideoPanelWeight";
    private static final double AUDIO_VIDEO_PANEL_WEIGHT_DEFAULT = 0.329;
    private static final String PARTICIPANTS_PANEL_WEIGHT_PREF = "Gemini.sessionContentPane.participantsPanelWeight";
    private static final double PARTICIPANTS_PANEL_WEIGHT_DEFAULT = 0.397;
    private static final String CHAT_PANEL_WEIGHT_PREF = "Gemini.sessionContentPane.chatPanelWeight";
    private static final double CHAT_PANEL_WEIGHT_DEFAULT = 0.274;
    private static final String AUDIO_VIDEO_PANEL_EXPANDED_PREF = "Gemini.sessionContentPane.audioVideoPanelExpanded";
    private static final boolean AUDIO_VIDEO_PANEL_EXPANDED_DEFAULT = false;
    private static final String PARTICIPANTS_PANEL_EXPANDED_PREF = "Gemini.sessionContentPane.participantsPanelExpanded";
    private static final boolean PARTICIPANTS_PANEL_EXPANDED_DEFAULT = true;
    private static final String CHAT_PANEL_EXPANDED_PREF = "Gemini.sessionContentPane.chatPanelExpanded";
    private static final boolean CHAT_PANEL_EXPANDED_DEFAULT = true;
    private static final String AUDIO_VIDEO_PANEL_BOUNDS_PREF = "Gemini.sessionContentPane.audioVideoPanelBounds";
    private static final Rectangle AUDIO_VIDEO_PANEL_BOUNDS_DEFAULT = null;
    private static final String PARTICIPANTS_PANEL_BOUNDS_PREF = "Gemini.sessionContentPane.participantsPanelBounds";
    private static final Rectangle PARTICIPANTS_PANEL_BOUNDS_DEFAULT = null;
    private static final String CHAT_PANEL_BOUNDS_PREF = "Gemini.sessionContentPane.chatPanelBounds";
    private static final Rectangle CHAT_PANEL_BOUNDS_DEFAULT = null;
    private static final String AUDIO_VIDEO_PANEL_DOCKED_PREF = "Gemini.sessionContentPane.audioVideoPanelDocked";
    private static final boolean AUDIO_VIDEO_PANEL_DOCKED_DEFAULT = true;
    private static final String PARTICIPANTS_PANEL_DOCKED_PREF = "Gemini.sessionContentPane.participantsPanelDocked";
    private static final boolean PARTICIPANTS_PANEL_DOCKED_DEFAULT = true;
    private static final String CHAT_PANEL_DOCKED_PREF = "Gemini.sessionContentPane.chatPanelDocked";
    private static final boolean CHAT_PANEL_DOCKED_DEFAULT = true;
    private I18n i18n;
    private SwingRunner swinger;
    private FeatureBroker broker;
    private BooleanFeature showSidebarFeature;
    private ActionFeature restoreLayoutFeature;
    private JSplitPane split = new JSplitPane(1, true);
    private SSideBar sideBar;
    private JPanel contentArea;
    private LoadContentHandler loadContentHandler;
    private PropertyChangeListener positionListener;
    private ContainerAdapter orderListener;
    private ComponentListener weightListener;
    private PropertyChangeListener expandedListener;
    private PropertyChangeListener dockedListener;
    private PanelNavigation panelNavigation;
    private DefaultShortcutRegistry defaultShortcuts;
    private Provider<KeyBindingAdapter> keyBinding;
    private AWTEventListener closeWindowListener;
    private AudioVideoPanel audioVideoPanel;
    private ParticipantsPanel participantsPanel;
    private ChatPanel chatPanel;
    private TopBar topToolBar;
    private Stage stage;
    private BottomBar statusBar;
    private PlayerBar playerPanel;
    private Preferences preferences;
    private ContentLoaderLocationHandler contentHandler;

    public SessionContentPane() {
        super(new BorderLayout());
        this.split.setBorder(BorderFactory.createEmptyBorder());
        this.split.setDividerSize(0);
        this.split.setDividerLocation(250);
        this.split.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                int pos = SessionContentPane.this.split.getDividerLocation();
                if (SessionContentPane.this.showSidebarFeature != null && (Boolean)SessionContentPane.this.showSidebarFeature.getValue() != pos > 3) {
                    SessionContentPane.this.showSidebarFeature.setValue((Object)(pos > 3 ? 1 : 0));
                }
            }
        });
        this.add((Component)this.split, "Center");
        GuiUtils.removeKeyBinding((KeyStroke)KeyStroke.getKeyStroke(117, 0), (JComponent)this.split);
        this.sideBar = new SSideBar();
        this.split.setLeftComponent(this.sideBar);
        this.contentArea = new JPanel(new BorderLayout());
        this.contentArea.setMinimumSize(new Dimension(600, 400));
        this.split.setRightComponent(this.contentArea);
        this.loadContentHandler = new LoadContentHandler();
        this.loadContentHandler.setEnabled(false);
        this.setTransferHandler(this.loadContentHandler);
        this.positionListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                SessionContentPane.this.preferences.setSetting(SessionContentPane.SPLIT_POSITION_PREF, SessionContentPane.this.split.getDividerLocation());
            }
        };
        this.orderListener = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                int index = SessionContentPane.this.sideBar.getComponentZOrder(SessionContentPane.this.audioVideoPanel);
                SessionContentPane.this.preferences.setSetting(SessionContentPane.AUDIO_VIDEO_PANEL_INDEX_PREF, index);
                index = SessionContentPane.this.sideBar.getComponentZOrder(SessionContentPane.this.participantsPanel);
                SessionContentPane.this.preferences.setSetting(SessionContentPane.PARTICIPANTS_PANEL_INDEX_PREF, index);
                index = SessionContentPane.this.sideBar.getComponentZOrder(SessionContentPane.this.chatPanel);
                SessionContentPane.this.preferences.setSetting(SessionContentPane.CHAT_PANEL_INDEX_PREF, index);
            }
        };
        this.weightListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component p = e.getComponent();
                WeightLayout l = (WeightLayout)SessionContentPane.this.sideBar.getLayout();
                Double w = (Double)l.getConstraints(p);
                if (w != null) {
                    if (p == SessionContentPane.this.audioVideoPanel) {
                        SessionContentPane.this.preferences.setSetting(SessionContentPane.AUDIO_VIDEO_PANEL_WEIGHT_PREF, w.doubleValue());
                    } else if (p == SessionContentPane.this.participantsPanel) {
                        SessionContentPane.this.preferences.setSetting(SessionContentPane.PARTICIPANTS_PANEL_WEIGHT_PREF, w.doubleValue());
                    } else if (p == SessionContentPane.this.chatPanel) {
                        SessionContentPane.this.preferences.setSetting(SessionContentPane.CHAT_PANEL_WEIGHT_PREF, w.doubleValue());
                    }
                }
            }
        };
        this.expandedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean exp = (Boolean)e.getNewValue();
                Object src = e.getSource();
                if (src == SessionContentPane.this.audioVideoPanel) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.AUDIO_VIDEO_PANEL_EXPANDED_PREF, exp);
                } else if (src == SessionContentPane.this.participantsPanel) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.PARTICIPANTS_PANEL_EXPANDED_PREF, exp);
                } else if (src == SessionContentPane.this.chatPanel) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.CHAT_PANEL_EXPANDED_PREF, exp);
                }
            }
        };
        this.dockedListener = new PropertyChangeListener(){
            private ComponentListener windowListener = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.updateBounds((Window)e.getComponent());
                }

                @Override
                public void componentResized(ComponentEvent e) {
                    this.updateBounds((Window)e.getComponent());
                }
            };
            private Window audioVideoWindow;
            private Window participantsWindow;
            private Window chatWindow;

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean docked = (Boolean)e.getNewValue();
                SSideBarPanel p = (SSideBarPanel)e.getSource();
                if (p == SessionContentPane.this.audioVideoPanel) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.AUDIO_VIDEO_PANEL_DOCKED_PREF, docked);
                    if (!docked) {
                        this.audioVideoWindow = SwingUtilities.getWindowAncestor(SessionContentPane.this.audioVideoPanel);
                        this.audioVideoWindow.addComponentListener(this.windowListener);
                    } else if (this.audioVideoWindow != null) {
                        this.audioVideoWindow.removeComponentListener(this.windowListener);
                        this.audioVideoWindow = null;
                    }
                } else if (p == SessionContentPane.this.participantsPanel) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.PARTICIPANTS_PANEL_DOCKED_PREF, docked);
                    if (!docked) {
                        this.participantsWindow = SwingUtilities.getWindowAncestor(SessionContentPane.this.participantsPanel);
                        this.participantsWindow.addComponentListener(this.windowListener);
                    } else if (this.participantsWindow != null) {
                        this.participantsWindow.removeComponentListener(this.windowListener);
                        this.participantsWindow = null;
                    }
                } else if (p == SessionContentPane.this.chatPanel) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.CHAT_PANEL_DOCKED_PREF, docked);
                    if (!docked) {
                        this.chatWindow = SwingUtilities.getWindowAncestor(SessionContentPane.this.chatPanel);
                        this.chatWindow.addComponentListener(this.windowListener);
                    } else if (this.chatWindow != null) {
                        this.chatWindow.removeComponentListener(this.windowListener);
                        this.chatWindow = null;
                    }
                }
            }

            private void updateBounds(Window window) {
                Rectangle b = window.getBounds();
                if (window == this.audioVideoWindow) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.AUDIO_VIDEO_PANEL_BOUNDS_PREF, b);
                } else if (window == this.participantsWindow) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.PARTICIPANTS_PANEL_BOUNDS_PREF, b);
                } else if (window == this.chatWindow) {
                    SessionContentPane.this.preferences.setSetting(SessionContentPane.CHAT_PANEL_BOUNDS_PREF, b);
                }
            }
        };
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initSwingRunner(SwingRunner swinger) {
        this.swinger = swinger;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initContentHandler(ContentLoaderLocationHandler contentHandler) {
        this.contentHandler = contentHandler;
        contentHandler.addContentLoader(this);
    }

    @Inject
    public void initPanelNavigation(PanelNavigation pn) {
        this.panelNavigation = pn;
        this.panelNavigation.setParent(this);
        this.panelNavigation.registerKeyboardNavigation(this);
    }

    @Inject
    public void initKeyBindingAdapterProvider(Provider<KeyBindingAdapter> kbap) {
        this.keyBinding = kbap;
    }

    @Inject
    public void initPanels(Preferences preferences, AudioVideoPanel audioVideoPanel, ParticipantsPanel participantsPanel, ChatPanel chatPanel, TopBar topBar, Stage stage, BottomBar bottomBar, PlayerBar playerBar) {
        this.contentArea.add((Component)topBar, "North");
        this.contentArea.add((Component)stage, "Center");
        this.add((Component)playerBar, "South");
        this.preferences = preferences;
        this.audioVideoPanel = audioVideoPanel;
        this.participantsPanel = participantsPanel;
        this.chatPanel = chatPanel;
        this.stage = stage;
        audioVideoPanel.setVisible(false);
        ArrayList<SSideBarPanel> panels = new ArrayList<SSideBarPanel>();
        panels.add(audioVideoPanel);
        panels.add(participantsPanel);
        panels.add(chatPanel);
        int audioVideoIndex = preferences.getIntegerSetting(AUDIO_VIDEO_PANEL_INDEX_PREF, -1);
        int participantsIndex = preferences.getIntegerSetting(PARTICIPANTS_PANEL_INDEX_PREF, -1);
        int chatIndex = preferences.getIntegerSetting(CHAT_PANEL_INDEX_PREF, -1);
        for (int i = 2; i >= 0; --i) {
            if (i == audioVideoIndex) {
                panels.remove(audioVideoPanel);
                panels.add(i, audioVideoPanel);
                continue;
            }
            if (i == participantsIndex) {
                panels.remove(participantsPanel);
                panels.add(i, participantsPanel);
                continue;
            }
            if (i != chatIndex) continue;
            panels.remove(chatPanel);
            panels.add(i, chatPanel);
        }
        HashMap<SSideBarPanel, Double> weights = new HashMap<SSideBarPanel, Double>();
        weights.put(audioVideoPanel, 0.329);
        weights.put(participantsPanel, 0.397);
        weights.put(chatPanel, 0.274);
        double w = preferences.getDoubleSetting(AUDIO_VIDEO_PANEL_WEIGHT_PREF, -1.0);
        if (w != -1.0) {
            weights.put(audioVideoPanel, w);
        }
        if ((w = preferences.getDoubleSetting(PARTICIPANTS_PANEL_WEIGHT_PREF, -1.0)) != -1.0) {
            weights.put(participantsPanel, w);
        }
        if ((w = preferences.getDoubleSetting(CHAT_PANEL_WEIGHT_PREF, -1.0)) != -1.0) {
            weights.put(chatPanel, w);
        }
        for (SSideBarPanel p : panels) {
            this.sideBar.add((Component)p, weights.get(p));
        }
        weights.clear();
        int pos = preferences.getIntegerSetting(SPLIT_POSITION_PREF, -1);
        if (pos != -1) {
            this.split.setDividerLocation(pos);
        }
        audioVideoPanel.setExpanded(preferences.getBooleanSetting(AUDIO_VIDEO_PANEL_EXPANDED_PREF, false));
        participantsPanel.setExpanded(preferences.getBooleanSetting(PARTICIPANTS_PANEL_EXPANDED_PREF, true));
        chatPanel.setExpanded(preferences.getBooleanSetting(CHAT_PANEL_EXPANDED_PREF, true));
        audioVideoPanel.setUndockedBounds(preferences.getRectangleSetting(AUDIO_VIDEO_PANEL_BOUNDS_PREF, AUDIO_VIDEO_PANEL_BOUNDS_DEFAULT));
        participantsPanel.setUndockedBounds(preferences.getRectangleSetting(PARTICIPANTS_PANEL_BOUNDS_PREF, PARTICIPANTS_PANEL_BOUNDS_DEFAULT));
        chatPanel.setUndockedBounds(preferences.getRectangleSetting(CHAT_PANEL_BOUNDS_PREF, CHAT_PANEL_BOUNDS_DEFAULT));
        this.sideBar.addContainerListener(this.orderListener);
        this.split.addPropertyChangeListener("dividerLocation", this.positionListener);
        audioVideoPanel.addComponentListener(this.weightListener);
        participantsPanel.addComponentListener(this.weightListener);
        chatPanel.addComponentListener(this.weightListener);
        audioVideoPanel.addPropertyChangeListener("expanded", this.expandedListener);
        participantsPanel.addPropertyChangeListener("expanded", this.expandedListener);
        chatPanel.addPropertyChangeListener("expanded", this.expandedListener);
        audioVideoPanel.addPropertyChangeListener("docked", this.dockedListener);
        participantsPanel.addPropertyChangeListener("docked", this.dockedListener);
        chatPanel.addPropertyChangeListener("docked", this.dockedListener);
    }

    @Inject
    public void initShortcutObjects(DefaultShortcutRegistry dsr) {
        this.defaultShortcuts = dsr;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.showSidebarFeature == null) {
            this.createFeatures();
        }
        this.broker.setFeaturePublished((Feature)this.showSidebarFeature, true);
        this.broker.setFeaturePublished((Feature)this.restoreLayoutFeature, true);
        this.audioVideoPanel.setDocked(this.preferences.getBooleanSetting(AUDIO_VIDEO_PANEL_DOCKED_PREF, true));
        this.participantsPanel.setDocked(this.preferences.getBooleanSetting(PARTICIPANTS_PANEL_DOCKED_PREF, true));
        this.chatPanel.setDocked(this.preferences.getBooleanSetting(CHAT_PANEL_DOCKED_PREF, true));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.broker.setFeaturePublished((Feature)this.showSidebarFeature, false);
        this.broker.setFeaturePublished((Feature)this.restoreLayoutFeature, false);
    }

    public void setupShortcuts() {
        this.setupMoveToChatShortcut();
    }

    private void setupMoveToChatShortcut() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionContentPane.this.chatPanel.requestTopFocus();
            }
        };
        ((KeyBindingAdapter)this.keyBinding.get()).bind("move.to.chat.box", action, this.defaultShortcuts.getShortcut(DefaultShortcutRegistry.SHORTCUT.move_to_chat_box));
    }

    private void createFeatures() {
        int minPos;
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.SESSIONCONTENTPANE_SHOWSIDEBARNAME);
        String desc = this.i18n.getString((PropertiesEnum)StringsProperties.SESSIONCONTENTPANE_SHOWSIDEBARDESC);
        int pos = this.split.getDividerLocation();
        this.showSidebarFeature = this.broker.createBooleanFeature((Object)this, "/ui/session/showSidebar", true, pos >= (minPos = this.split.getMinimumDividerLocation()), name, desc);
        this.showSidebarFeature.addValueChangeListener(new MetaDataListener(){
            private Runnable r = new Runnable(){

                @Override
                public void run() {
                    boolean val = (Boolean)SessionContentPane.this.showSidebarFeature.getValue();
                    int pos = SessionContentPane.this.split.getDividerLocation();
                    int minPos = SessionContentPane.this.split.getMinimumDividerLocation();
                    if (val != pos > 3) {
                        SessionContentPane.this.split.setDividerLocation(val ? minPos : 3);
                        SessionContentPane.this.revalidate();
                    }
                }
            };

            public void metaDataChanged(MetaDataEvent ev) {
                SessionContentPane.this.swinger.invokeOnEventThread(this.r);
            }
        });
        this.restoreLayoutFeature = this.broker.createActionFeature((Object)this, "/ui/session/restoreLayout", this.i18n.getString((PropertiesEnum)StringsProperties.SESSIONCONTENTPANE_RESTORELAYOUTNAME), null);
        this.restoreLayoutFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent e) {
                SessionContentPane.this.restoreLayout();
            }
        });
    }

    int getSideBarDividerPosition() {
        return this.split.getDividerLocation();
    }

    void setSideBarDividerPosition(int divPos) {
        this.split.setDividerLocation(divPos);
    }

    void hideContentArea() {
        this.split.setDividerLocation(1.0);
    }

    private void restoreLayout() {
        this.split.setDividerLocation(250);
        this.audioVideoPanel.setExpanded(false);
        this.participantsPanel.setExpanded(true);
        this.chatPanel.setExpanded(true);
        this.audioVideoPanel.setDocked(true);
        this.participantsPanel.setDocked(true);
        this.chatPanel.setDocked(true);
        this.sideBar.setComponentZOrder(this.audioVideoPanel, 0);
        this.sideBar.setComponentZOrder(this.participantsPanel, 1);
        this.sideBar.setComponentZOrder(this.chatPanel, 2);
        this.preferences.setSetting(AUDIO_VIDEO_PANEL_INDEX_PREF, 0);
        this.preferences.setSetting(PARTICIPANTS_PANEL_INDEX_PREF, 1);
        this.preferences.setSetting(CHAT_PANEL_INDEX_PREF, 2);
        WeightLayout l = (WeightLayout)this.sideBar.getLayout();
        l.setConstraints(this.audioVideoPanel, 0.329);
        l.setConstraints(this.participantsPanel, 0.397);
        l.setConstraints(this.chatPanel, 0.274);
        this.stage.getNavigationBar().setDocked(true);
    }

    public void setInitialFocus() {
        this.panelNavigation.getNextFocus();
    }

    @Override
    public void setContentLoadable(boolean contentLoadable) {
        this.loadContentHandler.setEnabled(contentLoadable);
    }

    private class LoadContentHandler
    extends TransferHandler {
        private boolean enabled = true;

        private LoadContentHandler() {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean canImport(JComponent component, DataFlavor[] flavors) {
            if (!this.enabled) {
                return false;
            }
            for (DataFlavor flv : flavors) {
                if (!flv.equals(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean importData(JComponent component, Transferable transferable) {
            if (!this.enabled) {
                return false;
            }
            try {
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    ArrayList<File> validFiles = new ArrayList<File>();
                    List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File f : list) {
                        if (!f.isFile()) continue;
                        validFiles.add(f);
                    }
                    if (!validFiles.isEmpty()) {
                        return SessionContentPane.this.contentHandler.loadContent(validFiles.toArray(new File[0]));
                    }
                }
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

