/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.ParticipantGestureListener;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.TopFocusReceiver;
import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.location.ParticipantLocationHandler;
import com.elluminate.classroom.swing.location.ParticipantSessionLocationHandler;
import com.elluminate.classroom.swing.participant.ParticipantConsolePanel;
import com.elluminate.classroom.swing.participant.ParticipantListPanel;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.CRSessionType;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ParticipantsPanel
extends SSideBarPanel
implements TopFocusReceiver {
    private static final String BASE = "Gemini.participantsPanel.";
    private static final String SHOW_ALL_PERMISSIONS_PREF = "Gemini.participantsPanel.showAllPermissions";
    private static final boolean SHOW_ALL_PERMISSIONS_DEFAULT = false;
    private ParticipantListPanel listPanel;
    private ParticipantConsolePanel consolePanel;
    private I18n i18n;
    private FeatureBroker featureBroker;
    private Preferences preferences;
    private StringFeature sessionPermissionsFeature;
    private StringFeature participantPermissionsFeature;
    private BooleanFeature showMyPermissionsFeature;
    private ActionFeature dockFeature;

    public ParticipantsPanel() {
        this.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean docked = (Boolean)e.getNewValue();
                if (docked) {
                    ParticipantsPanel.this.dockFeature.setName(ParticipantsPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_DETACH_PANEL));
                } else {
                    ParticipantsPanel.this.dockFeature.setName(ParticipantsPanel.this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_ATTACH_PANEL));
                }
            }
        });
    }

    @Inject
    public void initPanelsAndLocationHandler(ParticipantConsolePanel consolePanel, ParticipantListPanel listPanel, ParticipantSessionLocationHandler participantSessionLocationHandler, ParticipantLocationHandler locationHandler) {
        consolePanel.setVisible(false);
        JPanel c = (JPanel)this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)consolePanel, "North");
        c.add((Component)listPanel, "Center");
        this.listPanel = listPanel;
        this.consolePanel = consolePanel;
        participantSessionLocationHandler.setParticipantConsolePanel(consolePanel);
        locationHandler.setParticipantsPanel(this);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
        this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTSPANEL_NAME));
    }

    @Inject
    public void initSession(final CRSession session) {
        session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onMeAdded(CRParticipantEvent e) {
                ParticipantsPanel.this.consolePanel.setVisible(session.getSessionType() == CRSessionType.ONLINE);
            }

            public void onMeRemoved(CRParticipantEvent e) {
                ParticipantsPanel.this.consolePanel.setVisible(false);
            }
        });
        session.addPermissionChangeListener("ChairPermission", new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent e) {
                CRParticipant me = session.getMe();
                if (me != null && ParticipantsPanel.this.sessionPermissionsFeature != null) {
                    boolean chair = me.isChair();
                    ParticipantsPanel.this.featureBroker.setFeaturePublished((Feature)ParticipantsPanel.this.sessionPermissionsFeature, chair);
                    ParticipantsPanel.this.featureBroker.setFeaturePublished((Feature)ParticipantsPanel.this.participantPermissionsFeature, chair);
                }
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent e) {
            }
        });
    }

    @Inject
    public void initFeatureBroker(FeatureBroker featureBroker) {
        this.featureBroker = featureBroker;
    }

    @Inject
    public void initPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.listPanel.touchUp();
        if (this.dockFeature == null) {
            this.sessionPermissionsFeature = this.featureBroker.createStringFeature((Object)this, "/ui/participant/sessionPermissions", false, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTSPANEL_SESSION_PERMISSIONS), null, null);
            this.sessionPermissionsFeature.setEnabled(false);
            this.featureBroker.addFeature((Feature)this.sessionPermissionsFeature);
            this.featureBroker.setFeaturePublished((Feature)this.sessionPermissionsFeature, false);
            this.participantPermissionsFeature = this.featureBroker.createStringFeature((Object)this, "/ui/participant/participantPermissions", false, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTSPANEL_PARTICIPANT_PERMISSIONS), null, null);
            this.participantPermissionsFeature.setEnabled(false);
            this.featureBroker.addFeature((Feature)this.participantPermissionsFeature);
            this.featureBroker.setFeaturePublished((Feature)this.participantPermissionsFeature, false);
            boolean value = this.preferences.getBooleanSetting(SHOW_ALL_PERMISSIONS_PREF, false);
            this.showMyPermissionsFeature = this.featureBroker.createBooleanFeature((Object)this, "/ui/participant/showMyPermissions", true, value, this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTSPANEL_SHOW_MY_PERMISSIONS), null);
            this.showMyPermissionsFeature.setEnabled(true);
            this.showMyPermissionsFeature.addValueChangeListener(new MetaDataListener(){

                public void metaDataChanged(MetaDataEvent e) {
                    boolean value = (Boolean)e.getNewValue();
                    ParticipantsPanel.this.consolePanel.setShowingAllPermissions(value);
                    ParticipantsPanel.this.preferences.setSetting(ParticipantsPanel.SHOW_ALL_PERMISSIONS_PREF, value);
                }
            });
            this.featureBroker.addFeature((Feature)this.showMyPermissionsFeature);
            this.featureBroker.setFeaturePublished((Feature)this.showMyPermissionsFeature, true);
            this.consolePanel.setShowingAllPermissions(value);
            this.dockFeature = this.featureBroker.createActionFeature((Object)this, "/ui/participant/dock", this.i18n.getString((PropertiesEnum)StringsProperties.SIDEBARPANEL_DETACH_PANEL), null);
            this.dockFeature.addActionFeatureListener(new ActionFeatureListener(){

                public void actionPerformed(ActionFeatureEvent e) {
                    ParticipantsPanel.this.setDocked(!ParticipantsPanel.this.isDocked());
                }
            });
            this.featureBroker.addFeature((Feature)this.dockFeature);
            this.featureBroker.setFeaturePublished((Feature)this.dockFeature, true);
        }
    }

    @Override
    protected void setContentVisible(boolean contentVisible) {
        this.listPanel.setVisible(contentVisible);
    }

    @Override
    public boolean requestTopFocus() {
        return this.listPanel.requestFirstFocus();
    }

    public void setCurrentRoomName(String roomName) {
        this.consolePanel.setRoomName(roomName);
    }

    public JPopupMenu getRoomsMenu() {
        return this.consolePanel.getRoomsMenu();
    }

    public JPopupMenu getParticipantMenu() {
        return this.listPanel.getParticipantMenu();
    }

    public JPopupMenu getRoomMenu() {
        return this.listPanel.getRoomMenu();
    }

    public void addParticipantAction(JComponent component, float order, SessionCard relatedCard) {
        this.consolePanel.addParticipantAction(component, order, relatedCard);
    }

    public void removeParticipantAction(JComponent component) {
        this.consolePanel.removeParticipantAction(component);
    }

    public void addSessionDisplay(JComponent component, SessionCard card) {
        this.consolePanel.addSessionDisplay(component, card);
    }

    public void removeSessionDisplay(JComponent component, SessionCard card) {
        this.consolePanel.removeSessionDisplay(component, card);
    }

    public void addSessionAction(AbstractButton button, SessionCard card) {
        this.consolePanel.addSessionAction(button, card);
    }

    public void removeSessionAction(AbstractButton button, SessionCard card) {
        this.consolePanel.removeSessionAction(button, card);
    }

    public void addParticipantGestureListener(ParticipantGestureListener l) {
        this.listPanel.addParticipantGestureListener(l);
    }

    public void removeParticipantDragListener(ParticipantGestureListener l) {
        this.listPanel.removeParticipantGestureListener(l);
    }

    public static enum SessionCard {
        POLL;

    }
}

