/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.swing.ArrowNavigation;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.components.ButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SNavigationPanel;
import com.elluminate.classroom.swing.location.NavigationLocationHandler;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class NavigationPanel
extends SNavigationPanel {
    private static final Object ORDER_KEY = new Object();
    private I18n i18n;
    private FeatureBroker featureBroker;
    private ActionFeature dockFeature;
    private GridBagConstraints previousConstraints;
    private GridBagConstraints nextConstraints;
    private JPanel selectorPanel;
    private GridBagConstraints selectorConstraints;
    private JPanel optionPanel;
    private Font font;
    private GridBagConstraints optionConstraints;
    private JPanel listPanel;

    public NavigationPanel() {
        this.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (NavigationPanel.this.dockFeature != null) {
                    boolean docked = (Boolean)e.getNewValue();
                    if (docked) {
                        NavigationPanel.this.dockFeature.setName(NavigationPanel.this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_SHOW_EXPLORER));
                    } else {
                        NavigationPanel.this.dockFeature.setName(NavigationPanel.this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_HIDE_EXPLORER));
                    }
                }
            }
        });
        ArrowNavigation.install(this.topBar);
        this.setCanUndock(false);
        Font f = UIManager.getFont("Button.font");
        this.font = f.deriveFont((float)f.getSize() * 11.0f / 12.0f);
        JPanel p = (JPanel)this.getBarPane();
        p.setLayout(new GridBagLayout());
        this.previousConstraints = new GridBagConstraints();
        this.previousConstraints.gridx = 0;
        this.previousConstraints.weightx = 0.0;
        this.nextConstraints = new GridBagConstraints();
        this.nextConstraints.gridx = 1;
        this.nextConstraints.weightx = 0.0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets.left = 6;
        this.selectorPanel = new JPanel(new GridBagLayout());
        this.selectorPanel.setOpaque(false);
        p.add((Component)this.selectorPanel, gbc);
        this.selectorConstraints = new GridBagConstraints();
        this.selectorConstraints.weightx = 1.0;
        this.selectorConstraints.anchor = 17;
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.weightx = 0.0;
        this.optionPanel = new JPanel(new GridBagLayout());
        this.optionPanel.setOpaque(false);
        p.add((Component)this.optionPanel, gbc);
        this.optionConstraints = new GridBagConstraints();
        this.optionConstraints.insets.left = 6;
        JPanel c = (JPanel)this.getContentPane();
        c.setLayout(new BorderLayout());
        this.listPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Component[] cs = this.getComponents();
                if (cs != null && cs.length != 0) {
                    g.setColor(cs[0].getBackground());
                    g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
                }
            }
        };
        this.listPanel.setBorder(UIManager.getBorder("Navigation.contentBorder"));
        this.listPanel.setOpaque(false);
        c.add((Component)this.listPanel, "Center");
    }

    @Inject
    public void initLocationHandler(NavigationLocationHandler locationHandler) {
        locationHandler.setNavigationPanel(this);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
        this.setTitle(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_NAME));
        this.optionsButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_OPTIONSTIP));
        this.optionsButton.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_OPTIONS));
        this.optionsButton.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_OPTIONS));
    }

    @Inject
    public void initFeatureBroker(FeatureBroker featureBroker) {
        this.featureBroker = featureBroker;
    }

    public static int orderToIndex(float order, Container container) {
        int index = 0;
        for (Component c : container.getComponents()) {
            JComponent jc;
            float o;
            if (c instanceof JComponent && (o = ((Float)(jc = (JComponent)c).getClientProperty(ORDER_KEY)).floatValue()) > order) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void addPreviousButton(AbstractButton button) {
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setContentAreaFilled(false);
        button.addFocusListener(new ButtonFocusDisplayer());
        JPanel p = (JPanel)this.getBarPane();
        p.add((Component)button, this.previousConstraints);
        p.revalidate();
    }

    public void removePreviousButton(AbstractButton button) {
        JPanel p = (JPanel)this.getBarPane();
        p.remove(button);
        p.revalidate();
    }

    public void addNextButton(AbstractButton button) {
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setContentAreaFilled(false);
        button.addFocusListener(new ButtonFocusDisplayer());
        JPanel p = (JPanel)this.getBarPane();
        p.add((Component)button, this.nextConstraints);
        p.revalidate();
    }

    public void removeNextButton(AbstractButton button) {
        JPanel p = (JPanel)this.getBarPane();
        p.remove(button);
        p.revalidate();
    }

    public void addSelectorComponent(JComponent selector) {
        GridBagConstraints gbc = (GridBagConstraints)this.selectorConstraints.clone();
        if (Platform.getLAF() == 502) {
            selector.putClientProperty("JComponent.sizeVariant", "small");
        }
        selector.setFont(this.font);
        if (selector instanceof JComboBox) {
            ((JComboBox)selector).setMaximumRowCount(35);
            if (Platform.getLAF() == 502) {
                gbc.insets.top = -1;
                gbc.insets.bottom = -2;
            }
            selector.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_SCREENSELECTOR));
            selector.getAccessibleContext().setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_SCREENSELECTOR));
            selector.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_SCREENSELECTOR));
        } else if (selector instanceof JLabel || selector instanceof JTextComponent) {
            selector.setPreferredSize(new Dimension(250, selector.getPreferredSize().height));
            selector.setForeground(UIManager.getColor("NavigationPanel.textColor"));
            gbc.insets.top = 4;
            gbc.insets.left = 6;
            gbc.insets.bottom = 4;
            gbc.insets.right = 6;
        }
        this.selectorPanel.add((Component)selector, gbc);
        this.selectorPanel.revalidate();
    }

    public void removeSelectorComponent(JComponent selector) {
        this.selectorPanel.remove(selector);
        this.selectorPanel.revalidate();
    }

    public void addOption(JComponent option, float order) {
        if (Platform.getLAF() == 502) {
            option.putClientProperty("JComponent.sizeVariant", "small");
        }
        option.setFont(this.font);
        if (option instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)option;
            b.setBorder(BorderFactory.createEmptyBorder());
            b.setContentAreaFilled(false);
            b.addFocusListener(new ButtonFocusDisplayer());
        } else if (option instanceof JLabel || option instanceof JTextComponent) {
            option.setForeground(UIManager.getColor("NavigationPanel.textColor"));
        }
        option.putClientProperty(ORDER_KEY, Float.valueOf(order));
        int index = NavigationPanel.orderToIndex(order, this.optionPanel);
        this.optionPanel.add(option, this.optionConstraints, index);
        this.optionPanel.revalidate();
    }

    public void removeOption(JComponent option) {
        option.putClientProperty(ORDER_KEY, null);
        this.optionPanel.remove(option);
        this.optionPanel.revalidate();
    }

    public void addContentList(Component contentList) {
        this.listPanel.add(contentList, "Center");
        this.listPanel.revalidate();
        if (this.dockFeature == null) {
            this.dockFeature = this.featureBroker.createActionFeature((Object)this, "/ui/navigation/dock", this.i18n.getString((PropertiesEnum)StringsProperties.NAVIGATIONPANEL_SHOW_EXPLORER), null);
            this.dockFeature.addActionFeatureListener(new ActionFeatureListener(){

                public void actionPerformed(ActionFeatureEvent e) {
                    NavigationPanel.this.setDocked(!NavigationPanel.this.isDocked());
                }
            });
        }
        this.featureBroker.setFeaturePublished((Feature)this.dockFeature, true);
        this.setCanUndock(true);
    }

    public void removeContentList(Component contentList) {
        this.listPanel.remove(contentList);
        this.listPanel.revalidate();
        if (this.dockFeature != null) {
            this.featureBroker.setFeaturePublished((Feature)this.dockFeature, false);
        }
        this.setCanUndock(false);
    }
}

