/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.client.GeminiFlags;
import com.elluminate.classroom.swing.SplashContentPane;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.VersionManager;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

class AboutBox
extends EasyDialog {
    private static final String HEX = "0123456789ABCDEF";
    private I18n i18n = I18n.create((Object)((Object)this));
    private JTabbedPane tabs;
    private JComponent aboutTab;
    private Point versionPosition;
    private String editionText;
    private Point editionPosition;
    private boolean shown = false;
    private VersionManager verMgr;

    public AboutBox(Frame parent, BrandingI18nProvider brandingProvider, Map options, String serverVersions, VersionManager versionManager, SplashContentPane splashContentPane) {
        super((Component)parent, "");
        int y;
        int x;
        int comma;
        this.verMgr = versionManager;
        I18n branding = brandingProvider.get();
        String title = null;
        try {
            title = this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_ABOUTTITLE, new Object[]{branding.getString((PropertiesEnum)BrandingI18nProvider.Values.APP_NAME)});
        }
        catch (Exception e) {
            System.err.println("VClassAbout.title not defined in branding information - taking default");
        }
        this.setTitle(title);
        this.setDefaultCloseOperation(1);
        String pos = (String)options.get("about.versionPosition");
        if (pos != null && (comma = pos.indexOf(44)) > 0 && comma < pos.length() - 1) {
            try {
                x = Integer.parseInt(pos.substring(0, comma));
                y = Integer.parseInt(pos.substring(comma + 1));
                this.versionPosition = new Point(x, y);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        try {
            this.editionText = branding.getString((PropertiesEnum)BrandingI18nProvider.Values.EDITION_NAME);
        }
        catch (MissingResourceException ex) {
            System.err.println("Collaborate.editionName not defined in branding");
        }
        pos = (String)options.get("about.editionPosition");
        if (pos != null && (comma = pos.indexOf(44)) > 0 && comma < pos.length() - 1) {
            try {
                x = Integer.parseInt(pos.substring(0, comma));
                y = Integer.parseInt(pos.substring(comma + 1));
                this.editionPosition = new Point(x, y);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        this.tabs = new JTabbedPane(1);
        this.setContent(this.tabs);
        JComponent image = null;
        try {
            ImageIcon ic = branding.getIcon((PropertiesEnum)BrandingI18nProvider.Values.ABOUT_IMAGE);
            if (ic != null) {
                image = new JLabel(ic){
                    private String versionText;
                    private Font versionFont;
                    private Color versionForeground;
                    private Font editionFont;
                    private Color editionForeground;
                    {
                        this.versionText = AboutBox.this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_VERSION);
                        this.versionFont = UIManager.getFont("Label.font").deriveFont(1, 12.0f);
                        this.versionForeground = Color.BLACK;
                        this.editionFont = UIManager.getFont("Label.font").deriveFont(1, 18.0f);
                        this.editionForeground = Color.WHITE;
                    }

                    @Override
                    protected void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        if (AboutBox.this.versionPosition != null) {
                            g.setColor(this.versionForeground);
                            g.setFont(this.versionFont);
                            g.drawString(this.versionText, ((AboutBox)AboutBox.this).versionPosition.x, ((AboutBox)AboutBox.this).versionPosition.y);
                        }
                        if (AboutBox.this.editionText != null && AboutBox.this.editionPosition != null) {
                            g.setColor(this.editionForeground);
                            g.setFont(this.editionFont);
                            g.drawString(AboutBox.this.editionText, ((AboutBox)AboutBox.this).editionPosition.x, ((AboutBox)AboutBox.this).editionPosition.y);
                        }
                    }
                };
            }
        }
        catch (MissingResourceException ex) {
            System.err.println("aboutImage not defined in branding");
        }
        this.aboutTab = this.createAboutTab(image != null ? image : splashContentPane);
        this.tabs.addTab(this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_ABOUTTAB), this.aboutTab);
        this.tabs.addTab(this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_INFOTAB), this.createInformationTab(serverVersions));
    }

    public void show() {
        if (!this.shown) {
            this.shown = true;
            this.setInsets(null);
            this.pack();
            JRootPane root = this.getRootPane();
            Rectangle b = this.aboutTab.getComponent(0).getBounds();
            b = SwingUtilities.convertRectangle(this.aboutTab, b, root);
            Rectangle sb = root.getBounds();
            Insets ins = new Insets(0, -b.x, -(sb.y + sb.height - (b.y + b.height) - sb.y), -(sb.x + sb.width - (b.x + b.width) - sb.x));
            this.setInsets(ins);
            this.pack();
        }
        super.show();
    }

    private JComponent createAboutTab(JComponent component) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)component, "Center");
        return p;
    }

    private JComponent createInformationTab(String serverVersions) {
        JTextPane tp = new JTextPane();
        tp.setContentType("text/html");
        tp.setEditable(false);
        tp.setMargin(new Insets(0, 10, 0, 10));
        tp.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HyperlinkEvent.EventType type = e.getEventType();
                if (type.equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    String url = e.getURL().toString();
                    try {
                        BrowserUtil.gotoURL((String)url);
                    }
                    catch (Throwable t) {
                        ModalDialog.showMessageDialog((Component)((JComponent)e.getSource()), (Object)AboutBox.this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_CANTLAUNCHBROWSER, new Object[]{url}), (String)AboutBox.this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_CANTLAUNCHTITLE), (int)0);
                    }
                }
            }
        });
        Color bg = tp.getBackground();
        Color fg = tp.getForeground();
        Font f = tp.getFont();
        tp.setText(this.createInformationHTML(bg, fg, f.getName(), f.getSize(), serverVersions));
        tp.getCaret().setDot(0);
        JScrollPane sp = new JScrollPane(tp, 22, 31);
        sp.setPreferredSize(new Dimension(100, 100));
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setViewportBorder(BorderFactory.createEmptyBorder());
        return sp;
    }

    private String createInformationHTML(Color background, Color foreground, String fontName, int fontSize, String serverVersions) {
        String pName = this.verMgr.getProductName();
        String pVer = this.verMgr.getProductVer();
        StringBuilder b = new StringBuilder();
        b.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n");
        b.append("<html>\n");
        b.append("<head>\n");
        b.append("<title>Information</title>\n");
        b.append("<style>\n");
        b.append("<!--\n");
        b.append("body { color: " + AboutBox.color2html(foreground) + ";\n");
        b.append("background-color: " + AboutBox.color2html(background) + ";\n");
        b.append("font-family: \"" + fontName + "\",sans-serif;\n");
        b.append("font-size: " + fontSize + "pt;}\n");
        b.append("-->\n");
        b.append("</style>\n");
        b.append("</head>\n");
        b.append("<body>\n");
        b.append("<p><b>" + pName + " " + pVer + "</b></p>\n");
        b.append("<p>" + AboutBox.fold(this.verMgr.getHtmlCopyrights()) + "</p>\n");
        b.append("<p><b>" + this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_COMPONENTHDR) + "</b></p>\n");
        b.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n");
        Iterator i = this.verMgr.componentIterator();
        while (i.hasNext()) {
            String comp = (String)i.next();
            String ver = this.verMgr.getVersionString(comp);
            b.append("<tr>\n");
            b.append("<td width=\"20\"></td>");
            b.append("<td><b>" + comp + "</b></td>\n");
            b.append("<td width=\"10\"></td>");
            b.append("<td>" + ver + "</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
        boolean hasLibs = false;
        Iterator i2 = this.verMgr.libraryIterator();
        while (i2.hasNext()) {
            if (!hasLibs) {
                hasLibs = true;
                b.append("<p><b>" + this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_LIBRARYHDR) + "</b></p>\n");
                b.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
            }
            String lib = (String)i2.next();
            String ver = this.verMgr.getVersionString(lib);
            b.append("<tr>\n");
            b.append("<td width=\"20\"></td>\n");
            b.append("<td>\n");
            b.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\n");
            b.append("<tr>\n");
            b.append("<td><b>");
            boolean hasURL = this.verMgr.hasInfoURL(lib);
            if (hasURL) {
                b.append("<a href=\"" + this.verMgr.getInfoURL(lib) + "\">");
            }
            b.append(lib);
            if (hasURL) {
                b.append("</a>");
            }
            b.append("</b> " + ver + "</td>\n");
            b.append("</tr>\n");
            if (this.verMgr.hasCopyright(lib)) {
                b.append("<tr>\n");
                b.append("<td>" + this.verMgr.getCopyright(lib) + "</td>\n");
                b.append("</tr>\n");
            }
            b.append("</table>\n");
            b.append("</td>\n");
            b.append("</tr>\n");
        }
        if (hasLibs) {
            b.append("</table>\n");
        }
        b.append("<p><b>" + this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_OS) + "</b></p>");
        b.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
        b.append("<tr>\n");
        b.append("<td width=\"20\"></td>\n");
        b.append("<td>" + Platform.getInfo() + "</td>\n");
        b.append("</tr>\n");
        b.append("</table>\n");
        b.append("<p><b>" + this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_JVM) + "</b></p>");
        b.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"4\">\n");
        b.append("<tr>\n");
        b.append("<td width=\"20\"></td>\n");
        b.append("<td>" + Platform.getJavaInfo() + "</td>\n");
        b.append("</tr>\n");
        b.append("</table><br>\n");
        if (GeminiFlags.SHOW_SERVER_VERSION.show() && serverVersions != null) {
            b.append("</table><br>\n");
            b.append("<p><b>" + this.i18n.getString((PropertiesEnum)StringsProperties.ABOUT_SERVER_VERSION_HEADER) + "</b></p>\n");
            String[] strings = serverVersions.split("\n");
            b.append("<p>" + strings[0] + "</p>\n");
            b.append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\">\n");
            for (int i3 = 2; i3 < strings.length; ++i3) {
                String string = strings[i3];
                String[] myLine = string.trim().split(" ");
                if (myLine.length <= 1) continue;
                b.append("<tr>");
                b.append("<td width=\"20\"></td>");
                b.append("<td><b>" + myLine[0] + "</b></td>\n");
                b.append("<td width=\"10\"></td>");
                b.append("<td>" + myLine[myLine.length - 1] + "</td>");
                b.append("</tr>\n");
            }
            b.append("</table>\n");
        }
        b.append("</body>\n");
        b.append("</html>\n");
        if (GeminiFlags.ABOUT.show()) {
            LogSupport.message((Object)((Object)this), (String)"jbInit", (String)("About box HTML:\n" + b.toString()));
        }
        return b.toString();
    }

    private static String color2html(Color c) {
        StringBuilder b = new StringBuilder(7);
        b.append("#");
        int rgb = c.getRGB();
        for (int i = 20; i >= 0; i -= 4) {
            int h = rgb >> i & 0xF;
            b.append(HEX.charAt(h));
        }
        return b.toString();
    }

    private static String fold(String str) {
        StringBuilder b = new StringBuilder();
        int off = 0;
        int comma = 0;
        while ((comma = str.indexOf(44, off)) >= 0) {
            b.append(str.substring(off, comma + 1));
            b.append("\n    ");
            off = comma + 1;
        }
        b.append(str.substring(off));
        return b.toString();
    }
}

