/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.log;

import java.util.ArrayList;
import java.util.Arrays;

public class HistoryBuffer {
    private String[] buf = null;
    private int pos = -1;
    private int len = 0;

    public HistoryBuffer(int maxLen) {
        if (maxLen <= 0) {
            throw new IllegalArgumentException("Length must be positive: " + maxLen);
        }
        this.buf = new String[maxLen];
    }

    public int getLength() {
        return this.len;
    }

    public synchronized void resize(int targetLen) {
        if (targetLen <= 0) {
            throw new IllegalArgumentException("Length must be positive: " + targetLen);
        }
        String[] targetBuf = new String[targetLen];
        int nToCopy = Math.min(this.buf.length, targetBuf.length);
        System.arraycopy(this.getRecent(nToCopy), 0, targetBuf, 0, nToCopy);
        this.buf = targetBuf;
        this.len = Math.min(this.len, nToCopy);
        this.pos = this.len - 1;
    }

    public synchronized void clear() {
        this.len = 0;
        this.pos = -1;
        Arrays.fill(this.buf, null);
    }

    public synchronized void append(String s) {
        if (s == null) {
            return;
        }
        int pos = 0;
        while (pos < s.length()) {
            int next = s.indexOf(10, pos);
            if (next < 0) {
                this.addLine(s.substring(pos));
                pos = s.length();
                continue;
            }
            if (next > pos) {
                this.addLine(s.substring(pos, next));
            }
            pos = next + 1;
        }
    }

    private void addLine(String s) {
        if (s.trim().length() < 1) {
            return;
        }
        this.pos = this.len == 0 ? 0 : (this.pos + 1) % this.buf.length;
        this.buf[this.pos] = s;
        if (this.len < this.buf.length) {
            ++this.len;
        }
    }

    public String[] getAll() {
        return this.getRecent(this.len);
    }

    public synchronized String[] getRecent(int count) {
        int start;
        ArrayList<String> result = new ArrayList<String>(count);
        if (count > this.len) {
            count = this.len;
        }
        if ((start = this.pos - count + 1) < 0) {
            start += this.buf.length;
        }
        for (int ix = 0; ix < count; ++ix) {
            String s = this.buf[(start + ix) % this.buf.length];
            if (s == null) continue;
            result.add(s);
        }
        return result.toArray(new String[result.size()]);
    }
}

