/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.io;

import com.elluminate.util.I18n;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.event.BufferFillEvent;
import com.elluminate.util.event.BufferFillListener;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.event.ThrowableListener;
import com.elluminate.util.event.URLFillErrorEvent;
import com.elluminate.util.event.URLFillErrorEventSource;
import com.elluminate.util.event.URLFillErrorListener;
import com.elluminate.util.io.RandomDataInput;
import com.elluminate.util.io.StringsProperties;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class RandomAccessURL
implements URLFillErrorEventSource,
RandomDataInput,
Runnable {
    private static final long INDETERMINATE_LENGTH = 0x7FFFFFFF00000000L;
    private static final int MAX_RESTARTS = 3;
    private I18n i18n = I18n.create(this);
    private File file = null;
    private RandomAccessFile in = null;
    private boolean alreadyOpened = false;
    private URLConnection connection = null;
    private String contentType = null;
    private Thread fillThread = null;
    private int restartCount = 0;
    private InputStream fillStream = null;
    private volatile Throwable fillError = null;
    private volatile boolean fillComplete = false;
    private volatile long length = 0L;
    private long expected = -1L;
    private long position = 0L;
    private long writePosition = 0L;
    private final Object lock = new Object();
    private boolean buffering = true;
    private char[] lineBuffer = null;
    private volatile BufferFillListener listener = null;
    private final URL source;
    private ListenerRegistry<URLFillErrorListener> errorListeners = new ListenerRegistry(new FiringThrowableHandler());
    private boolean allowNetworkCaches = true;
    private boolean allowUserInteraction = false;

    public RandomAccessURL(URL url) throws IOException {
        this(url, null, null);
    }

    public RandomAccessURL(URL url, URLFillErrorListener errListener) throws IOException {
        this(url, null, errListener);
    }

    public RandomAccessURL(URL url, BufferFillListener fillListener) throws IOException {
        this(url, fillListener, null);
    }

    public RandomAccessURL(URL url, BufferFillListener fillListener, URLFillErrorListener errListener) throws IOException {
        this.source = url;
        this.listener = fillListener;
        this.addURLFillErrorListener(errListener);
        this.open();
    }

    public RandomAccessURL(URL url, boolean allowCaching, boolean allowInteraction, BufferFillListener fillListener, URLFillErrorListener errListener) throws IOException {
        this.source = url;
        this.listener = fillListener;
        this.allowNetworkCaches = allowCaching;
        this.allowUserInteraction = allowInteraction;
        this.addURLFillErrorListener(errListener);
        this.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.alreadyOpened) {
                throw new IOException("already opened once");
            }
            this.alreadyOpened = true;
        }
        int retryCount = 0;
        while (true) {
            try {
                this.openConnection();
            }
            catch (IOException iox) {
                if (++retryCount < 3) {
                    LogSupport.message(this, "open", "Error opening URL: " + iox);
                    continue;
                }
                throw iox;
            }
            break;
        }
        this.file = File.createTempFile("url", ".tmp");
        this.file.deleteOnExit();
        this.in = new RandomAccessFile(this.file, "rw");
        Object object2 = this.lock;
        synchronized (object2) {
            this.fillThread = new WorkerThread((Runnable)this, "URL Filler Thread");
            this.fillThread.start();
        }
    }

    public boolean isNetworkCachingAllowed() {
        return this.allowNetworkCaches;
    }

    public boolean isUserInteractionAllowed() {
        return this.allowUserInteraction;
    }

    private void openConnection() throws IOException {
        this.connection = this.source.openConnection();
        this.connection.setUseCaches(this.allowNetworkCaches);
        this.connection.setAllowUserInteraction(this.allowUserInteraction);
        if (this.connection instanceof HttpURLConnection) {
            HttpURLConnection hcon = (HttpURLConnection)this.connection;
            int code = hcon.getResponseCode();
            if (UtilDebug.URL_INFO.show()) {
                LogSupport.message(this, "openConnection", "Connected to " + this.source + " HTTP status " + code + " -- " + hcon.getResponseMessage());
            }
            if (code >= 300) {
                throw new FatalConnectionException(code, hcon.getResponseMessage());
            }
            if (code != 200) {
                LogSupport.message(this, "openConnection", "WARNING: unexpected HTTP status: " + code + " -- " + hcon.getResponseMessage());
            }
        }
        this.contentType = this.connection.getContentType();
        this.length = this.connection.getContentLength();
        if (UtilDebug.URL_INFO.show()) {
            LogSupport.message(this, "openConnection", "Opened connection, expecting " + this.length + " bytes of type " + this.contentType);
        }
        this.expected = this.length;
        if (this.length < 0L) {
            this.length = 0x7FFFFFFF00000000L;
        }
        this.fillStream = this.connection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.fillThread != null) {
                this.fillThread.interrupt();
            }
            if (this.fillStream != null) {
                this.fillStream.close();
            }
            this.fillThread = null;
            this.fillStream = null;
            this.in.close();
            this.lock.notifyAll();
        }
        this.file.delete();
        this.file = null;
    }

    public boolean hasFillError() {
        return this.fillError != null;
    }

    public Throwable getFillError() {
        return this.fillError;
    }

    public boolean isFillComplete() {
        return this.fillComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFillerAlive() {
        Thread t;
        Object object = this.lock;
        synchronized (object) {
            t = this.fillThread;
        }
        return t != null && t.isAlive();
    }

    @Override
    public URL getSourceURL() {
        return this.source;
    }

    public File getBackingFile() {
        return this.file;
    }

    @Override
    public long getExpectedLength() {
        if (this.expected < 0L) {
            return this.length;
        }
        return this.expected;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void addURLFillErrorListener(URLFillErrorListener l) {
        this.errorListeners.add(l);
    }

    public void removeURLFillErrorListener(URLFillErrorListener l) {
        this.errorListeners.remove(l);
    }

    @Override
    public void fireURLFillErrorListener(final URLFillErrorEvent ev) {
        ev.removeDispositionFromMask(4);
        if (this.restartCount >= 3 && ev.isRestartable()) {
            ev.removeDispositionFromMask(8);
        }
        FiringFunctor<URLFillErrorListener> ff = new FiringFunctor<URLFillErrorListener>(){

            @Override
            public void fire(URLFillErrorListener l) {
                l.fillError(ev);
            }
        };
        this.errorListeners.fire(ff);
        if (UtilDebug.URL_INFO.show()) {
            LogSupport.message(this, "fireURLFillErrorListener", "Fill error '" + ev.getMessage() + "' disposition: " + URLFillErrorEvent.getDispositionName(ev.getDisposition()));
        }
        switch (ev.getDisposition()) {
            case 4: {
                throw new RetryFillException();
            }
            case 8: {
                throw new RestartFillException();
            }
            case 2: {
                break;
            }
            default: {
                if (ev.getDispositionMask() != 0 || ev.getDisposition() != 0) {
                    LogSupport.error(this, "run", "Invalid disposition on fill error: " + ev);
                }
            }
            case 1: {
                this.fillError = ev.getCause();
                throw new CancelFillException();
            }
        }
    }

    @Override
    public Object getReadLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePointer() throws IOException {
        if (this.buffering) {
            long result = -1L;
            Object object = this.lock;
            synchronized (object) {
                result = this.position;
            }
            return result;
        }
        return this.in.getFilePointer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        long result = -1L;
        Object object = this.lock;
        synchronized (object) {
            result = this.length;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long available() {
        if (this.buffering) {
            long result = -1L;
            Object object = this.lock;
            synchronized (object) {
                result = this.writePosition;
            }
            return result;
        }
        return this.length();
    }

    private long availableLocked() {
        if (this.buffering) {
            return this.writePosition;
        }
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void seek(long pos) throws IOException {
        if (this.buffering) {
            Object object = this.lock;
            synchronized (object) {
                this.position = pos;
                this.waitFor(this.position + 1L, this.position);
            }
        } else {
            this.in.seek(pos);
        }
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readLine() throws IOException {
        if (this.buffering) {
            String line;
            Object object = this.lock;
            synchronized (object) {
                char c;
                char[] buf = this.lineBuffer;
                if (buf == null) {
                    buf = this.lineBuffer = new char[128];
                }
                int room = buf.length;
                int offset = 0;
                this.waitFor(this.position + (long)room + 1L, this.position);
                block7: while (true) {
                    c = this.in.readChar();
                    switch (c) {
                        case '\uffffffff': 
                        case '\n': {
                            break block7;
                        }
                        case '\r': {
                            char c2 = this.in.readChar();
                            if (c2 == '\n' || c2 == '\uffffffff') break block7;
                            this.in.skipBytes(-1);
                            break block7;
                        }
                        default: {
                            if (--room < 0) {
                                this.position = this.in.getFilePointer();
                                this.waitFor(this.position + 128L + 1L, this.position);
                                buf = new char[offset + 128];
                                room = buf.length - offset - 1;
                                System.arraycopy(this.lineBuffer, 0, buf, 0, offset);
                                this.lineBuffer = buf;
                            }
                            buf[offset++] = c;
                            continue block7;
                        }
                    }
                    break;
                }
                this.position = this.in.getFilePointer();
                line = c == '\uffffffff' && offset == 0 ? null : String.copyValueOf(buf, 0, offset);
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return line;
        }
        return this.in.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double readDouble() throws IOException {
        if (this.buffering) {
            double value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 8L, this.position);
                this.position += 8L;
                value = this.in.readDouble();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readDouble();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float readFloat() throws IOException {
        if (this.buffering) {
            float value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 4L, this.position);
                this.position += 4L;
                value = this.in.readFloat();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readFloat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong() throws IOException {
        if (this.buffering) {
            long value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 8L, this.position);
                this.position += 8L;
                value = this.in.readLong();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt() throws IOException {
        if (this.buffering) {
            int value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 4L, this.position);
                this.position += 4L;
                value = this.in.readInt();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short readShort() throws IOException {
        if (this.buffering) {
            short value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 2L, this.position);
                this.position += 2L;
                value = this.in.readShort();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readUnsignedShort() throws IOException {
        if (this.buffering) {
            int value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 2L, this.position);
                this.position += 2L;
                value = this.in.readUnsignedShort();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readUnsignedShort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char readChar() throws IOException {
        if (this.buffering) {
            char value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 2L, this.position);
                this.position += 2L;
                value = this.in.readChar();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readChar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte readByte() throws IOException {
        if (this.buffering) {
            byte value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 1L, this.position);
                ++this.position;
                value = this.in.readByte();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readUnsignedByte() throws IOException {
        if (this.buffering) {
            int value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 1L, this.position);
                ++this.position;
                value = this.in.readUnsignedByte();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readUnsignedByte();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readBoolean() throws IOException {
        if (this.buffering) {
            boolean value;
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + 1L, this.position);
                ++this.position;
                value = this.in.readBoolean();
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
            return value;
        }
        return this.in.readBoolean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int skipBytes(int nBytes) throws IOException {
        if (this.buffering) {
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + (long)nBytes + 1L, this.position + (long)nBytes);
                this.position += (long)nBytes;
            }
            return nBytes;
        }
        return this.in.skipBytes(nBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFully(byte[] buf, int off, int len) throws IOException {
        if (this.buffering) {
            Object object = this.lock;
            synchronized (object) {
                this.waitFor(this.position + (long)len, this.position);
                this.in.readFully(buf, off, len);
                this.position += (long)len;
                if (this.fillComplete) {
                    this.buffering = false;
                }
            }
        } else {
            this.in.readFully(buf, off, len);
        }
    }

    @Override
    public void readFully(byte[] buf) throws IOException {
        this.readFully(buf, 0, buf.length);
    }

    private void waitFor(long pos, long seek) throws IOException {
        while (this.availableLocked() < pos && pos < this.length && this.buffering) {
            try {
                this.lock.wait(1000L);
            }
            catch (InterruptedException ex) {
                throw new InterruptedIOException();
            }
        }
        this.in.seek(seek);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelFill(InputStream fill) {
        Object object = this.lock;
        synchronized (object) {
            if (UtilDebug.URL_INFO.show()) {
                LogSupport.message(this, "cancelFill", "after receiving: " + this.writePosition + " / " + this.expected);
            }
            try {
                if (fill != null) {
                    fill.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fillStream = null;
            this.fillThread = null;
            this.fillComplete = true;
            this.length = this.writePosition;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartFill(InputStream fill) {
        Object object = this.lock;
        synchronized (object) {
            if (UtilDebug.URL_INFO.show()) {
                LogSupport.message(this, "restartFill", "after receiving: " + this.writePosition + " / " + this.expected);
            }
            try {
                if (fill != null) {
                    fill.close();
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
            int retryCount = 0;
            while (true) {
                try {
                    if (UtilDebug.RESTART_URL_FAIL.show()) {
                        throw new IOException("Test exception");
                    }
                    this.openConnection();
                }
                catch (Throwable t) {
                    if (t instanceof IOException && ++retryCount < 3) {
                        LogSupport.message(this, "restartFill", "Error opening connection: " + t);
                        continue;
                    }
                    this.cancelFill(null);
                    if (this.listener != null) {
                        BufferFillEvent bfe = new BufferFillEvent(this, 4, 0L, 0L, null, -1);
                        try {
                            this.listener.onBufferReset(bfe);
                        }
                        catch (Exception ex) {
                            LogSupport.exception(this, "restartFill", ex, true);
                        }
                    }
                    URLFillErrorEvent ev = t instanceof FatalConnectionException ? new URLFillErrorEvent(this, 1, null, t.getLocalizedMessage(), 1) : new URLFillErrorEvent((URLFillErrorEventSource)this, 1, t, 1);
                    try {
                        this.fireURLFillErrorListener(ev);
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    return;
                }
                break;
            }
            if (this.listener != null) {
                try {
                    BufferFillEvent bfe = new BufferFillEvent(this, 2, 0L, this.length, null, -1);
                    this.listener.onBufferReset(bfe);
                }
                catch (Exception ex) {
                    LogSupport.exception(this, "restartFill", ex, true);
                }
            }
            WorkerThread t = new WorkerThread((Runnable)this, "URL Filler Thread " + ++this.restartCount);
            t.start();
            this.fillThread = t;
            this.fillComplete = false;
            this.writePosition = 0L;
            this.lock.notify();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 39[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class CancelFillException
    extends FillDispositionException {
        private CancelFillException() {
            super("Cancel fill thread.");
        }
    }

    public class FatalConnectionException
    extends RuntimeException {
        private String localizedMsg;

        private FatalConnectionException(int statusCode, String statusMsg) {
            super("HTTP connection failed: " + statusCode + " -- " + statusMsg);
            this.localizedMsg = RandomAccessURL.this.i18n.getString(StringsProperties.RANDOMACCESSURL_HTTPERRORMSG, "" + statusCode, statusMsg);
        }

        @Override
        public String getLocalizedMessage() {
            return this.localizedMsg;
        }
    }

    public static class FillDispositionException
    extends RuntimeException {
        private FillDispositionException(String msg) {
            super(msg);
        }
    }

    private static class FiringThrowableHandler
    implements ThrowableListener {
        private FiringThrowableHandler() {
        }

        @Override
        public void exceptionThrown(Exception e) {
            LogSupport.exception(this, "fireURLFillErrorListener", e, true);
        }

        @Override
        public void errorThrown(Error e) {
            LogSupport.exception(this, "fireURLFillErrorListener", e, true);
        }
    }

    public static class RestartFillException
    extends FillDispositionException {
        private RestartFillException() {
            super("Restart fill thread.");
        }
    }

    public static class RetryFillException
    extends FillDispositionException {
        private RetryFillException() {
            super("Retry fill from checkpoint.");
        }
    }
}

