/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image.gif;

import com.elluminate.util.UtilDebug;
import com.elluminate.util.image.gif.GifImage;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class GifFile {
    public static final long MIN_DELAY_TIME = 100L;
    public static final String MIME_TYPE = "image/gif";
    public static final int DISPOSE_NO_DISPOSE = 0;
    public static final int DISPOSE_DO_NOT_DISPOSE = 1;
    public static final int DISPOSE_RESTORE_TO_BACKGROUND = 2;
    public static final int DISPOSE_RESTORE_TO_PREVIOUS = 3;
    private static final byte[] GIF_MAGIC_87A = new byte[]{71, 73, 70, 56, 55, 97};
    private static final byte[] GIF_MAGIC_89A = new byte[]{71, 73, 70, 56, 57, 97};
    private static final int GLOBAL_COLOR_TABLE_FLAG = 128;
    private static final int COLOR_RESOLUTION_MASK = 112;
    private static final int COLOR_RESOLUTION_SHIFT = 4;
    private static final int SORT_FLAG = 8;
    private static final int GLOBAL_COLOR_TALBE_SIZE_MASK = 7;
    private static final int GLOBAL_COLOR_TABLE_SIZE_SHIFT = 0;
    private static final int HEADER_LENGTH = 12;
    private static final int IMAGE_SEPARATOR = 44;
    private static final int EXTENSION = 33;
    public static final int END_OF_FILE = 59;
    private static final int BLOCK_TERMINATOR = 0;
    private static final int APPLICATION_EXTENSION = 255;
    private static final int COMMENT_EXTENSION = 254;
    private static final int GRAPHIC_CONTROL_EXTENSION = 249;
    private static final int PLAIN_TEXT_EXTENSION = 1;
    private byte[] imageDataBytes;
    private int bytesLength = 0;
    private String name;
    private boolean gif87A = false;
    private boolean gif89A = false;
    private int colorResolution = 0;
    private int globalBackgroundColorIndex = 0;
    private int globalColorTableLength = 0;
    private int globalColorTableOffset = 0;
    private boolean globalColorTableFlag = false;
    private int globalColorTableSize = 0;
    private int globalFlags = 0;
    private int headerLength = 0;
    private int logicalWidth = -1;
    private int logicalHeight = -1;
    private int pixelAspectRatio = 0;
    private boolean sortFlag = false;
    private FrameData currentFrame = null;
    private int[] currentRaster = null;
    private int[] backgroundRaster = null;
    private int globalBackgroundPixel;
    private int localBackgroundPixel;
    private ArrayList imageList = new ArrayList();
    private long totalTime = 0L;

    public GifFile(byte[] bytes, String name) {
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("Construct GifFile: " + name + "\n");
        }
        this.imageDataBytes = bytes;
        this.name = name;
        this.bytesLength = bytes.length;
        int offset = this.decodeHeader(0);
        this.processBlock(bytes, offset);
        this.imageDataBytes = null;
        this.currentRaster = null;
        this.backgroundRaster = null;
    }

    public void dispose() {
        this.imageList.clear();
        this.imageList = null;
    }

    public void emitFiles(String basePath) {
        int imageNumber = 0;
        for (GifImage gifImage : this.imageList) {
            File gifFile = new File(basePath + ".subImage" + imageNumber++ + ".gif");
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(gifFile));
                out.write(gifImage.getImageData());
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public int getImageCount() {
        return this.imageList.size();
    }

    public GifImage getGifImage(int imageIndex) {
        return (GifImage)this.imageList.get(imageIndex);
    }

    public boolean isGif() {
        return this.gif87A || this.gif89A;
    }

    public int getByteCount() {
        int result = this.getImageCount() * this.getWidth() * this.getHeight() * 4;
        return result;
    }

    public boolean isGif87A() {
        return this.gif87A;
    }

    public boolean isGif89A() {
        return this.gif89A;
    }

    public int getWidth() {
        return this.logicalWidth;
    }

    public int getHeight() {
        return this.logicalHeight;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    private int decodeHeader(int offset) {
        boolean gif87a = this.equals(this.imageDataBytes, offset, GIF_MAGIC_87A, 0, GIF_MAGIC_87A.length);
        if (!gif87a) {
            this.gif89A = this.equals(this.imageDataBytes, offset, GIF_MAGIC_89A, 0, GIF_MAGIC_89A.length);
            if (!this.gif89A) {
                throw new RuntimeException(this.name + "Not a GIF87A or GIF89A file");
            }
        }
        this.logicalWidth = this.getShortLittleEndian(this.imageDataBytes, offset += 6);
        this.logicalHeight = this.getShortLittleEndian(this.imageDataBytes, offset + 2);
        this.globalFlags = this.imageDataBytes[offset + 4] & 0xFF;
        this.globalColorTableFlag = (this.globalFlags & 0x80) != 0;
        this.globalColorTableSize = (this.globalFlags & 7) >> 0;
        this.sortFlag = (this.globalFlags & 8) != 0;
        this.colorResolution = 1 + ((this.globalFlags & 0x70) >> 4);
        this.globalBackgroundColorIndex = this.imageDataBytes[offset + 5] & 0xFF;
        this.pixelAspectRatio = this.imageDataBytes[offset + 6] & 0xFF;
        offset += 6;
        ++offset;
        if (this.globalColorTableFlag) {
            this.globalColorTableOffset = offset;
            this.globalColorTableLength = 3 * (1 << this.globalColorTableSize + 1);
            this.globalBackgroundPixel = this.globalBackgroundColorIndex < this.globalColorTableSize ? this.getPixel(this.imageDataBytes, offset + this.globalBackgroundColorIndex) : 0;
            offset += this.globalColorTableLength;
        } else {
            this.globalColorTableLength = 0;
            this.globalBackgroundPixel = 0;
        }
        this.localBackgroundPixel = this.globalBackgroundPixel;
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("\nHeader: " + this.name + "\n  Logical Width: " + this.logicalWidth + "\n");
            LogSupport.message("  Logical Height: " + this.logicalHeight + "\n");
            LogSupport.message("  Global Color Table: " + this.globalColorTableFlag + "\n");
            LogSupport.message("  Sort: " + this.sortFlag + "\n");
            LogSupport.message("  Color Resolution: " + this.colorResolution + "\n");
            LogSupport.message("  Global Background Color Index: " + this.logicalHeight + "\n");
            LogSupport.message("  Pixel Aspect Ratio: " + this.logicalHeight + "\n");
            LogSupport.message("  Global Color Table Size: " + this.globalColorTableLength + "\n");
        }
        this.headerLength = offset;
        return offset;
    }

    private void processBlock(byte[] bytes, int offset) {
        int startOffset = offset;
        this.currentFrame = new FrameData();
        byte blockType = bytes[offset++];
        while (offset < bytes.length) {
            switch (blockType) {
                case 0: {
                    break;
                }
                case 44: {
                    startOffset = offset = this.processImageDescriptor(bytes, startOffset, offset);
                    this.currentFrame = new FrameData();
                    break;
                }
                case 33: {
                    offset = this.processExtension(bytes, offset);
                    break;
                }
                case 59: {
                    return;
                }
                default: {
                    this.dumpBytes();
                    throw new RuntimeException(this.name + ": Unknown Block Type: " + Integer.toHexString(blockType & 0xFF) + " at offset: " + (offset - 1));
                }
            }
            blockType = bytes[offset++];
        }
    }

    private int processImageDescriptor(byte[] bytes, int startOffset, int offset) {
        int flags;
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("\nProcess Image Descriptor\n");
        }
        this.currentFrame.left = this.getShortLittleEndian(bytes, offset + 0);
        this.currentFrame.top = this.getShortLittleEndian(bytes, offset + 2);
        this.currentFrame.width = this.getShortLittleEndian(bytes, offset + 4);
        this.currentFrame.height = this.getShortLittleEndian(bytes, offset + 6);
        offset += 8;
        this.currentFrame.colorTableFlag = ((flags = bytes[offset++] & 0xFF) & 0x80) != 0;
        this.currentFrame.interlaceFlag = (flags & 0x40) != 0;
        this.currentFrame.sortFlag = (flags & 0x20) != 0;
        int tableLength = flags & 7;
        if (this.currentFrame.colorTableFlag) {
            this.currentFrame.colorTableOffset = offset;
            this.currentFrame.colorTableLength = 3 * (1 << tableLength + 1);
            this.localBackgroundPixel = this.getPixel(this.imageDataBytes, offset + this.globalBackgroundColorIndex);
            offset += this.currentFrame.colorTableLength;
        } else {
            this.currentFrame.colorTableLength = 0;
            this.localBackgroundPixel = this.globalBackgroundPixel;
        }
        DataBlock dataBlock = this.getBlockData(bytes, ++offset);
        byte[] imageData = dataBlock.data;
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("  Left: " + this.currentFrame.left + "\n");
            LogSupport.message("  Top: " + this.currentFrame.top + "\n");
            LogSupport.message("  Width: " + this.currentFrame.width + "\n");
            LogSupport.message("  Height: " + this.currentFrame.height + "\n");
            LogSupport.message("  Local Color Flag: " + this.currentFrame.colorTableFlag + "\n");
            LogSupport.message("  Interlace: " + this.currentFrame.interlaceFlag + "\n");
            LogSupport.message("  Sort: " + this.currentFrame.sortFlag + "\n");
            LogSupport.message("  LocalColorTable size: " + this.currentFrame.colorTableLength + "\n");
            LogSupport.message("  Image Data Size: " + imageData.length + "\n");
        }
        if (this.backgroundRaster == null || this.backgroundRaster[0] != this.localBackgroundPixel) {
            this.backgroundRaster = GifFile.fillRaster(null, this.logicalWidth, this.logicalHeight, this.localBackgroundPixel);
        }
        boolean setInitialRaster = false;
        if (this.currentRaster == null) {
            setInitialRaster = true;
            this.currentRaster = this.backgroundRaster;
        }
        GifImage currentImage = new GifImage(this.currentRaster, MIME_TYPE, this.getBytes(bytes, 0, this.headerLength), bytes, startOffset, dataBlock.offset, this.currentFrame.left, this.currentFrame.top, this.currentFrame.width, this.currentFrame.height, this.logicalWidth, this.logicalHeight, this.currentFrame.displayTime, this.currentFrame.disposalMethod);
        switch (this.currentFrame.disposalMethod) {
            default: {
                this.currentRaster = currentImage.getRaster();
                break;
            }
            case 1: {
                this.currentRaster = currentImage.getRaster();
                break;
            }
            case 2: {
                this.currentRaster = this.backgroundRaster;
            }
            case 3: 
        }
        this.imageList.add(currentImage);
        offset = dataBlock.offset;
        imageData = null;
        dataBlock = null;
        return offset;
    }

    private byte[] getBytes(byte[] bytes, int offset, int length) {
        byte[] result = new byte[length];
        System.arraycopy(bytes, offset, result, 0, length);
        return result;
    }

    private int processExtension(byte[] bytes, int offset) {
        int extensionType = bytes[offset++] & 0xFF;
        switch (extensionType) {
            case 254: {
                offset = this.processCommentExtension(bytes, offset);
                break;
            }
            case 1: {
                offset = this.processTextExtension(bytes, offset);
                break;
            }
            case 249: {
                offset = this.processGraphicExtension(bytes, offset);
                break;
            }
            case 255: {
                offset = this.processAppExtension(bytes, offset);
                break;
            }
            default: {
                DataBlock block = this.getBlockData(bytes, offset);
                offset = block.offset;
            }
        }
        return offset;
    }

    private int processCommentExtension(byte[] bytes, int offset) {
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("\nProcess Comment Extension\n");
        }
        DataBlock dataBlock = this.getBlockData(bytes, offset);
        this.currentFrame.comment = new String(dataBlock.data);
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("  Comment: \"" + this.currentFrame.comment + "\"\n");
        }
        return dataBlock.offset;
    }

    private int processTextExtension(byte[] bytes, int offset) {
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("\nProcess Plain Text Extension\n");
        }
        int blockLen = bytes[offset++] & 0xFF;
        this.currentFrame.textGridLeft = this.getShortLittleEndian(bytes, offset + 0);
        this.currentFrame.textGridTop = this.getShortLittleEndian(bytes, offset + 4);
        this.currentFrame.textGridWidth = this.getShortLittleEndian(bytes, offset + 4);
        this.currentFrame.textGridHeight = this.getShortLittleEndian(bytes, offset + 4);
        offset += 8;
        this.currentFrame.charCellWidth = bytes[offset++] & 0xFF;
        this.currentFrame.charCellHeight = bytes[offset++] & 0xFF;
        this.currentFrame.textForegroundColorIndex = bytes[offset++] & 0xFF;
        this.currentFrame.textBackgroundColorIndex = bytes[offset++] & 0xFF;
        DataBlock dataBlock = this.getBlockData(bytes, offset);
        this.currentFrame.plainTextData = new String(dataBlock.data);
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("  Text Grid Left: " + this.currentFrame.textGridLeft + "\n");
            LogSupport.message("  Text Grid Top: " + this.currentFrame.textGridTop + "\n");
            LogSupport.message("  Text Grid Width: " + this.currentFrame.textGridWidth + "\n");
            LogSupport.message("  Text Grid Height: " + this.currentFrame.textGridHeight + "\n");
            LogSupport.message("  Char Cell Width: " + this.currentFrame.charCellWidth + "\n");
            LogSupport.message("  Char Cell Height: " + this.currentFrame.charCellHeight + "\n");
            LogSupport.message("  Text Foreground Color Index: " + this.currentFrame.textForegroundColorIndex + "\n");
            LogSupport.message("  Text Background Color Index: " + this.currentFrame.textBackgroundColorIndex + "\n");
            LogSupport.message("  Text: \"" + this.currentFrame.plainTextData + "\"\n");
        }
        if (!UtilDebug.GIF_DATA.show()) {
            this.currentFrame.plainTextData = null;
        }
        return dataBlock.offset;
    }

    private int processGraphicExtension(byte[] bytes, int offset) {
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("\nProcess Graphic  Extension\n");
        }
        int blockSize = bytes[offset++] & 0xFF;
        int flags = bytes[offset + 0] & 0xFF;
        this.currentFrame.displayTime = Math.max(100L, (long)(this.getShortLittleEndian(bytes, offset + 1) * 10));
        this.currentFrame.transparentColorIndex = bytes[offset + 3] & 0xFF;
        this.currentFrame.disposalMethod = flags >> 2 & 0xFF;
        this.currentFrame.userInputFlag = (flags & 1) != 0;
        boolean bl = this.currentFrame.transparentColorFlag = (flags & 1) != 0;
        if (bytes[offset += blockSize] != 0) {
            throw new RuntimeException("Graphic Extension block terminated by: " + Integer.toHexString(bytes[offset] & 0xFF) + " at offset: " + offset);
        }
        ++offset;
        this.totalTime += this.currentFrame.displayTime;
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("  DelayTime: " + this.currentFrame.displayTime + "\n");
            LogSupport.message("  Transparent Color Index: " + this.currentFrame.transparentColorIndex + "\n");
            LogSupport.message("  Disposal Method: " + this.currentFrame.disposalMethod + "\n");
            LogSupport.message("  User Input Flag: " + this.currentFrame.userInputFlag + "\n");
            LogSupport.message("  Transparent Color Flag: " + this.currentFrame.transparentColorFlag + "\n");
        }
        return offset;
    }

    private int processAppExtension(byte[] bytes, int offset) {
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("\nProcess Application Extension\n");
        }
        int blockSize = bytes[offset++] & 0xFF;
        this.currentFrame.appIdentifier = new String(bytes, offset, 8);
        this.currentFrame.authenticationCode = new byte[3];
        System.arraycopy(bytes, offset += this.currentFrame.appIdentifier.length(), this.currentFrame.authenticationCode, 0, this.currentFrame.authenticationCode.length);
        DataBlock dataBlock = this.getBlockData(bytes, offset += this.currentFrame.authenticationCode.length);
        if (UtilDebug.GIF_DECODE.show()) {
            LogSupport.message("  Application Identifier: " + this.currentFrame.appIdentifier + "\n");
            LogSupport.message("  App Authentication: " + new String(this.currentFrame.authenticationCode) + "\n");
        } else {
            this.currentFrame.appIdentifier = null;
        }
        return dataBlock.offset;
    }

    private DataBlock getBlockData(byte[] bytes, int offset) {
        int totalLength = 0;
        int initialOffset = offset;
        int blockLen = bytes[initialOffset++] & 0xFF;
        while (blockLen > 0 && blockLen + initialOffset < bytes.length) {
            initialOffset += blockLen;
            totalLength += blockLen;
            blockLen = bytes[initialOffset++] & 0xFF;
        }
        byte[] data = new byte[totalLength];
        int blockIndex = 0;
        int blockLen2 = bytes[offset++] & 0xFF;
        while (blockLen2 > 0 && blockLen2 + offset < bytes.length) {
            System.arraycopy(bytes, offset, data, blockIndex, blockLen2);
            offset += blockLen2;
            blockIndex += blockLen2;
            blockLen2 = bytes[offset++] & 0xFF;
        }
        return new DataBlock(data, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpBytes() {
        OutputStream out = null;
        try {
            File outFile;
            File folder = new File(System.getProperty("user.home") + File.separator + "GifDebug");
            if (!folder.exists()) {
                folder.mkdir();
            }
            if ((outFile = this.name.endsWith(".gif") ? new File(folder, this.name) : new File(folder, this.name + ".gif")).exists()) {
                outFile.delete();
            }
            out = new BufferedOutputStream(new FileOutputStream(outFile));
            out.write(this.imageDataBytes);
        }
        catch (IOException ioe) {
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private boolean equals(byte[] first, int firstOffset, byte[] second, int secondOffset, int length) {
        int len = Math.min(Math.min(second.length - firstOffset, first.length - firstOffset), length);
        for (int i = 0; i < len; ++i) {
            if (first[i + firstOffset] == second[i + secondOffset]) continue;
            return false;
        }
        return true;
    }

    private int getShortLittleEndian(byte[] bytes, int offset) {
        int byte0 = bytes[offset] & 0xFF;
        int byte1 = bytes[offset + 1] & 0xFF;
        return (byte1 << 8) + byte0;
    }

    private int getPixel(byte[] table, int offset) {
        int pixel = 0;
        pixel = ((0xFF & table[offset]) << 8 | 0xFF & table[offset + 1]) << 8 | 0xFF & table[offset + 2];
        return pixel;
    }

    public static int[] fillRaster(int[] rasterIn, int width, int height, int pixel) {
        int[] raster = rasterIn == null ? new int[width * height] : rasterIn;
        int rasterIndex = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster[rasterIndex++] = pixel;
            }
        }
        return raster;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Name: " + this.name + ", GifFile.length: " + this.bytesLength + ", images: " + this.imageList.size());
        return str.toString();
    }

    class DataBlock {
        int offset;
        byte[] data;

        public DataBlock(byte[] data, int offset) {
            this.data = data;
            this.offset = offset;
        }
    }

    class FrameData {
        String appIdentifier = null;
        byte[] authenticationCode = null;
        private int charCellHeight = 0;
        private int charCellWidth = 0;
        boolean colorTableFlag = false;
        int colorTableLength = 0;
        int colorTableOffset = 0;
        String comment = null;
        long displayTime = 0L;
        int disposalMethod = 0;
        int height = 0;
        int imageByteLength = 0;
        int imageByteOffset = 0;
        boolean interlaceFlag = false;
        int left = 0;
        boolean localColorTableFlag = false;
        private String plainTextData = null;
        boolean sortFlag = false;
        private int textGridHeight = 0;
        private int textGridLeft = 0;
        private int textGridTop = 0;
        private int textGridWidth = 0;
        private int textBackgroundColorIndex = 0;
        private int textForegroundColorIndex = 0;
        int top = 0;
        boolean transparentColorFlag = false;
        int transparentColorIndex = 0;
        boolean userInputFlag = false;
        int width = 0;

        FrameData() {
        }
    }
}

