/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.platform.Platform;
import com.elluminate.util.image.ImageMimeUtilities;
import com.elluminate.util.image.PICTHelper;
import com.elluminate.util.io.IOUtilities;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class PICTImporter {
    private static final String[] PICT_MIME_TYPES = new String[]{"image/pict", "image/x-pict"};
    private static final boolean IS_MAC = Platform.getPlatform() == 2;

    public static boolean isSupported() {
        if (IS_MAC) {
            try {
                PICTHelper importer = PICTHelper.getInstance();
                if (importer == null) {
                    return false;
                }
                return importer.isAvailable();
            }
            catch (Throwable t) {
                LogSupport.exception(PICTImporter.class, "isSupported", t, true);
            }
        }
        return false;
    }

    public static String[] getMIMETypes() {
        return (String[])PICT_MIME_TYPES.clone();
    }

    public static boolean isPICT(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        String type = ImageMimeUtilities.getRawImageMimeType(mimeType);
        for (String t : PICT_MIME_TYPES) {
            if (!type.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPICT(File f) {
        return PICTImporter.isPICT(Platform.getMimeType(f));
    }

    public static BufferedImage loadPICT(File f) throws IOException {
        PICTHelper importer;
        BufferedImage result = null;
        if (f != null && PICTImporter.isSupported() && (importer = PICTHelper.getInstance()) != null) {
            result = importer.convertToImage(f);
        }
        return result;
    }

    public static Image loadPICT(File f, Dimension size) throws IOException {
        PICTHelper importer;
        BufferedImage result = null;
        if (f != null && PICTImporter.isSupported() && (importer = PICTHelper.getInstance()) != null) {
            result = importer.convertToImage(f, size);
        }
        return result;
    }

    public static BufferedImage convertPICT(InputStream is, boolean pad) throws IOException {
        BufferedImage result = null;
        byte[] data = null;
        if (is != null && PICTImporter.isSupported()) {
            data = IOUtilities.readStream(is);
        }
        if (data != null && data.length > 0) {
            PICTHelper importer;
            if (pad) {
                data = PICTImporter.padHeader(data);
            }
            if ((importer = PICTHelper.getInstance()) != null) {
                result = importer.convertToImage(data);
            }
        }
        return result;
    }

    public static BufferedImage convertPICT(byte[] data) throws IOException {
        PICTHelper importer;
        BufferedImage result = null;
        if (data != null && PICTImporter.isSupported() && (importer = PICTHelper.getInstance()) != null) {
            result = importer.convertToImage(data);
        }
        return result;
    }

    public static Image convertPICT(byte[] data, Dimension size) throws IOException {
        PICTHelper importer;
        Image result = null;
        if (data != null && PICTImporter.isSupported() && (importer = PICTHelper.getInstance()) != null) {
            result = importer.convertToImage(data, size);
        }
        return result;
    }

    public static byte[] padHeader(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] result = new byte[data.length + 512];
        Arrays.fill(result, 0, 512, (byte)0);
        System.arraycopy(data, 0, result, 512, data.length);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File saveToTempFile(byte[] data, String suffix) throws IOException {
        File f = File.createTempFile("ImageTemp", suffix, Platform.getTempDir());
        f.deleteOnExit();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(data);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable ignored) {}
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] readFileData(File f) throws IOException {
        byte[] pictData = null;
        InputStream istrm = null;
        ByteArrayOutputStream ostrm = null;
        try {
            byte[] buf = new byte[4096];
            istrm = new BufferedInputStream(new FileInputStream(f));
            ostrm = new ByteArrayOutputStream((int)f.length());
            while (true) {
                int nRead = 0;
                try {
                    nRead = istrm.read(buf, 0, buf.length);
                    if (nRead < 0) break;
                    if (nRead <= 0) continue;
                    ostrm.write(buf, 0, nRead);
                }
                catch (EOFException eofx) {}
            }
            ostrm.flush();
            pictData = ostrm.toByteArray();
        }
        finally {
            if (istrm != null) {
                try {
                    istrm.close();
                }
                catch (Throwable ignored) {}
            }
        }
        return pictData;
    }

    public static void main(String[] args) {
        if (!PICTImporter.isSupported()) {
            System.err.println("Not supported.");
            return;
        }
        System.err.println("Testing: " + PICTHelper.getInstance());
        for (int ix = 0; ix < args.length; ++ix) {
            byte[] pictData = null;
            try {
                Image imgBig;
                BufferedImage img;
                File f = new File(args[ix]);
                System.err.println("Processing: " + f.getName());
                if (!f.isFile()) {
                    System.err.println("Not a file: " + args[ix]);
                    continue;
                }
                pictData = PICTImporter.readFileData(f);
                if (pictData != null) {
                    img = PICTImporter.convertPICT(pictData);
                    imgBig = PICTImporter.convertPICT(pictData, new Dimension(1024, 768));
                } else {
                    img = null;
                    imgBig = null;
                }
                if (img != null) {
                    System.err.println("Small -- " + f + " " + ((Image)img).getWidth(null) + "x" + ((Image)img).getHeight(null));
                }
                if (imgBig == null) continue;
                System.err.println("Big -- " + f + " " + imgBig.getWidth(null) + "x" + imgBig.getHeight(null));
                continue;
            }
            catch (Throwable t) {
                System.err.println("Error processing file " + args[ix]);
                t.printStackTrace();
            }
        }
    }
}

