/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.image;

import com.elluminate.util.image.ImageSupport;
import com.elluminate.util.log.LogSupport;
import java.awt.Image;
import java.io.File;
import java.io.IOException;

public class ImageFile {
    private Image image;
    private static String staticImageName = "ImageFile";
    private static int staticImageNumber = 1;

    public ImageFile(Image image) {
        this.image = image;
    }

    public static void setImageName(String name) {
        staticImageName = name;
    }

    public void writePNG(String name) {
        ImageFile.writePNG(name, this.image);
    }

    public static void writePNG(String name, Image image) {
        String imageFile = name.equals("") ? staticImageName + "." + staticImageNumber++ + ".png" : name + ".png";
        try {
            ImageSupport.saveAsPNG(image, 9, new File(imageFile));
        }
        catch (IOException ie) {
            LogSupport.exception(ImageFile.class, "writePNG", ie, true);
            return;
        }
        LogSupport.message("Writing file: " + imageFile);
    }
}

