/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.Hex;
import com.elluminate.util.crypto.SecureHash;

public class SHA256
implements SecureHash {
    private static final byte[] PAD_HEADER = new byte[]{-128, 0, 0, 0};
    private static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private int h0 = 1779033703;
    private int h1 = -1150833019;
    private int h2 = 1013904242;
    private int h3 = -1521486534;
    private int h4 = 1359893119;
    private int h5 = -1694144372;
    private int h6 = 528734635;
    private int h7 = 1541459225;
    private int[] buffer = new int[64];
    private int word;
    private int bufx = 0;
    private int wordx = 0;
    private long length = 0L;

    @Override
    public String getName() {
        return "SHA256";
    }

    @Override
    public int hashByteLength() {
        return 32;
    }

    @Override
    public int hashBitLength() {
        return 256;
    }

    @Override
    public void reset() {
        this.h0 = 1779033703;
        this.h1 = -1150833019;
        this.h2 = 1013904242;
        this.h3 = -1521486534;
        this.h4 = 1359893119;
        this.h5 = -1694144372;
        this.h6 = 528734635;
        this.h7 = 1541459225;
        this.word = 0;
        this.bufx = 0;
        this.wordx = 0;
        this.length = 0L;
    }

    @Override
    public void process(byte[] buf) {
        this.process(buf, 0, buf.length);
    }

    @Override
    public void process(byte[] in, int off, int len) {
        int limit = off + len;
        while (off < limit) {
            int b = in[off++] & 0xFF;
            ++this.length;
            this.word = this.word << 8 | b;
            if (++this.wordx != 4) continue;
            this.buffer[this.bufx++] = this.word;
            this.wordx = 0;
            this.word = 0;
            if (this.bufx != 16) continue;
            this.processBlock();
            this.bufx = 0;
        }
    }

    @Override
    public byte[] hash() {
        byte[] sh = new byte[32];
        this.pad();
        this.writeWord(sh, 0, this.h0);
        this.writeWord(sh, 4, this.h1);
        this.writeWord(sh, 8, this.h2);
        this.writeWord(sh, 12, this.h3);
        this.writeWord(sh, 16, this.h4);
        this.writeWord(sh, 20, this.h5);
        this.writeWord(sh, 24, this.h6);
        this.writeWord(sh, 28, this.h7);
        this.reset();
        return sh;
    }

    private void processBlock() {
        for (int i = 16; i < 64; ++i) {
            int b02 = this.buffer[i - 2];
            int b15 = this.buffer[i - 15];
            this.buffer[i] = ((b02 >>> 17 | b02 << 15) ^ (b02 >>> 19 | b02 << 13) ^ b02 >>> 10) + this.buffer[i - 7] + ((b15 >>> 7 | b15 << 25) ^ (b15 >>> 18 | b15 << 14) ^ b15 >>> 3) + this.buffer[i - 16];
        }
        int a = this.h0;
        int b = this.h1;
        int c = this.h2;
        int d = this.h3;
        int e = this.h4;
        int f = this.h5;
        int g = this.h6;
        int h = this.h7;
        for (int i = 0; i < 64; ++i) {
            int T1 = ((e >>> 6 | e << 26) ^ (e >>> 11 | e << 21) ^ (e >>> 25 | e << 7)) + (e & f ^ ~e & g) + K[i] + this.buffer[i] + h;
            int T2 = ((a >>> 2 | a << 30) ^ (a >>> 13 | a << 19) ^ (a >>> 22 | a << 10)) + (a & b ^ a & c ^ b & c);
            h = g;
            g = f;
            f = e;
            e = d + T1;
            d = c;
            c = b;
            b = a;
            a = T1 + T2;
        }
        this.h0 += a;
        this.h1 += b;
        this.h2 += c;
        this.h3 += d;
        this.h4 += e;
        this.h5 += f;
        this.h6 += g;
        this.h7 += h;
    }

    private void pad() {
        long len = this.length * 8L;
        int pad = 4 - this.wordx;
        this.process(PAD_HEADER, 0, pad);
        while (this.bufx != 14) {
            this.buffer[this.bufx++] = 0;
            if (this.bufx != 16) continue;
            this.processBlock();
            this.bufx = 0;
        }
        this.buffer[this.bufx++] = (int)(len >> 32 & 0xFFFFFFFFFFFFFFFFL);
        this.buffer[this.bufx++] = (int)(len & 0xFFFFFFFFFFFFFFFFL);
        this.processBlock();
    }

    private void writeWord(byte[] to, int off, int word) {
        to[off++] = (byte)(word >> 24 & 0xFF);
        to[off++] = (byte)(word >> 16 & 0xFF);
        to[off++] = (byte)(word >> 8 & 0xFF);
        to[off++] = (byte)(word & 0xFF);
    }

    public static void main(String[] args) {
        SHA256 sha = null;
        sha = new SHA256();
        sha.process(SHA256.getBytes("abc"));
        System.out.println(Hex.toString(sha.hash()));
        sha = new SHA256();
        sha.process(SHA256.getBytes("abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"));
        System.out.println(Hex.toString(sha.hash()));
    }

    private static byte[] getBytes(String s) {
        byte[] arr = new byte[s.length()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)(s.charAt(i) & 0xFF);
        }
        return arr;
    }
}

