/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.crypto;

import com.elluminate.util.crypto.BlkCipher;
import com.elluminate.util.crypto.Hex;
import java.math.BigInteger;

public class AES
implements BlkCipher {
    public static final int AES_128 = 128;
    public static final int AES_192 = 192;
    public static final int AES_256 = 256;
    private static final int[] MASK = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    private static final byte b02 = 2;
    private static final byte b03 = 3;
    private static final byte b09 = 9;
    private static final byte b0b = 11;
    private static final byte b0d = 13;
    private static final byte b0e = 14;
    private static final byte[] E = AES.generateE();
    private static final int[] L = AES.generateL();
    private static final byte[] S;
    private static final byte[] invS;
    private static final byte[] inv;
    private static final byte[] powX;
    private static final int[] X2;
    private static final int[] X3;
    private static final int[] X9;
    private static final int[] XB;
    private static final int[] XD;
    private static final int[] XE;
    private int keyLen;
    private int nK;
    private int nR;
    private int nB = 4;
    private byte[] w;
    private byte[] state = new byte[this.nB * 4];
    private int init;
    private int delta;
    private int limit;
    private boolean encode;

    private void subBytes() {
        this.state[0] = S[this.state[0] & 0xFF];
        this.state[1] = S[this.state[1] & 0xFF];
        this.state[2] = S[this.state[2] & 0xFF];
        this.state[3] = S[this.state[3] & 0xFF];
        this.state[4] = S[this.state[4] & 0xFF];
        this.state[5] = S[this.state[5] & 0xFF];
        this.state[6] = S[this.state[6] & 0xFF];
        this.state[7] = S[this.state[7] & 0xFF];
        this.state[8] = S[this.state[8] & 0xFF];
        this.state[9] = S[this.state[9] & 0xFF];
        this.state[10] = S[this.state[10] & 0xFF];
        this.state[11] = S[this.state[11] & 0xFF];
        this.state[12] = S[this.state[12] & 0xFF];
        this.state[13] = S[this.state[13] & 0xFF];
        this.state[14] = S[this.state[14] & 0xFF];
        this.state[15] = S[this.state[15] & 0xFF];
    }

    private void shiftRows() {
        byte t = this.state[4];
        this.state[4] = this.state[5];
        this.state[5] = this.state[6];
        this.state[6] = this.state[7];
        this.state[7] = t;
        t = this.state[8];
        this.state[8] = this.state[10];
        this.state[10] = t;
        t = this.state[9];
        this.state[9] = this.state[11];
        this.state[11] = t;
        t = this.state[15];
        this.state[15] = this.state[14];
        this.state[14] = this.state[13];
        this.state[13] = this.state[12];
        this.state[12] = t;
    }

    private void mixColumns() {
        for (int c = 0; c < 4; ++c) {
            int sc0 = this.state[c] & 0xFF;
            int sc1 = this.state[c + 4] & 0xFF;
            int sc2 = this.state[c + 8] & 0xFF;
            int sc3 = this.state[c + 12] & 0xFF;
            int sp0 = X2[sc0] ^ X3[sc1] ^ sc2 ^ sc3;
            int sp1 = sc0 ^ X2[sc1] ^ X3[sc2] ^ sc3;
            int sp2 = sc0 ^ sc1 ^ X2[sc2] ^ X3[sc3];
            int sp3 = X3[sc0] ^ sc1 ^ sc2 ^ X2[sc3];
            this.state[c] = (byte)sp0;
            this.state[c + 4] = (byte)sp1;
            this.state[c + 8] = (byte)sp2;
            this.state[c + 12] = (byte)sp3;
        }
    }

    private byte[] keyExpansion(byte[] key, int nK, int nB, int nR) {
        byte[] w = new byte[nB * (nR + 1) * 4];
        byte[] temp = new byte[4];
        int limit = nB * (nR + 1);
        System.arraycopy(key, 0, w, 0, nK * 4);
        for (int i = nK; i < limit; ++i) {
            int off = (i - 1) * 4;
            temp[0] = w[off++];
            temp[1] = w[off++];
            temp[2] = w[off++];
            temp[3] = w[off++];
            if (i % nK == 0) {
                byte t = temp[0];
                temp[0] = temp[1];
                temp[1] = temp[2];
                temp[2] = temp[3];
                temp[3] = t;
                temp[0] = S[temp[0] & 0xFF];
                temp[1] = S[temp[1] & 0xFF];
                temp[2] = S[temp[2] & 0xFF];
                temp[3] = S[temp[3] & 0xFF];
                temp[0] = (byte)(temp[0] ^ powX[i / nK - 1]);
            } else if (nK > 6 && i % nK == 4) {
                temp[0] = S[temp[0] & 0xFF];
                temp[1] = S[temp[1] & 0xFF];
                temp[2] = S[temp[2] & 0xFF];
                temp[3] = S[temp[3] & 0xFF];
            }
            int base = i * 4;
            int prev = (i - nK) * 4;
            w[base++] = (byte)(w[prev++] ^ temp[0]);
            w[base++] = (byte)(w[prev++] ^ temp[1]);
            w[base++] = (byte)(w[prev++] ^ temp[2]);
            w[base++] = (byte)(w[prev++] ^ temp[3]);
        }
        return w;
    }

    private void invSubBytes() {
        this.state[0] = invS[this.state[0] & 0xFF];
        this.state[1] = invS[this.state[1] & 0xFF];
        this.state[2] = invS[this.state[2] & 0xFF];
        this.state[3] = invS[this.state[3] & 0xFF];
        this.state[4] = invS[this.state[4] & 0xFF];
        this.state[5] = invS[this.state[5] & 0xFF];
        this.state[6] = invS[this.state[6] & 0xFF];
        this.state[7] = invS[this.state[7] & 0xFF];
        this.state[8] = invS[this.state[8] & 0xFF];
        this.state[9] = invS[this.state[9] & 0xFF];
        this.state[10] = invS[this.state[10] & 0xFF];
        this.state[11] = invS[this.state[11] & 0xFF];
        this.state[12] = invS[this.state[12] & 0xFF];
        this.state[13] = invS[this.state[13] & 0xFF];
        this.state[14] = invS[this.state[14] & 0xFF];
        this.state[15] = invS[this.state[15] & 0xFF];
    }

    private void invShiftRows() {
        byte t = this.state[7];
        this.state[7] = this.state[6];
        this.state[6] = this.state[5];
        this.state[5] = this.state[4];
        this.state[4] = t;
        t = this.state[8];
        this.state[8] = this.state[10];
        this.state[10] = t;
        t = this.state[9];
        this.state[9] = this.state[11];
        this.state[11] = t;
        t = this.state[12];
        this.state[12] = this.state[13];
        this.state[13] = this.state[14];
        this.state[14] = this.state[15];
        this.state[15] = t;
    }

    private void invMixColumns() {
        for (int c = 0; c < 4; ++c) {
            int sc0 = this.state[c] & 0xFF;
            int sc1 = this.state[c + 4] & 0xFF;
            int sc2 = this.state[c + 8] & 0xFF;
            int sc3 = this.state[c + 12] & 0xFF;
            int sp0 = XE[sc0] ^ XB[sc1] ^ XD[sc2] ^ X9[sc3];
            int sp1 = X9[sc0] ^ XE[sc1] ^ XB[sc2] ^ XD[sc3];
            int sp2 = XD[sc0] ^ X9[sc1] ^ XE[sc2] ^ XB[sc3];
            int sp3 = XB[sc0] ^ XD[sc1] ^ X9[sc2] ^ XE[sc3];
            this.state[c] = (byte)sp0;
            this.state[c + 4] = (byte)sp1;
            this.state[c + 8] = (byte)sp2;
            this.state[c + 12] = (byte)sp3;
        }
    }

    public AES(int mode) {
        switch (mode) {
            case 128: {
                this.keyLen = mode;
                this.nK = 4;
                this.nR = 10;
                break;
            }
            case 192: {
                this.keyLen = mode;
                this.nK = 6;
                this.nR = 12;
                break;
            }
            case 256: {
                this.keyLen = mode;
                this.nK = 8;
                this.nR = 14;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported AES mode.");
            }
        }
    }

    @Override
    public String getName() {
        return "AES-" + this.keyLen;
    }

    @Override
    public int getKeyLength() {
        return this.nK * 32;
    }

    @Override
    public int getKeyByteLength() {
        return this.nK * 4;
    }

    @Override
    public int getBlockLength() {
        return this.nB * 32;
    }

    @Override
    public int getBlockByteLength() {
        return this.nB * 4;
    }

    @Override
    public void init(byte[] key, boolean encipher) {
        this.encode = encipher;
        if (encipher) {
            this.init = 0;
            this.delta = 1;
            this.limit = this.nR;
        } else {
            this.init = this.nR;
            this.delta = -1;
            this.limit = 0;
        }
        this.w = this.keyExpansion(key, this.nK, this.nB, this.nR);
    }

    @Override
    public void processBlock(byte[] plain, int plainOff, byte[] cipher, int cipherOff) {
        this.copyIn(plain, plainOff, this.state);
        if (this.encode) {
            this.addRoundKey(this.w, 0);
            for (int r = 1; r < this.nR; ++r) {
                this.subBytes();
                this.shiftRows();
                this.mixColumns();
                this.addRoundKey(this.w, r);
            }
            this.shiftRows();
            this.subBytes();
            this.addRoundKey(this.w, this.nR);
        } else {
            this.addRoundKey(this.w, this.nR);
            for (int r = this.nR - 1; r > 0; --r) {
                this.invShiftRows();
                this.invSubBytes();
                this.addRoundKey(this.w, r);
                this.invMixColumns();
            }
            this.invShiftRows();
            this.invSubBytes();
            this.addRoundKey(this.w, 0);
        }
        this.copyOut(this.state, cipher, cipherOff);
    }

    @Override
    public void processBlock(byte[] plain, int off) {
        this.processBlock(plain, off, plain, off);
    }

    private void copyIn(byte[] in, int off, byte[] state) {
        state[0] = in[off++];
        state[4] = in[off++];
        state[8] = in[off++];
        state[12] = in[off++];
        state[1] = in[off++];
        state[5] = in[off++];
        state[9] = in[off++];
        state[13] = in[off++];
        state[2] = in[off++];
        state[6] = in[off++];
        state[10] = in[off++];
        state[14] = in[off++];
        state[3] = in[off++];
        state[7] = in[off++];
        state[11] = in[off++];
        state[15] = in[off++];
    }

    private void copyOut(byte[] state, byte[] out, int off) {
        out[off++] = state[0];
        out[off++] = state[4];
        out[off++] = state[8];
        out[off++] = state[12];
        out[off++] = state[1];
        out[off++] = state[5];
        out[off++] = state[9];
        out[off++] = state[13];
        out[off++] = state[2];
        out[off++] = state[6];
        out[off++] = state[10];
        out[off++] = state[14];
        out[off++] = state[3];
        out[off++] = state[7];
        out[off++] = state[11];
        out[off++] = state[15];
    }

    private void addRoundKey(byte[] w, int rnd) {
        int base = rnd * this.nB * 4;
        this.state[0] = (byte)(this.state[0] ^ w[base++]);
        this.state[4] = (byte)(this.state[4] ^ w[base++]);
        this.state[8] = (byte)(this.state[8] ^ w[base++]);
        this.state[12] = (byte)(this.state[12] ^ w[base++]);
        this.state[1] = (byte)(this.state[1] ^ w[base++]);
        this.state[5] = (byte)(this.state[5] ^ w[base++]);
        this.state[9] = (byte)(this.state[9] ^ w[base++]);
        this.state[13] = (byte)(this.state[13] ^ w[base++]);
        this.state[2] = (byte)(this.state[2] ^ w[base++]);
        this.state[6] = (byte)(this.state[6] ^ w[base++]);
        this.state[10] = (byte)(this.state[10] ^ w[base++]);
        this.state[14] = (byte)(this.state[14] ^ w[base++]);
        this.state[3] = (byte)(this.state[3] ^ w[base++]);
        this.state[7] = (byte)(this.state[7] ^ w[base++]);
        this.state[11] = (byte)(this.state[11] ^ w[base++]);
        this.state[15] = (byte)(this.state[15] ^ w[base++]);
    }

    private static byte FFMul(byte l, byte r) {
        int t = 0;
        if (l == 0 || r == 0) {
            return 0;
        }
        t = L[l & 0xFF] + L[r & 0xFF];
        if (t > 255) {
            t -= 255;
        }
        return E[t];
    }

    private static byte gfMult(byte l, byte r) {
        byte a = l;
        byte b = r;
        byte t = 0;
        byte x = 0;
        while (a != 0) {
            if ((a & 1) != 0) {
                x = (byte)(x ^ b);
            }
            t = (byte)(b & 0x80);
            b = (byte)(b << 1);
            if (t != 0) {
                b = (byte)(b ^ 0x1B);
            }
            a = (byte)((a & 0xFF) >> 1);
        }
        return x;
    }

    private static byte[] generateE() {
        byte[] e = new byte[256];
        byte x = 1;
        int idx = 0;
        e[idx++] = x;
        for (int i = 0; i < 255; ++i) {
            x = AES.gfMult(x, (byte)3);
            e[idx++] = x;
        }
        return e;
    }

    private static int[] generateL() {
        int[] l = new int[256];
        for (int i = 255; i >= 0; --i) {
            l[AES.E[i] & 0xFF] = i;
        }
        return l;
    }

    private static byte[] generateInv() {
        byte[] v = new byte[256];
        for (int i = 1; i < 256; ++i) {
            v[i] = E[255 - L[i]];
        }
        return v;
    }

    private static byte[] generateS() {
        int c = 99;
        byte[] s = new byte[256];
        for (int i = 0; i < 256; ++i) {
            byte b = (byte)i;
            int res = 0;
            if (b != 0) {
                b = inv[b & 0xFF];
            }
            for (int n = 0; n < 8; ++n) {
                int tmp = 0;
                tmp = AES.nthBit(b, n) ^ AES.nthBit(b, (n + 4) % 8) ^ AES.nthBit(b, (n + 5) % 8) ^ AES.nthBit(b, (n + 6) % 8) ^ AES.nthBit(b, (n + 7) % 8);
                res = (byte)(res | tmp << n);
            }
            s[i] = (byte)(res ^ c);
        }
        return s;
    }

    private static int nthBit(byte b, int n) {
        return (b & MASK[n]) >> n;
    }

    private static byte[] generateInvS() {
        byte[] is = new byte[256];
        for (int i = 0; i < 256; ++i) {
            is[AES.S[i] & 0xFF] = (byte)i;
        }
        return is;
    }

    private static byte[] generatePowX() {
        byte x;
        byte[] xp = new byte[15];
        byte px = x = 2;
        xp[0] = 1;
        xp[1] = x;
        for (int i = 2; i < 15; ++i) {
            xp[i] = px = AES.FFMul(px, x);
        }
        return xp;
    }

    private static int[] generateX(byte mult) {
        int[] x = new int[256];
        for (int i = 0; i < 256; ++i) {
            x[i] = AES.FFMul(mult, (byte)i) & 0xFF;
        }
        return x;
    }

    public static void main(String[] args) {
        BigInteger k256 = new BigInteger("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", 16);
        BigInteger k192 = new BigInteger("000102030405060708090a0b0c0d0e0f1011121314151617", 16);
        BigInteger k128 = new BigInteger("000102030405060708090a0b0c0d0e0f", 16);
        BigInteger block = new BigInteger("00112233445566778899aabbccddeeff", 16);
        byte[] in = AES.getBytes(block, 16);
        byte[] ct = new byte[16];
        byte[] pt = new byte[16];
        AES aes128 = new AES(128);
        byte[] key = AES.getBytes(k128, 16);
        aes128.init(key, true);
        aes128.processBlock(in, 0, ct, 0);
        aes128.init(key, false);
        aes128.processBlock(ct, 0, pt, 0);
        System.out.println("AES-128:");
        System.out.println(Hex.toString(in));
        System.out.println(Hex.toString(ct));
        System.out.println(Hex.toString(pt));
        AES aes192 = new AES(192);
        key = AES.getBytes(k192, 24);
        aes192.init(key, true);
        aes192.processBlock(in, 0, ct, 0);
        aes192.init(key, false);
        aes192.processBlock(ct, 0, pt, 0);
        System.out.println("AES-192:");
        System.out.println(Hex.toString(in));
        System.out.println(Hex.toString(ct));
        System.out.println(Hex.toString(pt));
        AES aes256 = new AES(256);
        key = AES.getBytes(k256, 32);
        aes256.init(key, true);
        aes256.processBlock(in, 0, ct, 0);
        aes256.init(key, false);
        aes256.processBlock(ct, 0, pt, 0);
        System.out.println("AES-256:");
        System.out.println(Hex.toString(in));
        System.out.println(Hex.toString(ct));
        System.out.println(Hex.toString(pt));
    }

    private static byte[] getBytes(BigInteger bi, int nBytes) {
        byte[] raw = bi.toByteArray();
        if (raw.length == nBytes) {
            return raw;
        }
        byte[] cooked = new byte[nBytes];
        int coff = Math.max(nBytes - raw.length, 0);
        int roff = Math.max(raw.length - nBytes, 0);
        int len = Math.min(nBytes, raw.length);
        System.arraycopy(raw, roff, cooked, coff, len);
        if (raw[0] < 0 && len < nBytes) {
            for (int i = 0; i < coff; ++i) {
                cooked[i] = -1;
            }
        }
        return cooked;
    }

    static {
        inv = AES.generateInv();
        S = AES.generateS();
        invS = AES.generateInvS();
        powX = AES.generatePowX();
        X2 = AES.generateX((byte)2);
        X3 = AES.generateX((byte)3);
        X9 = AES.generateX((byte)9);
        XB = AES.generateX((byte)11);
        XD = AES.generateX((byte)13);
        XE = AES.generateX((byte)14);
    }
}

