/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.command;

import com.elluminate.util.QuotedStringTokenizer;
import com.elluminate.util.TuningParam;
import com.elluminate.util.UnknownTuningParamException;
import com.elluminate.util.command.CmdResponses;
import com.elluminate.util.command.CommandAdapter;
import com.elluminate.util.command.CommandProcessor;

public class TuningCmd
extends CommandAdapter
implements CmdResponses {
    public TuningCmd() {
        this.setUsage("usage: @ <param name> {<new param value>}");
        this.setDescription("View or set tuning parameters for the server.");
    }

    @Override
    public void execute(CommandProcessor cp, String cmd, QuotedStringTokenizer args) {
        TuningParam tp;
        if (!args.hasMoreTokens()) {
            this.sendResponse(401, this.getUsage(cmd));
            return;
        }
        String name = args.nextToken();
        try {
            tp = TuningParam.get(name);
        }
        catch (UnknownTuningParamException utpx) {
            this.sendResponse(400, "Unknown tuning parameter '" + name + "'");
            return;
        }
        if (args.hasMoreTokens()) {
            try {
                tp.setValue(args.nextToken());
                this.sendResponse(200, name + "=" + tp.getValue());
            }
            catch (IllegalArgumentException iax) {
                this.sendResponse(400, iax.getMessage());
            }
            catch (Throwable t) {
                this.sendResponse(400, "Error setting tuning parameter '" + name + "':\n" + t);
            }
        } else {
            this.sendResponse(200, name + "=" + tp.getValue());
        }
    }
}

