/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.command;

import com.elluminate.util.QuotedStringTokenizer;
import com.elluminate.util.StringComparator;
import com.elluminate.util.command.CmdResponses;
import com.elluminate.util.command.Command;
import com.elluminate.util.command.CommandAdapter;
import com.elluminate.util.log.LogSupport;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class CommandProcessor
implements CmdResponses {
    private String prompt = ">> ";
    protected PrintStream out = LogSupport.getSystemOut();
    protected PrintStream err = LogSupport.getSystemErr();
    private BufferedReader console;
    private TreeMap commands = new TreeMap(new StringComparator());
    private volatile boolean done = false;
    private Command unknownCmd = null;
    private Command helpCmd = null;
    private boolean printPrompt = true;
    private ByteArrayOutputStream directBytes = new ByteArrayOutputStream();
    private PrintStream directOut;

    public CommandProcessor() {
        InputStreamReader reader = new InputStreamReader(System.in);
        this.console = new BufferedReader(reader);
        this.unknownCmd = new CommandAdapter(){

            @Override
            public void execute(CommandProcessor cp, String cmd, QuotedStringTokenizer args) {
                this.beginResponse(400, "UnknownCommand - " + cmd);
                this.appendResponse("Type 'help' for a list of commands.");
                this.endResponse();
            }
        };
        this.helpCmd = new CommandAdapter(){

            @Override
            public void execute(CommandProcessor cp, String cmd, QuotedStringTokenizer args) {
                if (args.hasMoreTokens()) {
                    String which = args.nextToken();
                    Command what = cp.getCommand(which);
                    if (what == null) {
                        this.beginResponse(401, "Unknown command - " + which);
                        this.appendResponse("Type 'help' for a list of commands.");
                        this.endResponse();
                    } else {
                        this.sendResponse(200, what.getUsage(which));
                    }
                } else {
                    Set keys = CommandProcessor.this.commands.keySet();
                    Iterator i = keys.iterator();
                    this.beginResponse(200, "List of available commands:");
                    while (i.hasNext()) {
                        String which = (String)i.next();
                        Command what = (Command)CommandProcessor.this.commands.get(which);
                        StringBuffer msg = new StringBuffer("  ");
                        if (what.getDescription() == null) continue;
                        msg.append(which);
                        for (int w = 0; w < 22 - which.length(); ++w) {
                            msg.append(" ");
                        }
                        msg.append(what.getDescription());
                        this.appendResponse(msg.toString());
                    }
                    this.endResponse();
                }
            }
        };
        try {
            this.directOut = new PrintStream((OutputStream)this.directBytes, true, "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            this.directOut = new PrintStream(this.directBytes);
        }
    }

    public void setReader(BufferedReader in) {
        Iterator i = this.commands.values().iterator();
        if (in == null) {
            in = new BufferedReader(new InputStreamReader(System.in));
        }
        this.console = in;
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            cmd.setReader(this.console);
        }
        this.unknownCmd.setReader(this.console);
        this.helpCmd.setReader(this.console);
    }

    public BufferedReader getReader() {
        return this.console;
    }

    public void setOutputStream(PrintStream out) {
        Iterator i = this.commands.values().iterator();
        if (out == null) {
            out = LogSupport.getSystemOut();
        }
        this.out = out;
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            cmd.setOutputStream(out);
        }
        this.unknownCmd.setOutputStream(out);
        this.helpCmd.setOutputStream(out);
    }

    public PrintStream getOutputStream() {
        return this.out;
    }

    public void setErrorStream(PrintStream err) {
        Iterator i = this.commands.values().iterator();
        if (err == null) {
            err = LogSupport.getSystemErr();
        }
        this.err = err;
        while (i.hasNext()) {
            Command cmd = (Command)i.next();
            cmd.setErrorStream(err);
        }
        this.unknownCmd.setErrorStream(err);
        this.helpCmd.setErrorStream(err);
    }

    public PrintStream getErrorStream() {
        return this.err;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void addCommand(String name, Command cmd) {
        cmd.setReader(this.console);
        cmd.setOutputStream(this.out);
        cmd.setErrorStream(this.err);
        this.commands.put(name, cmd);
    }

    public Command removeCommand(String name) {
        return (Command)this.commands.remove(name);
    }

    public Command getCommand(String name) {
        return (Command)this.commands.get(name);
    }

    Command findCommand(String name) {
        Command cmd = this.getCommand(name);
        if (cmd != null) {
            return cmd;
        }
        if ("help".equals(name)) {
            return this.helpCmd;
        }
        return this.unknownCmd;
    }

    public Iterator iterator() {
        return this.commands.keySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        this.done = false;
        this.printPrompt = true;
        while (!this.done && !this.commands.isEmpty()) {
            String line;
            if (this.printPrompt) {
                this.out.print(this.prompt);
            }
            if ((line = this.console.readLine()) == null) {
                throw new EOFException();
            }
            this.printPrompt = true;
            try {
                Command cmd;
                QuotedStringTokenizer parser = new QuotedStringTokenizer(line);
                if (!parser.hasMoreTokens()) continue;
                String name = parser.nextToken();
                Command command = cmd = this.findCommand(name);
                synchronized (command) {
                    cmd.execute(this, name, parser);
                }
            }
            catch (Exception e) {
                e.printStackTrace(LogSupport.getSystemErr());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(String line) {
        String response;
        Command cmd;
        QuotedStringTokenizer parser = new QuotedStringTokenizer(line);
        if (!parser.hasMoreTokens()) {
            return "";
        }
        String name = parser.nextToken();
        Command command = cmd = this.findCommand(name);
        synchronized (command) {
            cmd.setOutputStream(this.directOut);
            cmd.setErrorStream(this.directOut);
            cmd.execute(this, name, parser);
            cmd.setOutputStream(this.out);
            cmd.setErrorStream(this.err);
        }
        try {
            response = this.directBytes.toString("UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            response = this.directBytes.toString();
        }
        this.directBytes.reset();
        return response.trim();
    }

    public void suppressPrompt() {
        this.printPrompt = false;
    }

    public void stop() {
        this.done = true;
    }
}

