/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util.browser;

import com.elluminate.platform.Platform;
import com.elluminate.util.browser.AbstractUnixExternalBrowser;
import com.elluminate.util.browser.ExternalBrowser;
import com.elluminate.util.browser.FirefoxUnixExternalBrowser;
import com.elluminate.util.browser.KonquerorUnixExternalBrowser;
import com.elluminate.util.browser.MacOSXExternalBrowser;
import com.elluminate.util.browser.NetscapeUnixExternalBrowser;
import com.elluminate.util.browser.OperaUnixExternalBrowser;
import com.elluminate.util.browser.SdtWebClientUnixExternalBrowser;
import com.elluminate.util.browser.WindowsExternalBrowser;
import java.io.IOException;
import java.util.ArrayList;

public class BrowserLauncher {
    private static ExternalBrowser browser = null;

    private BrowserLauncher() {
    }

    private static ExternalBrowser locateBrowser() {
        if (browser != null) {
            return browser;
        }
        switch (Platform.getPlatform()) {
            case 2: {
                browser = new MacOSXExternalBrowser();
                break;
            }
            case 1: {
                browser = new WindowsExternalBrowser();
                break;
            }
            case 3: {
                ArrayList<AbstractUnixExternalBrowser> possibleBrowsers = new ArrayList<AbstractUnixExternalBrowser>();
                possibleBrowsers.add(new SdtWebClientUnixExternalBrowser());
                possibleBrowsers.add(new FirefoxUnixExternalBrowser());
                possibleBrowsers.add(new OperaUnixExternalBrowser());
                possibleBrowsers.add(new KonquerorUnixExternalBrowser());
                possibleBrowsers.add(new NetscapeUnixExternalBrowser());
                ExternalBrowser b = null;
                while (browser == null && possibleBrowsers.size() > 0) {
                    b = (ExternalBrowser)possibleBrowsers.remove(0);
                    if (!b.isAvailable()) continue;
                    browser = b;
                }
                break;
            }
            default: {
                browser = null;
            }
        }
        return browser;
    }

    public static void openURL(String url) throws IOException {
        if (browser == null) {
            throw new IOException("Unable to locate browser");
        }
        browser.launch(url);
    }

    static {
        browser = BrowserLauncher.locateBrowser();
    }
}

