/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.Debug;
import com.elluminate.util.TimerQueueElement;
import com.elluminate.util.log.LogSupport;

public class TimerQueue {
    private TimerQueueElement queueHead = null;
    private TimerQueueElement queueTail = null;
    private boolean shutdown = false;

    private boolean fireNow(long now) {
        if (this.queueHead != null) {
            return this.queueHead.getTime() <= now;
        }
        return false;
    }

    public long fireIn(long now) {
        if (this.queueHead == null) {
            return 999999999L;
        }
        return Math.max(0L, this.queueHead.getTime() - now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        Runnable event = null;
        Debug.lockEnter(this, "run", null, this);
        TimerQueue timerQueue = this;
        synchronized (timerQueue) {
            long now = System.currentTimeMillis();
            while (!this.fireNow(now) && !this.shutdown) {
                try {
                    this.wait(this.fireIn(now));
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                now = System.currentTimeMillis();
            }
            if (!this.shutdown) {
                event = this.queueHead.getRunnable();
                this.remove();
            }
        }
        Debug.lockLeave(this, "run", null, this);
        if (event != null) {
            try {
                event.run();
            }
            catch (Throwable t) {
                LogSupport.exception(this, "run", t, true);
            }
        }
        return event != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRunnable(long time, Object id, Runnable runnable) {
        Debug.lockEnter(this, "addRunnable", null, this);
        TimerQueue timerQueue = this;
        synchronized (timerQueue) {
            if (this.shutdown) {
                return;
            }
            this.remove(id);
            TimerQueueElement element = new TimerQueueElement(time, id, runnable);
            if (this.queueHead == null) {
                this.queueHead = element;
                this.queueTail = element;
            } else if (this.queueTail.getTime() <= time) {
                element.setPrev(this.queueTail);
                this.queueTail.setNext(element);
                this.queueTail = element;
            } else {
                TimerQueueElement test;
                for (test = this.queueHead; test != null && test.getTime() <= time; test = test.next()) {
                }
                if (test == null) {
                    element.setPrev(this.queueTail);
                    this.queueTail.setNext(element);
                    this.queueTail = element;
                } else {
                    element.setPrev(test.prev());
                    element.setNext(test);
                    if (test.prev() != null) {
                        test.prev().setNext(element);
                    } else {
                        this.queueHead = element;
                    }
                    test.setPrev(element);
                }
            }
            this.notify();
        }
        Debug.lockLeave(this, "addRunnable", null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        Debug.lockEnter(this, "remove", null, this);
        TimerQueue timerQueue = this;
        synchronized (timerQueue) {
            this.remove(this.queueHead);
        }
        Debug.lockLeave(this, "remove", null, this);
    }

    private void remove(TimerQueueElement element) {
        if (this.queueHead == null || element == null) {
            return;
        }
        if (element.prev() == null) {
            this.queueHead = element.next();
        } else {
            element.prev().setNext(element.next());
        }
        if (element.next() == null) {
            this.queueTail = element.prev();
        } else {
            element.next().setPrev(element.prev());
        }
        if (this.queueHead == null) {
            this.queueTail = null;
        }
        element.setNext(null);
        element.setPrev(null);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object id) {
        Debug.lockEnter(this, "remove", null, this);
        try {
            TimerQueue timerQueue = this;
            synchronized (timerQueue) {
                TimerQueueElement element = this.queueHead;
                while (element != null && element.getID() != null && !element.getID().equals(id)) {
                    if ((element = element.next()) != null) continue;
                    return;
                }
                this.remove(element);
            }
        }
        finally {
            Debug.lockLeave(this, "remove", null, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Debug.lockEnter(this, "shutdown", null, this);
        TimerQueue timerQueue = this;
        synchronized (timerQueue) {
            this.shutdown = true;
            this.queueHead = null;
            this.queueTail = null;
            this.notify();
        }
        Debug.lockLeave(this, "shutdown", null, this);
    }
}

