/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ThreadDump;
import com.elluminate.util.WorkerThread;
import com.elluminate.util.log.LogSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class ThreadUtils {
    private static ThreadMXBean threadMXBean = null;
    private static volatile DeadlockTrackerThread deadlockTracker = null;

    private ThreadUtils() {
    }

    public static String getStackTrace(Thread t) {
        return ThreadUtils.getStackTrace(t, "");
    }

    public static String getStackTrace(Thread t, String indent) {
        String result;
        block4: {
            result = null;
            try {
                StackTraceElement[] stack = t.getStackTrace();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement frm : stack) {
                    if (sb.length() > 0) {
                        sb.append("\n");
                    }
                    sb.append(indent);
                    sb.append(frm);
                }
                result = sb.toString();
            }
            catch (Throwable ex) {
                if (ex instanceof SecurityException) break block4;
                LogSupport.exception(ThreadUtils.class, "getStackTrace", ex, true, "Error getting stack trace for thread: " + t);
            }
        }
        return result;
    }

    public static ThreadInfo getThreadInfo(Thread t) {
        if (threadMXBean == null) {
            return null;
        }
        try {
            return threadMXBean.getThreadInfo(t.getId());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getThreadBlockingInfo(Thread t) {
        if (threadMXBean == null) {
            return null;
        }
        ThreadInfo tinfo = threadMXBean.getThreadInfo(t.getId());
        if (tinfo == null) {
            return null;
        }
        String name = tinfo.getLockName();
        String owner = tinfo.getLockOwnerName();
        return "lock=" + name + " owner=" + owner;
    }

    public static boolean isDeadlockDetectionSupported() {
        if (threadMXBean == null) {
            return false;
        }
        try {
            return threadMXBean.isThreadContentionMonitoringSupported();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isDeadlockDetectionEnabled() {
        if (threadMXBean == null) {
            return false;
        }
        try {
            return threadMXBean.isThreadContentionMonitoringEnabled();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void setDeadlockDetectionEnabled(boolean b) {
        if (threadMXBean == null) {
            return;
        }
        try {
            threadMXBean.setThreadContentionMonitoringEnabled(b);
            if (b) {
                LogSupport.message(ThreadUtils.class, "setDeadlockDetectionEnabled", "Deadlock detection enabled.");
            } else {
                LogSupport.message(ThreadUtils.class, "setDeadlockDetectionEnabled", "Deadlock detection disabled.");
            }
        }
        catch (Throwable t) {
            LogSupport.message(ThreadUtils.class, "setDeadlockDetectionEnabled", "Failed to " + (b ? "enable" : "disable") + " deadlock detection: " + t);
        }
    }

    public static String reportDeadlocks(ArrayList<Long> knownDeadlocks) {
        if (threadMXBean == null) {
            return null;
        }
        long[] threads = null;
        try {
            threads = threadMXBean.findMonitorDeadlockedThreads();
        }
        catch (Throwable t) {
            return null;
        }
        if (threads == null || threads.length == 0) {
            return null;
        }
        final ArrayList<Long> dumpIDs = new ArrayList<Long>(threads.length);
        for (int ix = 0; ix < threads.length; ++ix) {
            boolean found = false;
            if (knownDeadlocks != null) {
                Iterator<Long> itr = knownDeadlocks.iterator();
                while (!found && itr.hasNext()) {
                    found = threads[ix] == itr.next();
                }
            }
            if (found) continue;
            dumpIDs.add(new Long(threads[ix]));
        }
        if (dumpIDs.size() == 0) {
            return null;
        }
        if (knownDeadlocks != null) {
            knownDeadlocks.addAll(dumpIDs);
        }
        ThreadDump.ThreadDumpFilter filter = new ThreadDump.ThreadDumpFilter(){

            @Override
            public boolean include(Thread t) {
                long id = t.getId();
                for (int ix = 0; ix < dumpIDs.size(); ++ix) {
                    if (((Number)dumpIDs.get(ix)).longValue() != id) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "Deadlocked threads: " + dumpIDs;
            }
        };
        StringWriter writer = new StringWriter();
        ThreadDump.print(new PrintWriter(writer), filter);
        writer.flush();
        return "Found " + dumpIDs.size() + " new deadlocked threads (" + threads.length + " total deadlocked):\n" + writer.toString();
    }

    public static boolean isTrackingDeadlocksSupported() {
        return threadMXBean != null;
    }

    public static synchronized boolean isTrackingDeadlocksEnabled() {
        return deadlockTracker != null && deadlockTracker.isChecking() && deadlockTracker.isAlive();
    }

    public static synchronized void setTrackingDeadlocksEnabled(boolean trackingEnabled) {
        boolean checking = trackingEnabled;
        if (deadlockTracker != null) {
            deadlockTracker.setChecking(checking);
        }
        if (checking && (deadlockTracker == null || !deadlockTracker.isAlive())) {
            deadlockTracker = new DeadlockTrackerThread();
            deadlockTracker.start();
        }
    }

    static {
        try {
            threadMXBean = ManagementFactory.getThreadMXBean();
        }
        catch (Throwable t) {
            threadMXBean = null;
        }
    }

    private static class DeadlockTrackerThread
    extends WorkerThread {
        private volatile boolean checking = true;

        DeadlockTrackerThread() {
            super("Deadlock Tracking Thread", 1);
            this.setDaemon(true);
        }

        public boolean isChecking() {
            return this.checking;
        }

        public void setChecking(boolean b) {
            this.checking = b;
            if (!this.checking) {
                this.interrupt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Long> knownDeadlocks = new ArrayList<Long>();
            LogSupport.message(this, "run", "DeadlockTrackerThread starting: " + this);
            try {
                while (this.checking) {
                    String report = ThreadUtils.reportDeadlocks(knownDeadlocks);
                    if (report != null) {
                        LogSupport.error(this, "run", report);
                    }
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException intx) {
                        break;
                    }
                }
            }
            finally {
                LogSupport.message(this, "run", "DeadlockTrackerThread exiting: " + this);
            }
        }
    }
}

