/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.ThreadUtils;
import com.elluminate.util.log.LogSupport;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

public class ThreadDump {
    private ThreadDump() {
    }

    public static boolean isAvailable() {
        return true;
    }

    public static void print() {
        ThreadDump.printDump(new Printer(), null);
    }

    public static void print(ThreadGroup group) {
        ThreadDump.printDump(new Printer(), new GroupFilter(group));
    }

    public static void print(ThreadDumpFilter filter) {
        ThreadDump.printDump(new Printer(), filter);
    }

    public static void print(Thread t) {
        ThreadDump.printThread(new Printer(), t);
    }

    public static void print(PrintStream str) {
        ThreadDump.printDump(new Printer(str), null);
    }

    public static void print(PrintStream str, ThreadGroup group) {
        ThreadDump.printDump(new Printer(str), new GroupFilter(group));
    }

    public static void print(PrintStream str, ThreadDumpFilter filter) {
        ThreadDump.printDump(new Printer(str), filter);
    }

    public static void print(PrintStream str, Thread t) {
        ThreadDump.printThread(new Printer(str), t);
    }

    public static void print(PrintWriter wrt) {
        ThreadDump.printDump(new Printer(wrt), null);
    }

    public static void print(PrintWriter wrt, ThreadGroup group) {
        ThreadDump.printDump(new Printer(wrt), new GroupFilter(group));
    }

    public static void print(PrintWriter wrt, ThreadDumpFilter filter) {
        ThreadDump.printDump(new Printer(wrt), filter);
    }

    public static void print(PrintWriter wrt, Thread t) {
        ThreadDump.printThread(new Printer(wrt), t);
    }

    public static void print(File f) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        ThreadDump.print(pw);
        pw.close();
    }

    public static void print(File f, ThreadGroup group) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        ThreadDump.print(pw, group);
        pw.close();
    }

    public static void print(File f, ThreadDumpFilter filter) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        ThreadDump.print(pw, filter);
        pw.close();
    }

    public static void print(File f, Thread t) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(f));
        ThreadDump.print(pw, t);
        pw.close();
    }

    private static void printDump(Printer p, ThreadDumpFilter filter) {
        Map map = ThreadDump.getDump();
        p.println("----- Thread Dump" + (filter == null ? "" : " " + filter));
        for (Thread t : map.keySet()) {
            Object[] o = (Object[])map.get(t);
            if (filter != null && !filter.include(t)) continue;
            ThreadDump.printThread(p, t, o);
        }
        p.println("----- End Thread Dump");
    }

    private static void printThread(Printer p, Thread t) {
        Object[] frames = ThreadDump.getFrames(t);
        ThreadDump.printThread(p, t, frames);
    }

    private static void printThread(Printer p, Thread t, Object[] dump) {
        p.println(t.toString() + "  " + ThreadUtils.getThreadInfo(t));
        for (int frm = 0; frm < dump.length; ++frm) {
            p.println("    " + dump[frm]);
        }
    }

    private static Map getDump() {
        try {
            return Thread.getAllStackTraces();
        }
        catch (Throwable t) {
            return new HashMap();
        }
    }

    private static Object[] getFrames(Thread t) {
        try {
            return t.getStackTrace();
        }
        catch (Throwable throwable) {
            return new Object[0];
        }
    }

    static class GroupFilter
    implements ThreadDumpFilter {
        ThreadGroup group = null;

        GroupFilter(ThreadGroup group) {
            this.group = group;
        }

        @Override
        public boolean include(Thread t) {
            return this.group.parentOf(t.getThreadGroup());
        }

        public String toString() {
            return this.group == null ? this.getClass().getName() + "#" + this.hashCode() : this.group.toString();
        }
    }

    static class Printer {
        private PrintWriter pw = null;
        private PrintStream ps = null;

        public Printer(PrintWriter pw) {
            this.pw = pw;
        }

        public Printer(PrintStream ps) {
            this.ps = ps;
        }

        public Printer() {
        }

        public void println(String s) {
            if (this.ps != null) {
                this.ps.println(s);
            } else if (this.pw != null) {
                this.pw.println(s);
            } else {
                LogSupport.message(s);
            }
        }
    }

    public static interface ThreadDumpFilter {
        public boolean include(Thread var1);
    }
}

