/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.SerializerThread;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.UtilDebug;
import com.elluminate.util.log.LogSupport;

public abstract class SwingRunnerSupport {
    private static volatile SwingRunner instance = null;
    private static final String SWING_IMPL = "com.elluminate.gui.SwingRunnerExecute";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SwingRunner getInstance() {
        if (instance != null) return instance;
        Class<SwingRunner> clazz = SwingRunner.class;
        synchronized (SwingRunner.class) {
            if (instance != null) return instance;
            instance = SwingRunnerSupport.factory(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceStart(ThreadGroup grp) {
        Class<SwingRunner> clazz = SwingRunner.class;
        synchronized (SwingRunner.class) {
            instance = SwingRunnerSupport.factory(grp);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void invokeLater(Runnable r) {
        SwingRunnerSupport.getInstance().invokeLater(r);
    }

    public static void invokeAndWait(Runnable r) throws InterruptedException {
        SwingRunnerSupport.getInstance().invokeAndWait(r);
    }

    public static void invokeOnEventThread(Runnable r) {
        SwingRunnerSupport.getInstance().invokeOnEventThread(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(SwingRunner impl) {
        Class<SwingRunner> clazz = SwingRunner.class;
        synchronized (SwingRunner.class) {
            instance = impl;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static SwingRunner factory(ThreadGroup grp) {
        SwingRunner result = null;
        try {
            Class<?> cls = Class.forName(SWING_IMPL);
            SwingRunner impl = (SwingRunner)cls.newInstance();
            if (impl != null) {
                result = impl;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (result == null) {
            result = new DefaultImpl(grp);
        }
        return result;
    }

    public static class DefaultImpl
    implements SwingRunner {
        private final SerializerThread thread;

        public DefaultImpl() {
            this(Thread.currentThread().getThreadGroup());
        }

        private DefaultImpl(ThreadGroup grp) {
            this.thread = new SerializerThread("SwingRunner EDT Simulant", grp);
        }

        @Override
        public void invokeLater(Runnable r) {
            this.thread.invokeLater(new SwingWrapper(r));
        }

        @Override
        public void invokeAndWait(Runnable r) throws InterruptedException {
            try {
                this.thread.invokeAndWait(new SwingWrapper(r));
            }
            catch (Throwable t) {
                Throwable cause = t.getCause();
                if (cause != null) {
                    LogSupport.exception(this, "invokeAndWait", cause, false, "Processing: " + r);
                }
                LogSupport.exception(this, "invokeAndWait", t, false, "Processing: " + r);
            }
        }

        @Override
        public void invokeOnEventThread(Runnable r) {
            SwingWrapper r2 = new SwingWrapper(r);
            if (this.thread.isProcessingThread()) {
                r2.run();
            } else {
                this.thread.invokeLater(r2);
            }
        }

        @Override
        public boolean isEventDispatchThread() {
            return false;
        }
    }

    private static class SwingWrapper
    implements Runnable {
        private final Runnable r;
        private final long timestamp;

        public SwingWrapper(Runnable r) {
            if (r == null) {
                throw new NullPointerException();
            }
            this.r = r;
            this.timestamp = System.currentTimeMillis();
            if (UtilDebug.SWING_INVOKE.show()) {
                LogSupport.message(this, "<init>", "Queuing: " + this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (UtilDebug.SWING_INVOKE.show()) {
                    LogSupport.message(this, "run", "Starting: " + this);
                }
                this.r.run();
            }
            catch (Throwable t) {
                LogSupport.exception(this.r, "run", t, true);
            }
            finally {
                if (UtilDebug.SWING_INVOKE.show()) {
                    LogSupport.message(this, "run", "Finished: " + this);
                }
            }
        }

        public String toString() {
            return "age=" + (System.currentTimeMillis() - this.timestamp) + " " + this.r.getClass().getName() + "@" + System.identityHashCode(this.r);
        }
    }
}

