/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class StopWatchTimer {
    private static HashMap map = new HashMap();
    public static final StopWatchTimer Global = new StopWatchTimer("Global");
    private String name = null;
    private long total = 0L;
    private int count = 0;
    private long min = Integer.MAX_VALUE;
    private long max = -1L;
    private long startTime = -1L;
    private long prevElapsed = -1L;
    private ArrayList splits = new ArrayList();

    public StopWatchTimer() {
        this(null);
    }

    public StopWatchTimer(String name) {
        this.name = name;
    }

    public static StopWatchTimer findTimer(String label) {
        return (StopWatchTimer)map.get(label);
    }

    public static StopWatchTimer makeTimer(String label) {
        StopWatchTimer result = (StopWatchTimer)map.get(label);
        if (result == null) {
            result = new StopWatchTimer(label);
            if (label != null && label.length() > 0) {
                map.put(label, result);
            }
        }
        return result;
    }

    public static void deregister(String label) {
        map.remove(label);
    }

    public void deregister() {
        if (this.name != null) {
            StopWatchTimer.deregister(this.name);
        }
    }

    public void register() {
        if (this.name == null || this.name.length() == 0) {
            throw new IllegalStateException("StopWatchTimer has no name.");
        }
        Object check = map.get(this.name);
        if (check == this) {
            return;
        }
        if (check != null) {
            throw new RuntimeException("StopWatchTimer name is already registered: " + this.name);
        }
        map.put(this.name, this);
    }

    public static void displayAll(PrintStream strm) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            StopWatchTimer cur = (StopWatchTimer)map.get((String)it.next());
            strm.println(cur.toString());
        }
    }

    public static void displayAll() {
        StopWatchTimer.displayAll(System.out);
    }

    public static void resetAll() {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            StopWatchTimer cur = (StopWatchTimer)map.get((String)it.next());
            cur.reset();
        }
    }

    public final long getElapsed() {
        if (this.startTime <= 0L) {
            return this.prevElapsed;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public final long getTotalTime() {
        if (this.startTime > 0L) {
            return this.total + System.currentTimeMillis() - this.startTime;
        }
        return this.total;
    }

    public final int getStartCount() {
        if (this.startTime > 0L) {
            return this.count + 1;
        }
        return this.count;
    }

    public final int getStopCount() {
        return this.count;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isRunning() {
        return this.startTime > 0L;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public void stop() {
        if (this.startTime <= 0L) {
            return;
        }
        this.prevElapsed = System.currentTimeMillis() - this.startTime;
        if (this.prevElapsed < 0L) {
            this.prevElapsed = 0L;
        }
        this.total += this.prevElapsed;
        this.startTime = -1L;
        ++this.count;
        if (this.prevElapsed < this.min) {
            this.min = this.prevElapsed;
        }
        if (this.prevElapsed > this.max) {
            this.max = this.prevElapsed;
        }
    }

    public void createSplitTime() {
        this.createSplitTime("Split #" + (this.splits.size() + 1));
    }

    public void createSplitTime(String splitDesc) {
        this.splits.add(new SplitTime(splitDesc));
    }

    public void reset() {
        this.total = 0L;
        this.count = 0;
        this.min = Integer.MAX_VALUE;
        this.max = -1L;
        this.startTime = -1L;
        this.prevElapsed = -1L;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        if (this.name != null) {
            result.append(this.name + ": ");
        }
        result.append(this.getTotalTime() + " ms / " + this.getStartCount());
        if (this.count > 0) {
            result.append(" Last=" + this.getElapsed());
            result.append(" Avg=" + (double)((this.total * 100L + (long)(this.count / 2)) / (long)this.count) / 100.0 + " ms");
            result.append(" Min=" + this.min + " ms Max=" + this.max + " ms");
        }
        Iterator itr = this.splits.iterator();
        while (itr.hasNext()) {
            result.append("\n  " + itr.next());
        }
        return result.toString();
    }

    private class SplitTime {
        long splitStartTime;
        long splitTime = System.currentTimeMillis();
        String desc;

        SplitTime(String s) {
            if (StopWatchTimer.this.splits.size() > 0) {
                this.splitStartTime = ((SplitTime)((StopWatchTimer)StopWatchTimer.this).splits.get((int)(((StopWatchTimer)StopWatchTimer.this).splits.size() - 1))).splitTime;
                if (this.splitStartTime < StopWatchTimer.this.startTime) {
                    this.splitStartTime = StopWatchTimer.this.startTime;
                }
            } else {
                this.splitStartTime = StopWatchTimer.this.startTime;
                if (this.splitStartTime <= 0L) {
                    this.splitStartTime = this.splitTime;
                }
            }
            this.desc = s;
        }

        long getSplitElapsed() {
            return Math.max(0L, this.splitTime - this.splitStartTime);
        }

        public String toString() {
            return "split: " + this.desc + " -- " + this.getSplitElapsed() + " ms";
        }
    }
}

