/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.util;

import com.elluminate.util.PooledObject;
import com.elluminate.util.SimpleObjectPool;
import com.elluminate.util.UnpooledObjectPool;
import com.elluminate.util.UtilTuning;

public abstract class ObjectPool {
    public abstract PooledObject alloc();

    public PooledObject alloc(ThreadGroup grp) {
        return this.alloc();
    }

    public void free(PooledObject p) {
    }

    public ObjectPool get() {
        return this;
    }

    public ObjectPool get(ThreadGroup grp) {
        return this;
    }

    public static boolean isEnabled() {
        return UtilTuning.ObjectPoolMode.getIntValue() != 0;
    }

    public static ObjectPool getInstance(Class cls) {
        return ObjectPool.getInstance(cls, UtilTuning.ObjectPoolScavengeInterval.getIntValue());
    }

    public static ObjectPool getInstance(Class cls, long interval) {
        int mode = UtilTuning.ObjectPoolMode.getIntValue();
        switch (mode) {
            case 0: {
                return new UnpooledObjectPool(cls);
            }
        }
        return new SimpleObjectPool(cls, interval);
    }

    public static ObjectPool getInstance(Class cls, long interval, int size) {
        int mode = UtilTuning.ObjectPoolMode.getIntValue();
        switch (mode) {
            case 0: {
                return new UnpooledObjectPool(cls);
            }
        }
        return new SimpleObjectPool(cls, interval, size);
    }

    protected Class checkClass(Class cls) {
        if (!PooledObject.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Class " + cls.getName() + " does not implement PooledObject.");
        }
        try {
            PooledObject inst = (PooledObject)cls.newInstance();
            inst.poInit();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to instantiate class " + cls.getName() + "\n  " + ex);
        }
        return cls;
    }
}

